/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

class ProtectedBindings
implements Bindings {
    private final Bindings wrapped;
    private final Set<String> protectedKeys;

    ProtectedBindings(Bindings wrapped, Set<String> protectedKeys) {
        this.wrapped = wrapped;
        this.protectedKeys = protectedKeys;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.protectedKeys.contains(key)) {
            throw new IllegalArgumentException(String.format("Key %s is protected.", key));
        }
        return this.wrapped.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> toMerge) {
        for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
            if (!this.protectedKeys.contains(entry.getKey())) {
                this.wrapped.put(entry.getKey(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException(String.format("Key %s is protected.", entry.getKey()));
        }
    }

    @Override
    public Object remove(Object key) {
        if (this.protectedKeys.contains(key)) {
            throw new IllegalArgumentException(String.format("Key %s is protected.", key));
        }
        return this.wrapped.remove(key);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ProtectedBindings does not support clear()");
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.wrapped.entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.wrapped.keySet());
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.wrapped.values());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.wrapped.get(key);
    }
}

