/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.vendor=The Apache Software Foundation", "felix.webconsole.label=scriptingvariables", "felix.webconsole.title=Scripting Variables", "felix.webconsole.category=Sling"}, service={Servlet.class})
public class ScriptingVariablesConsolePlugin
extends AbstractWebConsolePlugin {
    protected static final String LABEL = "scriptingvariables";
    protected static final String TITLE = "Scripting Variables";
    private static final long serialVersionUID = 261709110347150295L;
    private static final String JS_RES_PATH = "scriptingvariables/ui/scriptingvariables.js";
    @Reference
    private ScriptEngineManager scriptEngineManager;

    public URL getResource(String path) {
        if (path.endsWith(JS_RES_PATH)) {
            return ((Object)((Object)this)).getClass().getResource("/scriptingvariables/ui/scriptingvariables.js");
        }
        return null;
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.append("<script type='text/javascript' src='").append(JS_RES_PATH).append("'></script>");
        pw.append("<div id='content'>");
        pw.append("<table class='content'  cellpadding='0' cellspacing='0' width='100%'>");
        pw.append("<tr><th colspan='3' class='content container'>Sling Scripting Variables</th></tr>");
        pw.append("<tr class='content'><td class='content' colspan='3'>Provide a resource path url and script engine (via extension) and then click on 'Retrieve Variables' to expose all script bindings variables for context 'request' which are available for that resource and script engine.</td></tr>");
        pw.append("<tr class='content'>");
        pw.append("<td class='content'>Resource Url (without selectors and extension)</td> ");
        pw.append("<td class='content' colspan='2'><input type ='text' name='form.path' placeholder='path' required='required' value='/' ");
        pw.append("class='input ui-state-default ui-corner-all inputText' size='50' pattern='^/{1}.*'></td></tr>");
        pw.append("<tr class='content'>");
        pw.append("<td class='content'>Script Engine</td> ");
        pw.append("<td class='content' colspan='2'><select name='form.extension'>");
        for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
            for (String extension : factory.getExtensions()) {
                pw.append("<option value='" + extension + "'>" + extension + " (" + factory.getEngineName() + ")</option>");
            }
        }
        pw.append("<option value=''>all (unfiltered)</option>");
        pw.append("</select> ");
        pw.append("<button type='button' id='submitButton'> Retrieve Variables </button></td></tr></table>");
        pw.append("<div id='response'></div>");
    }
}

