/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.Collection;
import java.util.List;
import javax.script.ScriptEngine;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.impl.DefaultSlingScript;
import org.apache.sling.scripting.core.impl.ServiceCache;
import org.apache.sling.scripting.core.impl.jsr223.SlingScriptEngineManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AdapterFactory.class, MimeTypeProvider.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Default SlingScriptResolver", "adaptables=org.apache.sling.api.resource.Resource", "adapters=org.apache.sling.api.scripting.SlingScript", "adapters=javax.servlet.Servlet", "adapter.condition=If the resource's path ends in an extension registered by a script engine."})
public class SlingScriptAdapterFactory
implements AdapterFactory,
MimeTypeProvider {
    private BundleContext bundleContext;
    public static final String BINDINGS_CONTEXT = "request";
    private ServiceCache serviceCache;
    @Reference
    private SlingScriptEngineManager scriptEngineManager;
    @Reference
    private BindingsValuesProvidersByContext bindingsValuesProviderTracker;
    @Reference
    private ScriptCache scriptCache;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Resource resource = (Resource)adaptable;
        String path = resource.getPath();
        String ext = path.substring(path.lastIndexOf(46) + 1);
        ScriptEngine engine = this.scriptEngineManager.getEngineByExtension(ext);
        if (engine != null) {
            Collection bindingsValuesProviders = this.bindingsValuesProviderTracker.getBindingsValuesProviders(engine.getFactory(), BINDINGS_CONTEXT);
            return (AdapterType)new DefaultSlingScript(this.bundleContext, resource, engine, bindingsValuesProviders, this.serviceCache, this.scriptCache);
        }
        return null;
    }

    public String getMimeType(String name) {
        List<String> mimeTypes;
        ScriptEngine se = this.scriptEngineManager.getEngineByExtension(name = name.substring(name.lastIndexOf(46) + 1));
        if (se != null && (mimeTypes = se.getFactory().getMimeTypes()) != null && mimeTypes.size() > 0) {
            return String.valueOf(mimeTypes.get(0));
        }
        return null;
    }

    public String getExtension(String mimeType) {
        List<String> extensions;
        ScriptEngine se = this.scriptEngineManager.getEngineByMimeType(mimeType);
        if (se != null && (extensions = se.getFactory().getExtensions()) != null && extensions.size() > 0) {
            return String.valueOf(extensions.get(0));
        }
        return null;
    }

    protected void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.serviceCache = new ServiceCache(this.bundleContext);
    }

    protected void deactivate(ComponentContext context) {
        this.serviceCache.dispose();
        this.serviceCache = null;
        this.bundleContext = null;
    }
}

