/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sample.slingshot.ratings.impl;

import java.util.HashMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.sample.slingshot.SlingshotUtil;
import org.apache.sling.sample.slingshot.ratings.RatingsService;
import org.osgi.service.component.annotations.Component;

@Component(service={RatingsService.class})
public class RatingsServiceImpl
implements RatingsService {
    public static final String RESOURCETYPE_RATINGS = "sling:Folder";

    @Override
    public String getRatingsResourcePath(Resource resource) {
        String contentPath = SlingshotUtil.getContentPath(resource);
        if (contentPath != null) {
            String fullPath = "/slingshot/users/" + SlingshotUtil.getUserId(resource) + "/ugc/ratings" + contentPath;
            return fullPath;
        }
        return null;
    }

    @Override
    public double getRating(Resource resource) {
        Resource ratingsResource;
        String fullPath = this.getRatingsResourcePath(resource);
        float rating = 0.0f;
        if (fullPath != null && (ratingsResource = resource.getChild(fullPath)) != null) {
            int count = 0;
            for (Resource r : ratingsResource.getChildren()) {
                ValueMap vm = r.getValueMap();
                double current = (Double)vm.get("rating", (Object)0.0);
                rating = (float)((double)rating + current);
                ++count;
            }
            if (count > 0) {
                rating /= (float)count;
            }
        }
        return rating;
    }

    @Override
    public double getRating(Resource resource, String userId) {
        String fullPath = this.getRatingsResourcePath(resource);
        double rating = 0.0;
        Resource r = resource.getResourceResolver().getResource(fullPath + "/" + userId);
        if (r != null) {
            ValueMap vm = r.getValueMap();
            rating = (Double)vm.get("rating", (Object)0.0);
        }
        return rating;
    }

    @Override
    public void setRating(Resource resource, String userId, double rating) throws PersistenceException {
        String ratingsPath = this.getRatingsResourcePath(resource);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sling:resourceType", RESOURCETYPE_RATINGS);
        Resource ratingsResource = ResourceUtil.getOrCreateResource((ResourceResolver)resource.getResourceResolver(), (String)ratingsPath, props, null, (boolean)true);
        Resource ratingRsrc = resource.getResourceResolver().getResource(ratingsResource, userId);
        if (ratingRsrc == null) {
            props.clear();
            props.put("sling:resourceType", "slingshot/Rating");
            props.put("rating", String.valueOf(rating));
            resource.getResourceResolver().create(ratingsResource, userId, props);
        } else {
            ModifiableValueMap mvm = (ModifiableValueMap)ratingRsrc.adaptTo(ModifiableValueMap.class);
            mvm.put((Object)"rating", (Object)String.valueOf(rating));
        }
        resource.getResourceResolver().commit();
    }
}

