/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sample.slingshot.comments.impl;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.sample.slingshot.SlingshotUtil;
import org.apache.sling.sample.slingshot.comments.Comment;
import org.apache.sling.sample.slingshot.comments.CommentsService;
import org.apache.sling.sample.slingshot.impl.Util;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CommentsService.class})
public class CommentsServiceImpl
implements CommentsService {
    public static final String RESOURCETYPE_COMMENTS = "sling:OrderedFolder";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getCommentsResourcePath(Resource resource) {
        String contentPath = SlingshotUtil.getContentPath(resource);
        if (contentPath != null) {
            String fullPath = "/slingshot/users/" + SlingshotUtil.getUserId(resource) + "/ugc/comments" + contentPath;
            return fullPath;
        }
        return null;
    }

    @Override
    public void addComment(Resource resource, Comment c) throws PersistenceException {
        String commentsPath = this.getCommentsResourcePath(resource);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sling:resourceType", RESOURCETYPE_COMMENTS);
        Resource ratingsResource = ResourceUtil.getOrCreateResource((ResourceResolver)resource.getResourceResolver(), (String)commentsPath, props, null, (boolean)true);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sling:resourceType", "slingshot/Comment");
        properties.put("title", c.getTitle());
        properties.put("text", c.getText());
        properties.put("user", c.getCreatedBy());
        PersistenceException exception = null;
        Resource newResource = null;
        for (int i = 0; i < 5; ++i) {
            try {
                exception = null;
                String name = ResourceUtil.createUniqueChildName((Resource)ratingsResource, (String)Util.filter(c.getTitle()));
                newResource = resource.getResourceResolver().create(ratingsResource, name, properties);
                resource.getResourceResolver().commit();
                break;
            }
            catch (PersistenceException pe) {
                resource.getResourceResolver().revert();
                resource.getResourceResolver().refresh();
                exception = pe;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
        Node newNode = (Node)newResource.adaptTo(Node.class);
        if (newNode != null) {
            try {
                Node parent = newNode.getParent();
                Node firstNode = parent.getNodes().nextNode();
                if (!firstNode.getName().equals(newNode.getName())) {
                    parent.orderBefore(newNode.getName(), firstNode.getName());
                    newNode.getSession().save();
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to order comment to the top", (Throwable)re);
            }
        }
    }
}

