/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.rewriter.PipelineConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Processor;
import org.apache.sling.rewriter.ProcessorConfiguration;
import org.apache.sling.rewriter.ProcessorManager;
import org.apache.sling.rewriter.impl.FactoryCache;
import org.apache.sling.rewriter.impl.PipelineImpl;
import org.apache.sling.rewriter.impl.ProcessorConfigurationImpl;
import org.apache.sling.rewriter.impl.ProcessorWrapper;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ProcessorManager.class, ResourceChangeListener.class}, property={"service.vendor=The Apache Software Foundation", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED", "resource.change.types=PROVIDER_ADDED", "resource.change.types=PROVIDER_REMOVED", "resource.paths=glob:*/config/rewriter/**", "felix.webconsole.label=slingrewriter", "felix.webconsole.title=Sling Rewriter", "felix.webconsole.configprinter.modes=always"})
public class ProcessorManagerImpl
implements ProcessorManager,
ResourceChangeListener,
ExternalResourceChangeListener {
    static final String CONFIG_REL_PATH = "config/rewriter";
    static final String CONFIG_PATH = "/config/rewriter";
    protected static final String MIME_TYPE_HTML = "text/html";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ServiceUserMapped serviceUserMapped;
    private final Map<String, ConfigEntry[]> processors = new HashMap<String, ConfigEntry[]>();
    private final List<ProcessorConfiguration> orderedProcessors = new ArrayList<ProcessorConfiguration>();
    private String[] searchPath;
    private FactoryCache factoryCache;

    @Activate
    protected void activate(BundleContext ctx) throws LoginException, InvalidSyntaxException {
        this.factoryCache = new FactoryCache(ctx);
        this.searchPath = this.initProcessors();
        this.factoryCache.start();
    }

    private ResourceResolver createResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    protected void deactivate(ComponentContext ctx) {
        this.factoryCache.stop();
        this.factoryCache = null;
    }

    public void onChange(List<ResourceChange> changes) {
        for (final ResourceChange change : changes) {
            int pattern;
            int firstSlash;
            String path = change.getPath();
            int foundPos = -1;
            for (String sPath : this.searchPath) {
                if (!path.startsWith(sPath)) continue;
                foundPos = sPath.length();
                break;
            }
            boolean handled = false;
            if (foundPos != -1 && (firstSlash = path.indexOf(47, foundPos)) == (pattern = path.indexOf(CONFIG_PATH, foundPos)) && firstSlash != -1 && path.length() > pattern + CONFIG_PATH.length() && path.charAt(pattern + CONFIG_PATH.length()) == '/') {
                int slashPos = path.indexOf(47, pattern + CONFIG_PATH.length() + 1);
                if (slashPos != -1) {
                    path = path.substring(0, slashPos);
                }
                final String configPath = path;
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (change.getType() == ResourceChange.ChangeType.REMOVED) {
                            ProcessorManagerImpl.this.removeProcessor(configPath);
                        } else {
                            ProcessorManagerImpl.this.updateProcessor(configPath);
                        }
                    }
                };
                t.start();
                handled = true;
            }
            if (handled || change.getType() != ResourceChange.ChangeType.REMOVED) continue;
            Thread t = new Thread(){

                @Override
                public void run() {
                    ProcessorManagerImpl.this.checkRemoval(change.getPath());
                }
            };
            t.start();
        }
    }

    private String[] initProcessors() throws LoginException {
        try (ResourceResolver resolver = this.createResourceResolver();){
            for (String path : resolver.getSearchPath()) {
                Resource spResource = resolver.getResource(path.substring(0, path.length() - 1));
                if (spResource == null) continue;
                Iterator spIter = spResource.listChildren();
                while (spIter.hasNext()) {
                    Resource appResource = (Resource)spIter.next();
                    Resource parentResource = resolver.getResource(appResource.getPath() + CONFIG_PATH);
                    if (parentResource == null) continue;
                    Iterator iter = parentResource.listChildren();
                    while (iter.hasNext()) {
                        Resource configResource = (Resource)iter.next();
                        String key = configResource.getName();
                        ProcessorConfigurationImpl config = this.getProcessorConfiguration(configResource);
                        this.log.debug("Found new processor configuration {}", (Object)config);
                        this.addProcessor(key, configResource.getPath(), config);
                    }
                }
            }
            String[] stringArray = resolver.getSearchPath();
            return stringArray;
        }
    }

    private ProcessorConfigurationImpl getProcessorConfiguration(Resource configResource) {
        ProcessorConfigurationImpl config = new ProcessorConfigurationImpl(configResource);
        return config;
    }

    protected void addProcessor(String key, String configPath, ProcessorConfigurationImpl config) {
        ConfigEntry[] configs = this.processors.get(key);
        if (configs == null) {
            configs = new ConfigEntry[]{new ConfigEntry(configPath, config)};
        } else {
            ConfigEntry[] newConfigs = new ConfigEntry[configs.length + 1];
            System.arraycopy(configs, 0, newConfigs, 0, configs.length);
            newConfigs[configs.length] = new ConfigEntry(configPath, config);
        }
        this.processors.put(key, configs);
        if (config.isActive()) {
            this.orderedProcessors.add(config);
            Collections.sort(this.orderedProcessors, new ProcessorConfiguratorComparator());
        }
    }

    private void printConfiguration(PrintWriter pw, ConfigEntry entry) {
        if (entry.config instanceof ProcessorConfigurationImpl) {
            ((ProcessorConfigurationImpl)entry.config).printConfiguration(pw);
        } else {
            pw.println(entry.config.toString());
        }
        pw.print("Resource path: ");
        pw.println(entry.path);
    }

    public synchronized void printConfiguration(PrintWriter pw) {
        pw.println("Current Apache Sling Rewriter Configuration");
        pw.println("=================================================================");
        pw.println("Active Configurations");
        pw.println("-----------------------------------------------------------------");
        block0: for (ProcessorConfiguration config : this.orderedProcessors) {
            for (Map.Entry<String, ConfigEntry[]> entry : this.processors.entrySet()) {
                if (entry.getValue().length <= 0 || entry.getValue()[0].config != config) continue;
                pw.print("Configuration ");
                pw.println(entry.getKey());
                pw.println();
                this.printConfiguration(pw, entry.getValue()[0]);
                if (entry.getValue().length > 1) {
                    pw.println("Overriding configurations from the following resource paths: ");
                    for (int i = 1; i < entry.getValue().length; ++i) {
                        pw.print("- ");
                        pw.println(entry.getValue()[i].path);
                    }
                }
                pw.println();
                pw.println();
                continue block0;
            }
        }
    }

    private synchronized void updateProcessor(String path) {
        int pos = path.lastIndexOf(47);
        String key = path.substring(pos + 1);
        int keyIndex = 0;
        for (String sp : this.searchPath) {
            if (path.startsWith(sp)) break;
            ++keyIndex;
        }
        try (ResourceResolver resolver = this.createResourceResolver();){
            Resource configResource = resolver.getResource(path);
            if (configResource == null) {
                return;
            }
            ProcessorConfigurationImpl config = this.getProcessorConfiguration(configResource);
            ConfigEntry[] configs = this.processors.get(key);
            if (configs != null) {
                int index = -1;
                for (int i = 0; i < configs.length; ++i) {
                    if (!configs[i].path.equals(path)) continue;
                    index = i;
                    break;
                }
                if (index != -1) {
                    if (index == 0) {
                        this.orderedProcessors.remove(configs[index].config);
                        configs[index] = new ConfigEntry(path, config);
                        if (config.isActive()) {
                            this.orderedProcessors.add(config);
                            Collections.sort(this.orderedProcessors, new ProcessorConfiguratorComparator());
                        }
                    } else {
                        configs[index] = new ConfigEntry(path, config);
                    }
                } else {
                    int insertIndex = 0;
                    boolean found = false;
                    while (!found && insertIndex < configs.length) {
                        ConfigEntry current = configs[insertIndex];
                        int currentIndex = -1;
                        for (int i = 0; i < this.searchPath.length; ++i) {
                            if (!current.path.startsWith(this.searchPath[i])) continue;
                            currentIndex = i;
                            break;
                        }
                        if (currentIndex < keyIndex) continue;
                        found = true;
                        insertIndex = currentIndex;
                    }
                    if (!found) {
                        this.addProcessor(key, path, config);
                    } else {
                        ConfigEntry[] newArray = new ConfigEntry[configs.length + 1];
                        int i = 0;
                        for (ConfigEntry current : configs) {
                            if (i == insertIndex) {
                                newArray[i] = new ConfigEntry(path, config);
                                ++i;
                            }
                            newArray[i] = current;
                            ++i;
                        }
                        this.processors.put(key, newArray);
                        if (insertIndex == 0) {
                            this.orderedProcessors.remove(configs[1].config);
                            if (config.isActive()) {
                                this.orderedProcessors.add(config);
                                Collections.sort(this.orderedProcessors, new ProcessorConfiguratorComparator());
                            }
                        }
                    }
                }
            } else {
                this.addProcessor(key, path, config);
            }
        }
        catch (LoginException le) {
            this.log.error("Unable to create resource resolver.", (Throwable)le);
        }
    }

    private synchronized void removeProcessor(String path) {
        int pos = path.lastIndexOf(47);
        String key = path.substring(pos + 1);
        ConfigEntry[] configs = this.processors.get(key);
        if (configs != null) {
            ConfigEntry found = null;
            for (ConfigEntry current : configs) {
                if (!current.path.equals(path)) continue;
                found = current;
                break;
            }
            if (found != null) {
                this.orderedProcessors.remove(found.config);
                if (configs.length == 1) {
                    this.processors.remove(key);
                } else {
                    if (found == configs[0]) {
                        this.orderedProcessors.add(configs[1].config);
                        Collections.sort(this.orderedProcessors, new ProcessorConfiguratorComparator());
                    }
                    ConfigEntry[] newArray = new ConfigEntry[configs.length - 1];
                    int index = 0;
                    for (ConfigEntry current : configs) {
                        if (current == found) continue;
                        newArray[index] = current;
                        ++index;
                    }
                    this.processors.put(key, newArray);
                }
            }
        }
    }

    private synchronized void checkRemoval(String path) {
        String prefix = path + "/";
        ArrayList<ConfigEntry> toRemove = new ArrayList<ConfigEntry>();
        for (Map.Entry<String, ConfigEntry[]> entry : this.processors.entrySet()) {
            for (ConfigEntry config : entry.getValue()) {
                if (config.path == null || !config.path.startsWith(prefix)) continue;
                toRemove.add(config);
            }
        }
        for (ConfigEntry configEntry : toRemove) {
            this.removeProcessor(configEntry.path);
        }
    }

    @Override
    public Processor getProcessor(ProcessorConfiguration configuration, ProcessingContext context) {
        if (configuration == null) {
            throw new IllegalArgumentException("Processor configuration is missing.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Processor context is missing.");
        }
        boolean isPipeline = false;
        isPipeline = configuration instanceof ProcessorConfigurationImpl ? ((ProcessorConfigurationImpl)configuration).isPipeline() : configuration instanceof PipelineConfiguration;
        try {
            if (isPipeline) {
                PipelineImpl pipeline = new PipelineImpl(this.factoryCache);
                pipeline.init(context, configuration);
                return pipeline;
            }
            ProcessorWrapper processor = new ProcessorWrapper(configuration, this.factoryCache);
            processor.init(context, configuration);
            return processor;
        }
        catch (IOException ioe) {
            throw new SlingException("Unable to setup processor: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    @Override
    public List<ProcessorConfiguration> getProcessorConfigurations() {
        return this.orderedProcessors;
    }

    public static final class ConfigEntry {
        public final String path;
        public final ProcessorConfiguration config;

        public ConfigEntry(String p, ProcessorConfiguration pc) {
            this.path = p;
            this.config = pc;
        }
    }

    protected static final class ProcessorConfiguratorComparator
    implements Comparator<ProcessorConfiguration> {
        protected ProcessorConfiguratorComparator() {
        }

        @Override
        public int compare(ProcessorConfiguration config0, ProcessorConfiguration config1) {
            int o1;
            int o0 = ((ProcessorConfigurationImpl)config0).getOrder();
            if (o0 == (o1 = ((ProcessorConfigurationImpl)config1).getOrder())) {
                return 0;
            }
            if (o0 < o1) {
                return 1;
            }
            return -1;
        }
    }
}

