/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.rewriter.impl.FactoryCache;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class HashingServiceTrackerCustomizer<T>
extends ServiceTracker {
    private final Map<String, Entry<T>> services = new ConcurrentHashMap<String, Entry<T>>();
    protected final BundleContext context;

    public HashingServiceTrackerCustomizer(BundleContext bc, String serviceClassName) {
        super(bc, serviceClassName, null);
        this.context = bc;
    }

    public T getFactory(String type) {
        Entry<T> entry = this.services.get(type);
        return entry == null ? null : (T)entry.service;
    }

    private String getType(ServiceReference ref) {
        String type = (String)ref.getProperty("pipeline.type");
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        Object factory;
        String type = this.getType(reference);
        Object object = factory = type == null ? null : this.context.getService(reference);
        if (factory != null) {
            if (FactoryCache.LOGGER.isDebugEnabled()) {
                FactoryCache.LOGGER.debug("Found service {}, type={}.", factory, (Object)type);
            }
            HashingServiceTrackerCustomizer hashingServiceTrackerCustomizer = this;
            synchronized (hashingServiceTrackerCustomizer) {
                Entry<Object> entry = this.services.get(type);
                if (entry == null) {
                    entry = new Entry();
                    this.services.put(type, entry);
                }
                entry.add(reference, factory);
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        String type = this.getType(reference);
        if (type != null) {
            HashingServiceTrackerCustomizer hashingServiceTrackerCustomizer = this;
            synchronized (hashingServiceTrackerCustomizer) {
                Entry<T> entry = this.services.get(type);
                if (entry != null) {
                    entry.remove(reference);
                }
            }
            this.context.ungetService(reference);
        }
    }

    public static final class Entry<T> {
        public volatile T service;
        public final List<Pair<T>> references = new ArrayList<Pair<T>>();

        public void add(ServiceReference ref, T service) {
            this.references.add(new Pair<T>(ref, service));
            Collections.sort(this.references, new Comparator<Pair<T>>(){

                @Override
                public int compare(Pair<T> o1, Pair<T> o2) {
                    return o2.reference.compareTo((Object)o1.reference);
                }
            });
            if (this.references.get((int)0).reference == ref) {
                this.service = service;
            }
        }

        public void remove(ServiceReference ref) {
            if (!this.references.isEmpty()) {
                boolean update = this.references.get((int)0).reference == ref;
                Iterator<Pair<T>> i = this.references.iterator();
                while (i.hasNext()) {
                    Pair<T> pair = i.next();
                    if (pair.reference != ref) continue;
                    i.remove();
                }
                if (update) {
                    this.service = this.references.isEmpty() ? null : this.references.get((int)0).service;
                }
            }
        }
    }

    public static final class Pair<T> {
        public final ServiceReference reference;
        public final T service;

        public Pair(ServiceReference r, T s) {
            this.reference = r;
            this.service = s;
        }
    }
}

