/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.resourceresolver.impl.mapping.BloomFilterUtils;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntries
implements MapEntriesHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_PREFIX = "jcr:content/";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    public static final String PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS = "sling:redirectStatus";
    public static final String PROP_VANITY_PATH = "sling:vanityPath";
    public static final String PROP_VANITY_ORDER = "sling:vanityOrder";
    private static final String VANITY_BLOOM_FILTER_NAME = "vanityBloomFilter.txt";
    private static final int VANITY_BLOOM_FILTER_MAX_ENTRIES = 10000000;
    private final Logger logger = LoggerFactory.getLogger(MapEntries.class);
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    public static final int DEFAULT_DEFAULT_VANITY_PATH_REDIRECT_STATUS = 302;
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ALIAS_BASE_QUERY_DEFAULT = "SELECT sling:alias FROM nt:base AS page";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile MapConfigurationProvider factory;
    private volatile ResourceResolver resolver;
    private volatile EventAdmin eventAdmin;
    private volatile ServiceRegistration<ResourceChangeListener> registration;
    private Map<String, List<MapEntry>> resolveMapsMap;
    private Collection<MapEntry> mapMaps;
    private Map<String, List<String>> vanityTargets;
    private Map<String, Map<String, String>> aliasMap;
    private final ReentrantLock initializing = new ReentrantLock();
    private final AtomicLong vanityCounter;
    private final File vanityBloomFilterFile;
    private byte[] vanityBloomFilter;
    private Timer timer;
    private final AtomicBoolean updateBloomFilterFile = new AtomicBoolean(false);
    private final StringInterpolationProvider stringInterpolationProvider;
    private final boolean useOptimizeAliasResolution;
    private final AtomicLong lastTimeLogged = new AtomicLong(-1L);
    private final long LOGGING_ERROR_PERIOD = 300000L;

    public MapEntries(MapConfigurationProvider factory, BundleContext bundleContext, EventAdmin eventAdmin, StringInterpolationProvider stringInterpolationProvider) throws LoginException, IOException {
        this.resolver = factory.getServiceResourceResolver(factory.getServiceUserAuthenticationInfo("mapping"));
        this.factory = factory;
        this.eventAdmin = eventAdmin;
        this.resolveMapsMap = Collections.singletonMap(GLOBAL_LIST_KEY, Collections.emptyList());
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptyMap();
        this.aliasMap = Collections.emptyMap();
        this.stringInterpolationProvider = stringInterpolationProvider;
        this.useOptimizeAliasResolution = this.doInit();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] paths = new String[factory.getObservationPaths().length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = factory.getObservationPaths()[i].getPath();
        }
        ((Dictionary)props).put("resource.paths", paths);
        this.log.info("Registering for {}", (Object)Arrays.toString(factory.getObservationPaths()));
        ((Dictionary)props).put("service.description", "Apache Sling Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.registration = bundleContext.registerService(ResourceChangeListener.class, (Object)this, props);
        this.vanityCounter = new AtomicLong(0L);
        this.vanityBloomFilterFile = bundleContext.getDataFile(VANITY_BLOOM_FILTER_NAME);
        this.initializeVanityPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doInit() {
        this.initializing.lock();
        try {
            ResourceResolver resolver = this.resolver;
            MapConfigurationProvider factory = this.factory;
            if (resolver == null || factory == null) {
                boolean bl = this.factory.isOptimizeAliasResolutionEnabled();
                return bl;
            }
            boolean isOptimizeAliasResolutionEnabled = this.factory.isOptimizeAliasResolutionEnabled();
            if (isOptimizeAliasResolutionEnabled) {
                try {
                    Map<String, Map<String, String>> loadedMap = this.loadAliases(resolver);
                    this.aliasMap = loadedMap;
                }
                catch (Exception e) {
                    this.logDisableAliasOptimization(e);
                    isOptimizeAliasResolutionEnabled = false;
                }
            }
            this.resolveMapsMap = new ConcurrentHashMap<String, List<MapEntry>>();
            this.doUpdateConfiguration();
            this.sendChangeEvent();
            boolean bl = isOptimizeAliasResolutionEnabled;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeVanityPaths() throws IOException {
        block11: {
            this.initializing.lock();
            try {
                if (!this.factory.isVanityPathEnabled()) break block11;
                if (this.vanityBloomFilterFile == null) {
                    throw new RuntimeException("This platform does not have file system support");
                }
                boolean createVanityBloomFilter = false;
                if (!this.vanityBloomFilterFile.exists()) {
                    this.log.debug("creating bloom filter file {}", (Object)this.vanityBloomFilterFile.getAbsolutePath());
                    this.vanityBloomFilter = this.createVanityBloomFilter();
                    this.updateBloomFilterFile.set(true);
                    this.persistBloomFilter();
                    createVanityBloomFilter = true;
                } else {
                    this.vanityBloomFilter = new byte[(int)this.vanityBloomFilterFile.length()];
                    try (DataInputStream dis = new DataInputStream(new FileInputStream(this.vanityBloomFilterFile));){
                        dis.readFully(this.vanityBloomFilter);
                    }
                }
                this.timer = new Timer("VanityPathBloomFilterUpdater", true);
                this.timer.schedule((TimerTask)new BloomFilterTask(), 60000L, 60000L);
                this.vanityTargets = this.loadVanityPaths(createVanityBloomFilter);
            }
            finally {
                this.initializing.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addResource(String path, AtomicBoolean resolverRefreshed) {
        this.initializing.lock();
        try {
            Resource resource;
            this.refreshResolverIfNecessary(resolverRefreshed);
            Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(path) : null;
            if (resource != null) {
                boolean changed = this.doAddVanity(resource);
                if (this.useOptimizeAliasResolution && resource.getValueMap().containsKey((Object)"sling:alias")) {
                    changed |= this.doAddAlias(resource);
                }
                boolean bl = changed;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateResource(String path, AtomicBoolean resolverRefreshed) {
        boolean isValidVanityPath = this.isValidVanityPath(path);
        if (this.useOptimizeAliasResolution || isValidVanityPath) {
            this.initializing.lock();
            try {
                Resource resource;
                this.refreshResolverIfNecessary(resolverRefreshed);
                Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(path) : null;
                if (resource != null) {
                    boolean changed = false;
                    if (isValidVanityPath) {
                        changed |= this.doRemoveVanity(path);
                        Resource contentRsrc = null;
                        if (!resource.getName().equals(JCR_CONTENT)) {
                            contentRsrc = resource.getChild(JCR_CONTENT);
                        }
                        changed |= this.doAddVanity(contentRsrc != null ? contentRsrc : resource);
                    }
                    if (this.useOptimizeAliasResolution) {
                        changed |= this.doUpdateAlias(resource);
                    }
                    boolean bl = changed;
                    return bl;
                }
            }
            finally {
                this.initializing.unlock();
            }
        }
        return false;
    }

    private boolean removeResource(String path, AtomicBoolean resolverRefreshed) {
        boolean changed = false;
        String actualContentPath = this.getActualContentPath(path);
        String actualContentPathPrefix = actualContentPath + "/";
        for (String target : this.vanityTargets.keySet()) {
            if (!target.startsWith(actualContentPathPrefix) && !target.equals(actualContentPath)) continue;
            changed |= this.removeVanityPath(target);
        }
        if (this.useOptimizeAliasResolution) {
            for (String contentPath : this.aliasMap.keySet()) {
                if (!path.startsWith(contentPath + "/") && !path.equals(contentPath) && !contentPath.startsWith(actualContentPathPrefix)) continue;
                changed |= this.removeAlias(contentPath, path, resolverRefreshed);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAlias(String contentPath, String path, AtomicBoolean resolverRefreshed) {
        boolean handle = true;
        String resourcePath = null;
        if (path != null && path.length() > contentPath.length()) {
            String subPath = path.substring(contentPath.length() + 1);
            int firstSlash = subPath.indexOf(47);
            if (firstSlash == -1) {
                if (subPath.equals(JCR_CONTENT)) {
                    handle = false;
                }
                resourcePath = path;
            } else if (subPath.lastIndexOf(47) == firstSlash) {
                if (subPath.startsWith(JCR_CONTENT_PREFIX) || !subPath.endsWith(JCR_CONTENT_SUFFIX)) {
                    handle = false;
                }
                resourcePath = ResourceUtil.getParent((String)path);
            } else {
                handle = false;
            }
        } else {
            resourcePath = contentPath;
        }
        if (!handle) {
            return false;
        }
        this.initializing.lock();
        try {
            Map<String, String> aliasMapEntry = this.aliasMap.get(contentPath);
            if (aliasMapEntry != null) {
                Resource containingResource;
                this.refreshResolverIfNecessary(resolverRefreshed);
                Iterator<Map.Entry<String, String>> iterator = aliasMapEntry.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    String prefix = contentPath.endsWith("/") ? contentPath : contentPath + "/";
                    if (!(prefix + entry.getValue()).startsWith(resourcePath)) continue;
                    iterator.remove();
                }
                if (aliasMapEntry.isEmpty()) {
                    this.aliasMap.remove(contentPath);
                }
                Resource resource = containingResource = this.resolver != null ? this.resolver.getResource(resourcePath) : null;
                if (containingResource != null) {
                    Resource child;
                    if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                        this.doAddAlias(containingResource);
                    }
                    if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                        this.doAddAlias(child);
                    }
                }
            }
            boolean bl = aliasMapEntry != null;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    private boolean removeVanityPath(String path) {
        this.initializing.lock();
        try {
            boolean bl = this.doRemoveVanity(path);
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    private void doUpdateConfiguration() {
        ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
        TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
        this.loadResolverMap(this.resolver, globalResolveMap, newMapMaps);
        this.loadConfiguration(this.factory, globalResolveMap);
        this.loadMapConfiguration(this.factory, newMapMaps);
        Collections.sort(globalResolveMap);
        this.resolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
        this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
    }

    private boolean doAddVanity(Resource resource) {
        this.log.debug("doAddVanity getting {}", (Object)resource.getPath());
        boolean needsUpdate = false;
        needsUpdate = this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries() ? this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, true, true) : this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, false, true);
        if (needsUpdate) {
            this.updateBloomFilterFile.set(true);
            return true;
        }
        return false;
    }

    private boolean doRemoveVanity(String path) {
        String actualContentPath = this.getActualContentPath(path);
        List<String> l = this.vanityTargets.remove(actualContentPath);
        if (l != null) {
            for (String s : l) {
                List<MapEntry> entries = this.resolveMapsMap.get(s);
                if (entries != null) {
                    Iterator<MapEntry> iterator = entries.iterator();
                    while (iterator.hasNext()) {
                        MapEntry entry = iterator.next();
                        String redirect = this.getMapEntryRedirect(entry);
                        if (redirect == null || !redirect.equals(actualContentPath)) continue;
                        iterator.remove();
                    }
                }
                if (entries == null || !entries.isEmpty()) continue;
                this.resolveMapsMap.remove(s);
            }
            if (this.vanityCounter.longValue() > 0L) {
                this.vanityCounter.addAndGet(-2L);
            }
            return true;
        }
        return false;
    }

    private boolean doAddAlias(Resource resource) {
        return this.loadAlias(resource, this.aliasMap);
    }

    private boolean doUpdateAlias(Resource resource) {
        Resource containingResource = JCR_CONTENT.equals(resource.getName()) ? resource.getParent() : resource;
        if (containingResource != null) {
            Resource child;
            boolean changed;
            Map<String, String> aliasMapEntry;
            String containingResourceName = containingResource.getName();
            String parentPath = ResourceUtil.getParent((String)containingResource.getPath());
            Map<String, String> map = aliasMapEntry = parentPath == null ? null : this.aliasMap.get(parentPath);
            if (aliasMapEntry != null) {
                Iterator<Map.Entry<String, String>> iterator = aliasMapEntry.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!containingResourceName.equals(entry.getValue())) continue;
                    iterator.remove();
                }
            }
            if (aliasMapEntry != null && aliasMapEntry.isEmpty()) {
                this.aliasMap.remove(parentPath);
            }
            boolean bl = changed = aliasMapEntry != null;
            if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(containingResource);
            }
            if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(child);
            }
            return changed;
        }
        return false;
    }

    public void dispose() {
        boolean initLocked;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.persistBloomFilter();
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing intialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdmin = null;
    }

    @Override
    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return Collections.unmodifiableList(entries);
    }

    @Override
    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap, this.factory.hasVanityPathPrecedence());
    }

    @Override
    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    @Override
    public boolean isOptimizeAliasResolutionEnabled() {
        return this.useOptimizeAliasResolution;
    }

    @Override
    public Map<String, String> getAliasMap(String parentPath) {
        return this.aliasMap.get(parentPath);
    }

    @Override
    public Map<String, List<String>> getVanityPathMappings() {
        return Collections.unmodifiableMap(this.vanityTargets);
    }

    private List<MapEntry> getMapEntryList(String vanityPath) {
        List<MapEntry> mapEntries = null;
        if (BloomFilterUtils.probablyContains(this.vanityBloomFilter, vanityPath) && (mapEntries = this.resolveMapsMap.get(vanityPath)) == null) {
            Map<String, List<MapEntry>> mapEntry = this.getVanityPaths(vanityPath);
            mapEntries = mapEntry.get(vanityPath);
        }
        return mapEntries;
    }

    private void refreshResolverIfNecessary(AtomicBoolean resolverRefreshed) {
        if (resolverRefreshed.compareAndSet(false, true)) {
            this.resolver.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean handleConfigurationUpdate(String path, AtomicBoolean hasReloadedConfig, AtomicBoolean resolverRefreshed, boolean isDelete) {
        if (this.factory.isMapConfiguration(path) || isDelete && this.factory.getMapRoot().startsWith(path + "/")) {
            if (hasReloadedConfig.compareAndSet(false, true)) {
                this.initializing.lock();
                try {
                    if (this.resolver != null) {
                        this.refreshResolverIfNecessary(resolverRefreshed);
                        this.doUpdateConfiguration();
                    }
                }
                finally {
                    this.initializing.unlock();
                }
                return true;
            }
            return null;
        }
        return false;
    }

    public void onChange(List<ResourceChange> changes) {
        AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
        AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
        for (ResourceChange rc : changes) {
            Boolean result;
            String path = rc.getPath();
            this.log.debug("onChange, type={}, path={}", (Object)rc.getType(), (Object)path);
            if (path.startsWith(JCR_SYSTEM_PREFIX)) continue;
            boolean changed = false;
            if (rc.getType() == ResourceChange.ChangeType.REMOVED) {
                result = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, true);
                if (result != null) {
                    changed = result.booleanValue() ? true : (changed |= this.removeResource(path, resolverRefreshed));
                }
            } else if (rc.getType() == ResourceChange.ChangeType.ADDED) {
                result = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, false);
                if (result != null) {
                    changed = result.booleanValue() ? true : (changed |= this.addResource(path, resolverRefreshed));
                }
            } else if (rc.getType() == ResourceChange.ChangeType.CHANGED && (result = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, false)) != null) {
                changed = result.booleanValue() ? true : (changed |= this.updateResource(path, resolverRefreshed));
            }
            if (!changed) continue;
            this.sendChangeEvent();
        }
    }

    private byte[] createVanityBloomFilter() throws IOException {
        byte[] bloomFilter = null;
        if (this.vanityBloomFilter == null) {
            bloomFilter = BloomFilterUtils.createFilter(10000000, this.factory.getVanityBloomFilterMaxBytes());
        }
        return bloomFilter;
    }

    private void persistBloomFilter() {
        if (this.vanityBloomFilterFile != null && this.vanityBloomFilter != null && this.updateBloomFilterFile.getAndSet(false)) {
            try (FileOutputStream out = new FileOutputStream(this.vanityBloomFilterFile);){
                out.write(this.vanityBloomFilter);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while saving bloom filter to disk", e);
            }
        }
    }

    private boolean isAllVanityPathEntriesCached() {
        return this.factory.getMaxCachedVanityPathEntries() == -1L;
    }

    private static String escapeIllegalXpathSearchChars(String s) {
        StringBuilder sb = new StringBuilder();
        if (s != null && s.length() > 1) {
            sb.append(s.substring(0, s.length() - 1));
            char c = s.charAt(s.length() - 1);
            if (c == '!' || c == '(' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<MapEntry>> getVanityPaths(String vanityPath) {
        Map<String, List<MapEntry>> entryMap = new HashMap<String, List<MapEntry>>();
        String queryString = "SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM nt:base WHERE sling:vanityPath ='" + MapEntries.escapeIllegalXpathSearchChars(vanityPath).replaceAll("'", "''") + "' OR sling:vanityPath ='" + MapEntries.escapeIllegalXpathSearchChars(vanityPath.substring(1)).replaceAll("'", "''") + "' ORDER BY sling:vanityOrder DESC";
        try (ResourceResolver queryResolver = null;){
            queryResolver = this.factory.getServiceResourceResolver(this.factory.getServiceUserAuthenticationInfo("mapping"));
            Iterator i = queryResolver.findResources(queryString, "sql");
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                boolean isValid = false;
                for (Path sPath : this.factory.getObservationPaths()) {
                    if (!sPath.matches(resource.getPath())) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) continue;
                if (this.factory.isMaxCachedVanityPathEntriesStartup() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries()) {
                    this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, true, false);
                    entryMap = this.resolveMapsMap;
                    continue;
                }
                HashMap<String, List<String>> targetPaths = new HashMap<String, List<String>>();
                this.loadVanityPath(resource, entryMap, targetPaths, true, false);
            }
        }
        return entryMap;
    }

    private boolean isValidVanityPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Unexpected null path");
        }
        if (path.startsWith(JCR_SYSTEM_PREFIX)) {
            this.log.debug("isValidVanityPath: not valid {}", (Object)path);
            return false;
        }
        if (this.factory.getVanityPathConfig() != null) {
            boolean allowed = false;
            for (MapConfigurationProvider.VanityPathConfig config : this.factory.getVanityPathConfig()) {
                if (!path.startsWith(config.prefix)) continue;
                allowed = !config.isExclude;
                break;
            }
            if (!allowed) {
                this.log.debug("isValidVanityPath: not valid as not in white list {}", (Object)path);
                return false;
            }
        }
        return true;
    }

    private String getActualContentPath(String path) {
        String checkPath = path.endsWith(JCR_CONTENT_SUFFIX) ? ResourceUtil.getParent((String)path) : path;
        return checkPath;
    }

    private String getMapEntryRedirect(MapEntry mapEntry) {
        String[] redirect = mapEntry.getRedirect();
        if (redirect.length > 1) {
            this.log.warn("something went wrong, please restart the bundle");
            return null;
        }
        String path = redirect[0];
        if (path.endsWith("$1")) {
            path = path.substring(0, path.length() - "$1".length());
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - ".html".length());
        }
        return path;
    }

    private void sendChangeEvent() {
        EventAdmin local = this.eventAdmin;
        if (local != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            local.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.factory.getMapRoot());
        if (res != null) {
            this.gather(resolver, entries, mapEntries, res, "");
        }
    }

    private void gather(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get(PROP_REG_EXP, String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = child.getName().concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name = this.stringInterpolationProvider.substitute(name))).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, entries, mapEntries, child, childParent);
            }
            MapEntry childResolveEntry = null;
            try {
                childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash);
            }
            catch (IllegalArgumentException iae) {
                this.log.debug("ignored entry due exception ", (Throwable)iae);
            }
            if (childResolveEntry != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private boolean addEntry(Map<String, List<MapEntry>> entryMap, String key, MapEntry entry) {
        if (entry == null) {
            return false;
        }
        List<MapEntry> entries = entryMap.get(key);
        if (entries == null) {
            entries = new ArrayList<MapEntry>();
            entries.add(entry);
            Collections.sort(entries);
            entryMap.put(key, entries);
        } else {
            ArrayList<MapEntry> entriesCopy = new ArrayList<MapEntry>(entries);
            entriesCopy.add(entry);
            Collections.sort(entriesCopy);
            entryMap.put(key, entriesCopy);
        }
        return true;
    }

    private Map<String, Map<String, String>> loadAliases(ResourceResolver resolver) {
        ConcurrentHashMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>();
        String queryString = this.updateAliasQuery();
        Iterator i = resolver.findResources(queryString, "sql");
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            this.loadAlias(resource, map);
        }
        return map;
    }

    private String updateAliasQuery() {
        Set<String> allowedLocations = this.factory.getAllowedAliasLocations();
        StringBuilder baseQuery = new StringBuilder(ALIAS_BASE_QUERY_DEFAULT);
        baseQuery.append(" ").append("WHERE");
        if (allowedLocations.isEmpty()) {
            String jcrSystemPath = StringUtils.removeEnd((String)JCR_SYSTEM_PREFIX, (String)"/");
            baseQuery.append(" ").append("(").append("NOT ISDESCENDANTNODE(page,").append("\"").append(jcrSystemPath).append("\"").append("))");
        } else {
            Iterator<String> pathIterator = allowedLocations.iterator();
            baseQuery.append("(");
            while (pathIterator.hasNext()) {
                String prefix = pathIterator.next();
                baseQuery.append(" ").append("ISDESCENDANTNODE(page,").append("\"").append(prefix).append("\"").append(")").append(" ").append("OR");
            }
            int orLastIndex = baseQuery.lastIndexOf("OR");
            baseQuery.delete(orLastIndex, baseQuery.length());
            baseQuery.append(")");
        }
        baseQuery.append(" AND sling:alias IS NOT NULL");
        String aliasQuery = baseQuery.toString();
        this.logger.debug("Query to fetch alias [{}] ", (Object)aliasQuery);
        return aliasQuery;
    }

    private boolean loadAlias(Resource resource, Map<String, Map<String, String>> map) {
        ValueMap props;
        String[] aliasArray;
        String resourceName;
        String parentPath;
        if (resource.getPath() == null) {
            throw new IllegalArgumentException("Unexpected null path");
        }
        if (JCR_CONTENT.equals(resource.getName())) {
            Resource containingResource = resource.getParent();
            if (containingResource != null) {
                Resource parent = containingResource.getParent();
                if (parent != null) {
                    parentPath = parent.getPath();
                    resourceName = containingResource.getName();
                } else {
                    parentPath = null;
                    resourceName = null;
                }
            } else {
                parentPath = null;
                resourceName = null;
            }
        } else {
            Resource parent = resource.getParent();
            if (parent != null) {
                parentPath = parent.getPath();
                resourceName = resource.getName();
            } else {
                parentPath = null;
                resourceName = null;
            }
        }
        boolean hasAlias = false;
        if (parentPath != null && (aliasArray = (String[])(props = resource.getValueMap()).get("sling:alias", String[].class)) != null) {
            this.logger.debug("Found alias, total size {}", (Object)aliasArray.length);
            Map<String, String> parentMap = map.get(parentPath);
            for (String alias : aliasArray) {
                boolean invalid;
                if (parentMap != null && parentMap.containsKey(alias)) {
                    this.log.warn("Encountered duplicate alias {} under parent path {}. Refusing to replace current target {} with {}.", new Object[]{alias, parentPath, parentMap.get(alias), resourceName});
                    continue;
                }
                boolean bl = invalid = alias.equals("..") || alias.equals(".");
                if (!invalid) {
                    for (char c : alias.toCharArray()) {
                        if (c != '/' && c != '#' && c != '?') continue;
                        invalid = true;
                        break;
                    }
                }
                if (invalid) {
                    this.log.warn("Encountered invalid alias {} under parent path {}. Refusing to use it.", (Object)alias, (Object)parentPath);
                    continue;
                }
                if (parentMap == null) {
                    parentMap = new LinkedHashMap<String, String>();
                    map.put(parentPath, parentMap);
                }
                parentMap.put(alias, resourceName);
                hasAlias = true;
            }
        }
        return hasAlias;
    }

    private Map<String, List<String>> loadVanityPaths(boolean createVanityBloomFilter) {
        ConcurrentHashMap<String, List<String>> targetPaths = new ConcurrentHashMap<String, List<String>>();
        String queryString = "SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM nt:base WHERE sling:vanityPath IS NOT NULL";
        Iterator i = this.resolver.findResources("SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM nt:base WHERE sling:vanityPath IS NOT NULL", "sql");
        Supplier<Boolean> isCacheComplete = () -> this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries();
        while (i.hasNext() && (createVanityBloomFilter || isCacheComplete.get().booleanValue())) {
            Resource resource = (Resource)i.next();
            String resourcePath = resource.getPath();
            if (!Stream.of(this.factory.getObservationPaths()).anyMatch(path -> path.matches(resourcePath))) continue;
            this.loadVanityPath(resource, this.resolveMapsMap, targetPaths, isCacheComplete.get(), createVanityBloomFilter);
        }
        return targetPaths;
    }

    private boolean loadVanityPath(Resource resource, Map<String, List<MapEntry>> entryMap, Map<String, List<String>> targetPaths, boolean addToCache, boolean newVanity) {
        String[] pVanityPaths;
        if (!this.isValidVanityPath(resource.getPath())) {
            return false;
        }
        ValueMap props = resource.getValueMap();
        long vanityOrder = (Long)props.get(PROP_VANITY_ORDER, (Object)0L);
        boolean hasVanityPath = false;
        for (String pVanityPath : pVanityPaths = (String[])props.get(PROP_VANITY_PATH, (Object)new String[0])) {
            String[] result = this.getVanityPathDefinition(pVanityPath);
            if (result == null) continue;
            hasVanityPath = true;
            String url = result[0] + result[1];
            Resource redirectTarget = JCR_CONTENT.equals(resource.getName()) ? resource.getParent() : resource;
            String redirect = redirectTarget.getPath();
            String redirectName = redirectTarget.getName();
            int status = (Boolean)props.get(PROP_REDIRECT_EXTERNAL, (Object)false) != false ? (Integer)props.get(PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, (Object)this.factory.getDefaultVanityPathRedirectStatus()) : -1;
            String checkPath = result[1];
            if (addToCache) {
                boolean addedEntry;
                if (redirectName.indexOf(46) > -1) {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, vanityOrder, redirect));
                    int idx = redirectName.lastIndexOf(46);
                    String extension = redirectName.substring(idx + 1);
                    addedEntry = this.addEntry(entryMap, checkPath, this.getMapEntry(url + "\\." + extension, status, false, vanityOrder, redirect));
                } else {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, vanityOrder, redirect + ".html"));
                    addedEntry = this.addEntry(entryMap, checkPath, this.getMapEntry(url + "(\\..*)", status, false, vanityOrder, redirect + "$1"));
                }
                if (!addedEntry) continue;
                this.updateTargetPaths(targetPaths, redirect, checkPath);
                if (entryMap == this.resolveMapsMap) {
                    this.vanityCounter.addAndGet(2L);
                }
                if (!newVanity) continue;
                BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
                continue;
            }
            if (!newVanity) continue;
            BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
        }
        return hasVanityPath;
    }

    private void updateTargetPaths(Map<String, List<String>> targetPaths, String key, String entry) {
        if (entry == null) {
            return;
        }
        List<String> entries = targetPaths.get(key);
        if (entries == null) {
            entries = new ArrayList<String>();
            targetPaths.put(key, entries);
        }
        entries.add(entry);
    }

    private String[] getVanityPathDefinition(String pVanityPath) {
        String info;
        String[] result = null;
        if (pVanityPath != null && (info = pVanityPath.trim()).length() > 0) {
            String prefix = null;
            String path = null;
            if (info.indexOf(":/") > -1) {
                try {
                    URL u = new URL(info);
                    prefix = u.getProtocol() + '/' + u.getHost() + '.' + u.getPort();
                    path = u.getPath();
                }
                catch (MalformedURLException e) {
                    this.log.warn("Ignoring malformed vanity path {}", (Object)pVanityPath);
                }
            } else {
                prefix = "^[^/]+/[^/]+";
                path = !info.startsWith("/") ? "/" + info : info;
            }
            if (prefix != null) {
                int lastSlash = path.lastIndexOf(47);
                int firstDot = path.indexOf(46, lastSlash + 1);
                if (firstDot != -1) {
                    path = path.substring(0, firstDot);
                    this.log.warn("Removing extension from vanity path {}", (Object)pVanityPath);
                }
                result = new String[]{prefix, path};
            }
        }
        return result;
    }

    private void loadConfiguration(MapConfigurationProvider factory, List<MapEntry> entries) {
        Mapping[] mappings;
        Map<?, ?> virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry<?, ?> virtualEntry : virtuals.entrySet()) {
                String string;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(string = (String)virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = string;
                MapEntry mapEntry = this.getMapEntry(url, -1, false, redirect);
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = this.getMapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, false, ((List)entry.getValue()).toArray(new String[0]));
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
    }

    private void loadMapConfiguration(MapConfigurationProvider factory, Map<String, MapEntry> entries) {
        Map<?, ?> virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry<?, ?> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = this.getMapEntry(path, status, false, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = this.getMapEntry(entry.getPattern(), entry.getStatus(), false, newRedir);
        }
        if (entry != null) {
            entries.put(path, entry);
        }
    }

    @Override
    public void logDisableAliasOptimization() {
        this.logDisableAliasOptimization(null);
    }

    private void logDisableAliasOptimization(Exception e) {
        if (e != null) {
            this.log.error("Unexpected problem during initialization of optimize alias resolution. Therefore disabling optimize alias resolution. Please fix the problem.", (Throwable)e);
        } else {
            long now = System.currentTimeMillis();
            if (now - this.lastTimeLogged.getAndSet(now) > 300000L) {
                this.log.error("A problem occured during initialization of optimize alias resolution. Optimize alias resolution is disabled. Check the logs for the reported problem.", (Throwable)e);
            }
        }
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, 0L, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, long order, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, order, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    final class BloomFilterTask
    extends TimerTask {
        BloomFilterTask() {
        }

        @Override
        public void run() {
            MapEntries.this.persistBloomFilter();
        }
    }

    private final class MapEntryIterator
    implements Iterator<MapEntry> {
        private final Map<String, List<MapEntry>> resolveMapsMap;
        private String key;
        private MapEntry next;
        private final Iterator<MapEntry> globalListIterator;
        private MapEntry nextGlobal;
        private Iterator<MapEntry> specialIterator;
        private MapEntry nextSpecial;
        private boolean vanityPathPrecedence;

        public MapEntryIterator(String startKey, Map<String, List<MapEntry>> resolveMapsMap, boolean vanityPathPrecedence) {
            this.key = startKey;
            this.resolveMapsMap = resolveMapsMap;
            this.globalListIterator = this.resolveMapsMap.get(MapEntries.GLOBAL_LIST_KEY).iterator();
            this.vanityPathPrecedence = vanityPathPrecedence;
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MapEntry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MapEntry result = this.next;
            this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            if (this.nextGlobal == null && this.globalListIterator.hasNext()) {
                this.nextGlobal = this.globalListIterator.next();
            }
            if (this.nextSpecial == null) {
                if (this.specialIterator != null && !this.specialIterator.hasNext()) {
                    this.specialIterator = null;
                }
                while (this.specialIterator == null && this.key != null) {
                    List<MapEntry> special;
                    int lastSlashPos = this.key.lastIndexOf(47);
                    int lastDotPos = this.key.indexOf(46, lastSlashPos);
                    if (lastDotPos != -1) {
                        this.key = this.key.substring(0, lastDotPos);
                    }
                    if ((special = MapEntries.this.isAllVanityPathEntriesCached() ? this.resolveMapsMap.get(this.key) : MapEntries.this.getMapEntryList(this.key)) != null) {
                        this.specialIterator = special.iterator();
                    }
                    if (this.key.length() > 1) {
                        int lastSlash = this.key.lastIndexOf("/");
                        if (lastSlash == 0) {
                            this.key = null;
                            continue;
                        }
                        this.key = this.key.substring(0, lastSlash);
                        continue;
                    }
                    this.key = null;
                }
                if (this.specialIterator != null && this.specialIterator.hasNext()) {
                    this.nextSpecial = this.specialIterator.next();
                }
            }
            if (this.nextSpecial == null) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else if (!this.vanityPathPrecedence) {
                if (this.nextGlobal == null) {
                    this.next = this.nextSpecial;
                    this.nextSpecial = null;
                } else if (this.nextGlobal.getPattern().length() >= this.nextSpecial.getPattern().length()) {
                    this.next = this.nextGlobal;
                    this.nextGlobal = null;
                } else {
                    this.next = this.nextSpecial;
                    this.nextSpecial = null;
                }
            } else {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            }
        }
    }
}

