/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Node<T> {
    private T value;
    private Map<String, Node<T>> children;

    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name);
    }

    public Node<T> getChild(String name) {
        if (this.children != null) {
            return this.children.get(name);
        }
        return null;
    }

    Node<T> addChild(String name) {
        if (this.children == null) {
            this.children = new HashMap<String, Node<T>>();
        }
        Node<T> newNode = new Node<T>();
        this.children.put(name, newNode);
        return newNode;
    }

    void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public Map<String, Node<T>> getChildren() {
        if (this.children == null) {
            return Collections.emptyMap();
        }
        return this.children;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "# value: " + this.value + " ]";
    }
}

