/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.BidiMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.resourceresolver.impl.JcrNamespaceMangler;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryActivator;
import org.apache.sling.resourceresolver.impl.ResourceResolverImpl;
import org.apache.sling.resourceresolver.impl.console.ResourceResolverWebConsolePlugin;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntries;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonResourceResolverFactoryImpl
implements ResourceResolverFactory,
MapConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CommonResourceResolverFactoryImpl.class);
    private MapEntriesHandler mapEntries = MapEntriesHandler.EMPTY;
    private ResourceResolverWebConsolePlugin plugin;
    private final ResourceResolverFactoryActivator activator;
    private ThreadLocal<Stack<WeakReference<ResourceResolver>>> resolverStackHolder = new ThreadLocal();
    private final AtomicBoolean isActive = new AtomicBoolean(true);
    private final ReferenceQueue<ResourceResolver> resolverReferenceQueue = new ReferenceQueue();
    private final Map<Integer, ResolverReference> refs = new ConcurrentHashMap<Integer, ResolverReference>();
    private final Thread refQueueThread;
    private boolean logUnclosedResolvers;
    private final Object optionalNamespaceMangler;

    public CommonResourceResolverFactoryImpl(ResourceResolverFactoryActivator activator) {
        this.activator = activator;
        this.logUnclosedResolvers = activator.isLogUnclosedResourceResolvers();
        this.refQueueThread = new Thread("Apache Sling Resource Resolver Finalizer Thread"){

            @Override
            public void run() {
                while (CommonResourceResolverFactoryImpl.this.isLive()) {
                    try {
                        ResolverReference ref = (ResolverReference)CommonResourceResolverFactoryImpl.this.resolverReferenceQueue.remove();
                        ref.close();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.refQueueThread.setDaemon(true);
        this.refQueueThread.start();
        JcrNamespaceMangler mangler = null;
        if (this.isMangleNamespacePrefixes()) {
            try {
                mangler = new JcrNamespaceMangler();
            }
            catch (Throwable t) {
                LOG.info("Unable to create JCR namespace mangler: {}", (Object)t.getMessage());
            }
        }
        this.optionalNamespaceMangler = mangler;
    }

    @Nonnull
    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> passedAuthenticationInfo) throws LoginException {
        this.checkIsLive();
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        authenticationInfo.put("provider.auth.admin", Boolean.TRUE);
        if (passedAuthenticationInfo != null) {
            authenticationInfo.putAll(passedAuthenticationInfo);
            authenticationInfo.remove("sling.service.subservice");
        }
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    @Nonnull
    public ResourceResolver getResourceResolver(Map<String, Object> passedAuthenticationInfo) throws LoginException {
        this.checkIsLive();
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        if (passedAuthenticationInfo != null) {
            authenticationInfo.putAll(passedAuthenticationInfo);
            authenticationInfo.remove("sling.service.bundle");
            authenticationInfo.remove("sling.service.subservice");
        }
        ResourceResolver result = this.getResourceResolverInternal(authenticationInfo, false);
        Stack<WeakReference<Object>> resolverStack = this.resolverStackHolder.get();
        if (resolverStack == null) {
            resolverStack = new Stack();
            this.resolverStackHolder.set(resolverStack);
        }
        resolverStack.push(new WeakReference<ResourceResolver>(result));
        return result;
    }

    public ResourceResolver getThreadResourceResolver() {
        if (!this.isLive()) {
            return null;
        }
        ResourceResolver result = null;
        Stack<WeakReference<ResourceResolver>> resolverStack = this.resolverStackHolder.get();
        if (resolverStack != null) {
            while (result == null && !resolverStack.isEmpty()) {
                result = (ResourceResolver)resolverStack.peek().get();
                if (result != null) continue;
                resolverStack.pop();
            }
        }
        return result;
    }

    public void register(ResourceResolver resolver, ResourceResolverControl ctrl) {
        this.refs.put(ctrl.hashCode(), new ResolverReference(resolver, this.resolverReferenceQueue, ctrl, this));
    }

    public void unregister(ResourceResolver resourceResolverImpl, ResourceResolverControl ctrl) {
        Stack<WeakReference<ResourceResolver>> resolverStack;
        this.unregisterControl(ctrl);
        ThreadLocal<Stack<WeakReference<ResourceResolver>>> tl = this.resolverStackHolder;
        if (tl != null && (resolverStack = tl.get()) != null) {
            Iterator i = resolverStack.iterator();
            while (i.hasNext()) {
                WeakReference ref = (WeakReference)i.next();
                if (ref.get() != null && ref.get() != resourceResolverImpl) continue;
                i.remove();
            }
            if (resolverStack.isEmpty()) {
                tl.remove();
            }
        }
    }

    ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        this.checkIsLive();
        return new ResourceResolverImpl(this, isAdmin, authenticationInfo);
    }

    private boolean unregisterControl(ResourceResolverControl ctrl) {
        boolean doCloseControl;
        ResolverReference reference = this.refs.remove(ctrl.hashCode());
        if (reference != null) {
            reference.clear();
        }
        boolean bl = doCloseControl = !ctrl.isClosed();
        if (doCloseControl) {
            ctrl.close();
        }
        return doCloseControl;
    }

    private void checkIsLive() throws LoginException {
        if (!this.isLive()) {
            throw new LoginException("ResourceResolverFactory is deactivated.");
        }
    }

    public MapEntriesHandler getMapEntries() {
        return this.mapEntries;
    }

    protected void activate(BundleContext bundleContext) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            this.plugin = new ResourceResolverWebConsolePlugin(bundleContext, this, this.activator.getRuntimeService());
        }
        catch (Throwable ignore) {
            logger.debug("activate: unable to setup web console plugin.", ignore);
        }
        try {
            this.mapEntries = new MapEntries(this, bundleContext, this.activator.getEventAdmin());
        }
        catch (Exception e) {
            logger.error("activate: Cannot access repository, failed setting up Mapping Support", (Throwable)e);
        }
    }

    protected void deactivate() {
        if (!this.isActive.compareAndSet(true, false)) {
            return;
        }
        this.refQueueThread.interrupt();
        if (this.plugin != null) {
            this.plugin.dispose();
            this.plugin = null;
        }
        if (this.mapEntries instanceof MapEntries) {
            ((MapEntries)this.mapEntries).dispose();
            this.mapEntries = MapEntries.EMPTY;
        }
        this.resolverStackHolder = null;
        ArrayList<ResolverReference> references = new ArrayList<ResolverReference>(this.refs.values());
        this.refs.clear();
        for (ResolverReference ref : references) {
            ref.close();
        }
    }

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.activator.getResourceDecoratorTracker();
    }

    public List<String> getSearchPath() {
        return this.activator.getSearchPath();
    }

    public boolean isMangleNamespacePrefixes() {
        return this.activator.isMangleNamespacePrefixes();
    }

    public Object getNamespaceMangler() {
        return this.optionalNamespaceMangler;
    }

    @Override
    public String getMapRoot() {
        return this.activator.getMapRoot();
    }

    @Override
    public boolean isMapConfiguration(String path) {
        return this.activator.isMapConfiguration(path);
    }

    @Override
    public Mapping[] getMappings() {
        return this.activator.getMappings();
    }

    public BidiMap getVirtualURLMap() {
        return this.activator.getVirtualURLMap();
    }

    @Override
    public int getDefaultVanityPathRedirectStatus() {
        return this.activator.getDefaultVanityPathRedirectStatus();
    }

    public ResourceAccessSecurityTracker getResourceAccessSecurityTracker() {
        return this.activator.getResourceAccessSecurityTracker();
    }

    @Nonnull
    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        this.checkIsLive();
        return this.getResourceResolverInternal(authenticationInfo, false);
    }

    @Override
    public boolean isVanityPathEnabled() {
        return this.activator.isVanityPathEnabled();
    }

    @Override
    public long getMaxCachedVanityPathEntries() {
        return this.activator.getMaxCachedVanityPathEntries();
    }

    @Override
    public boolean isMaxCachedVanityPathEntriesStartup() {
        return this.activator.isMaxCachedVanityPathEntriesStartup();
    }

    @Override
    public int getVanityBloomFilterMaxBytes() {
        return this.activator.getVanityBloomFilterMaxBytes();
    }

    @Override
    public boolean isOptimizeAliasResolutionEnabled() {
        return this.activator.isOptimizeAliasResolutionEnabled();
    }

    @Override
    public boolean hasVanityPathPrecedence() {
        return this.activator.hasVanityPathPrecedence();
    }

    @Override
    public Path[] getObservationPaths() {
        return this.activator.getObservationPaths();
    }

    @Override
    public List<MapConfigurationProvider.VanityPathConfig> getVanityPathConfig() {
        String[] includes = this.activator.getVanityPathWhiteList();
        String[] excludes = this.activator.getVanityPathBlackList();
        if (includes == null && excludes == null) {
            return null;
        }
        ArrayList<MapConfigurationProvider.VanityPathConfig> configs = new ArrayList<MapConfigurationProvider.VanityPathConfig>();
        if (includes != null) {
            for (String val : includes) {
                configs.add(new MapConfigurationProvider.VanityPathConfig(val, false));
            }
        }
        if (excludes != null) {
            for (String val : excludes) {
                configs.add(new MapConfigurationProvider.VanityPathConfig(val, true));
            }
        }
        Collections.sort(configs);
        return configs;
    }

    public boolean isLive() {
        return this.isActive.get();
    }

    public boolean shouldLogResourceResolverClosing() {
        return this.activator.shouldLogResourceResolverClosing();
    }

    public ResourceProviderTracker getResourceProviderTracker() {
        return this.activator.getResourceProviderTracker();
    }

    @Override
    public Map<String, Object> getServiceUserAuthenticationInfo(String subServiceName) throws LoginException {
        String userName;
        Bundle bundle = this.activator.getBundleContext().getBundle();
        ServiceUserMapper mapper = this.activator.getServiceUserMapper();
        Iterable principalNames = mapper.getServicePrincipalNames(bundle, subServiceName);
        String string = userName = principalNames == null ? mapper.getServiceUserID(bundle, subServiceName) : null;
        if (principalNames == null && userName == null) {
            throw new LoginException("Cannot derive user name or principal names for bundle " + bundle + " and sub service " + subServiceName);
        }
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        authenticationInfo.put("sling.service.subservice", subServiceName);
        authenticationInfo.put("sling.service.bundle", bundle);
        if (userName != null) {
            authenticationInfo.put("user.name", userName);
        }
        return authenticationInfo;
    }

    private static final class ResolverReference
    extends WeakReference<ResourceResolver> {
        private final ResourceResolverControl control;
        private final Exception openingException;
        private final CommonResourceResolverFactoryImpl factory;

        ResolverReference(ResourceResolver referent, ReferenceQueue<? super ResourceResolver> q, ResourceResolverControl ctrl, CommonResourceResolverFactoryImpl factory) {
            super(referent, q);
            this.control = ctrl;
            this.factory = factory;
            this.openingException = factory.logUnclosedResolvers && LOG.isInfoEnabled() ? new Exception("Opening Stacktrace") : null;
        }

        public void close() {
            try {
                if (this.factory.unregisterControl(this.control) && this.factory.logUnclosedResolvers) {
                    if (this.factory.isLive()) {
                        LOG.warn("Closed unclosed ResourceResolver. The creation stacktrace is available on info log level.");
                    } else {
                        LOG.warn("Forced close of ResourceResolver because the ResourceResolverFactory is shutting down.");
                    }
                    LOG.info("Unclosed ResourceResolver was created here: ", (Throwable)this.openingException);
                }
            }
            catch (Throwable t) {
                LOG.warn("Exception while closing ResolverReference", t);
            }
        }
    }
}

