/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.resourceresolver.impl;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.assertEquals;

import java.util.List;

public class VanityPathConfigurerTest {
    private VanityPathConfigurer vanityPathConfigurer;

    @Before
    public void before() {
        vanityPathConfigurer = new VanityPathConfigurer();
    }

    @Test
    public void testConfigureVanityPathPrefixes_givenBothPathPrefixAndFallBack_thenPathPrefixIsUsed() {
        String[] pathPrefixes = {"/some/path/"};
        String[] pathPrefixesFallback = {"/some/fallback/path/"};

        final List<String> result = vanityPathConfigurer.configureVanityPathPrefixes(pathPrefixes, pathPrefixesFallback,
            "original", "fallback");
        verifyResults(result, pathPrefixes);
    }

    @Test
    public void testConfigureVanityPathPrefixes_givenOnlyPathPrefix_thenPathPrefixIsUsed() {
        String[] pathPrefixes = {"/some/path/"};
        String[] pathPrefixesFallback = null;

        final List<String> result = vanityPathConfigurer.configureVanityPathPrefixes(pathPrefixes, pathPrefixesFallback,
            "original", "fallback");
        verifyResults(result, pathPrefixes);
    }

    @Test
    public void testConfigureVanityPathPrefixes_givenOnlyPathPrefixFallback_thenPathPrefixFallbackIsUsed() {
        String[] pathPrefixes = null;
        String[] pathPrefixesFallback = {"/some/fallback/path/"};

        final List<String> result = vanityPathConfigurer.configureVanityPathPrefixes(pathPrefixes, pathPrefixesFallback,
            "original", "fallback");
        verifyResults(result, pathPrefixesFallback);
    }

    private void verifyResults(List<String> actualResult, String[] expectedResults) {
        assertEquals(expectedResults.length, actualResult.size());
        for(int i=0; i<expectedResults.length; i++) {
            assertEquals(expectedResults[i], actualResult.get(i));
        }
    }

}
