/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.resourceresolver.impl.ResourceResolverMetrics;
import org.apache.sling.resourceresolver.impl.mapping.BloomFilterUtils;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntries
implements MapEntriesHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_PREFIX = "jcr:content/";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    public static final String PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS = "sling:redirectStatus";
    public static final String PROP_VANITY_PATH = "sling:vanityPath";
    public static final String PROP_VANITY_ORDER = "sling:vanityOrder";
    private static final int VANITY_BLOOM_FILTER_MAX_ENTRIES = 10000000;
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    public static final int DEFAULT_DEFAULT_VANITY_PATH_REDIRECT_STATUS = 302;
    private static final String JCR_SYSTEM_PATH = "/jcr:system";
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(MapEntries.class);
    private volatile MapConfigurationProvider factory;
    private volatile ResourceResolver resolver;
    private volatile EventAdmin eventAdmin;
    private Optional<ResourceResolverMetrics> metrics;
    private volatile ServiceRegistration<ResourceChangeListener> registration;
    private Map<String, List<MapEntry>> resolveMapsMap;
    private Map<String, List<MapEntry>> temporaryResolveMapsMap;
    private List<Map.Entry<String, ResourceChange.ChangeType>> resourceChangeQueue;
    private AtomicLong temporaryResolveMapsMapHits = new AtomicLong();
    private AtomicLong temporaryResolveMapsMapMisses = new AtomicLong();
    private Collection<MapEntry> mapMaps;
    private Map<String, List<String>> vanityTargets;
    private Map<String, Map<String, Collection<String>>> aliasMapsMap;
    private final AtomicLong aliasResourcesOnStartup;
    private final ReentrantLock initializing = new ReentrantLock();
    private final AtomicLong vanityCounter;
    private final AtomicLong vanityResourcesOnStartup;
    private final AtomicLong vanityPathLookups;
    private final AtomicLong vanityPathBloomNegative;
    private final AtomicLong vanityPathBloomFalsePositive;
    private byte[] vanityBloomFilter;
    private AtomicBoolean vanityPathsProcessed = new AtomicBoolean(false);
    private final StringInterpolationProvider stringInterpolationProvider;
    private final boolean useOptimizeAliasResolution;
    private static final List<MapEntry> NO_MAP_ENTRIES = Collections.emptyList();
    private final AtomicLong lastTimeLogged = new AtomicLong(-1L);
    private final long LOGGING_ERROR_PERIOD = 300000L;

    public MapEntries(MapConfigurationProvider factory, BundleContext bundleContext, EventAdmin eventAdmin, StringInterpolationProvider stringInterpolationProvider, Optional<ResourceResolverMetrics> metrics) throws LoginException, IOException {
        this.resolver = factory.getServiceResourceResolver(factory.getServiceUserAuthenticationInfo("mapping"));
        this.factory = factory;
        this.eventAdmin = eventAdmin;
        this.resolveMapsMap = Collections.singletonMap(GLOBAL_LIST_KEY, Collections.emptyList());
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptyMap();
        this.aliasMapsMap = new ConcurrentHashMap<String, Map<String, Collection<String>>>();
        this.stringInterpolationProvider = stringInterpolationProvider;
        this.aliasResourcesOnStartup = new AtomicLong(0L);
        this.useOptimizeAliasResolution = this.doInit();
        this.registration = this.registerResourceChangeListener(bundleContext);
        this.vanityCounter = new AtomicLong(0L);
        this.vanityResourcesOnStartup = new AtomicLong(0L);
        this.vanityPathLookups = new AtomicLong(0L);
        this.vanityPathBloomNegative = new AtomicLong(0L);
        this.vanityPathBloomFalsePositive = new AtomicLong(0L);
        this.initializeVanityPaths();
        this.metrics = metrics;
        if (metrics.isPresent()) {
            this.metrics.get().setNumberOfVanityPathsSupplier(this.vanityCounter::get);
            this.metrics.get().setNumberOfResourcesWithVanityPathsOnStartupSupplier(this.vanityResourcesOnStartup::get);
            this.metrics.get().setNumberOfVanityPathLookupsSupplier(this.vanityPathLookups::get);
            this.metrics.get().setNumberOfVanityPathBloomNegativeSupplier(this.vanityPathBloomNegative::get);
            this.metrics.get().setNumberOfVanityPathBloomFalsePositiveSupplier(this.vanityPathBloomFalsePositive::get);
            this.metrics.get().setNumberOfResourcesWithAliasedChildrenSupplier(() -> this.aliasMapsMap.size());
            this.metrics.get().setNumberOfResourcesWithAliasesOnStartupSupplier(this.aliasResourcesOnStartup::get);
        }
    }

    private ServiceRegistration<ResourceChangeListener> registerResourceChangeListener(BundleContext bundleContext) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] paths = new String[this.factory.getObservationPaths().length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.factory.getObservationPaths()[i].getPath();
        }
        ((Dictionary)props).put("resource.paths", paths);
        ((Dictionary)props).put("service.description", "Apache Sling Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.log.info("Registering for {}", (Object)Arrays.toString(this.factory.getObservationPaths()));
        this.resourceChangeQueue = Collections.synchronizedList(new LinkedList());
        return bundleContext.registerService(ResourceChangeListener.class, (Object)this, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doInit() {
        this.initializing.lock();
        try {
            ResourceResolver resolver = this.resolver;
            MapConfigurationProvider factory = this.factory;
            if (resolver == null || factory == null) {
                boolean bl = this.factory.isOptimizeAliasResolutionEnabled();
                return bl;
            }
            boolean isOptimizeAliasResolutionEnabled = this.factory.isOptimizeAliasResolutionEnabled();
            if (isOptimizeAliasResolutionEnabled) {
                try {
                    Map<String, Map<String, Collection<String>>> loadedMap = this.loadAliases(resolver);
                    this.aliasMapsMap = loadedMap;
                }
                catch (Exception e) {
                    this.logDisableAliasOptimization(e);
                    isOptimizeAliasResolutionEnabled = false;
                }
            }
            this.resolveMapsMap = new ConcurrentHashMap<String, List<MapEntry>>();
            this.doUpdateConfiguration();
            this.sendChangeEvent();
            boolean bl = isOptimizeAliasResolutionEnabled;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    protected void initializeVanityPaths() throws IOException {
        this.initializing.lock();
        try {
            if (this.factory.isVanityPathEnabled()) {
                this.vanityBloomFilter = this.createVanityBloomFilter();
                VanityPathInitializer vpi = new VanityPathInitializer(this.factory);
                if (this.factory.isVanityPathCacheInitInBackground()) {
                    this.log.debug("bg init starting");
                    Thread vpinit = new Thread((Runnable)vpi, "VanityPathInitializer");
                    vpinit.start();
                } else {
                    vpi.run();
                }
            }
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addResource(String path, AtomicBoolean resolverRefreshed) {
        this.initializing.lock();
        try {
            Resource resource;
            this.refreshResolverIfNecessary(resolverRefreshed);
            Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(path) : null;
            if (resource != null) {
                boolean changed = this.doAddVanity(resource);
                if (this.useOptimizeAliasResolution && resource.getValueMap().containsKey((Object)"sling:alias")) {
                    changed |= this.doAddAlias(resource);
                }
                boolean bl = changed;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateResource(String path, AtomicBoolean resolverRefreshed) {
        boolean isValidVanityPath = this.isValidVanityPath(path);
        if (this.useOptimizeAliasResolution || isValidVanityPath) {
            this.initializing.lock();
            try {
                Resource resource;
                this.refreshResolverIfNecessary(resolverRefreshed);
                Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(path) : null;
                if (resource != null) {
                    boolean changed = false;
                    if (isValidVanityPath) {
                        changed |= this.doRemoveVanity(path);
                        Resource contentRsrc = null;
                        if (!resource.getName().equals(JCR_CONTENT)) {
                            contentRsrc = resource.getChild(JCR_CONTENT);
                        }
                        changed |= this.doAddVanity(contentRsrc != null ? contentRsrc : resource);
                    }
                    if (this.useOptimizeAliasResolution) {
                        changed |= this.doUpdateAlias(resource);
                    }
                    boolean bl = changed;
                    return bl;
                }
            }
            finally {
                this.initializing.unlock();
            }
        }
        return false;
    }

    private boolean removeResource(String path, AtomicBoolean resolverRefreshed) {
        boolean changed = false;
        String actualContentPath = this.getActualContentPath(path);
        String actualContentPathPrefix = actualContentPath + "/";
        for (String target : this.vanityTargets.keySet()) {
            if (!target.startsWith(actualContentPathPrefix) && !target.equals(actualContentPath)) continue;
            changed |= this.removeVanityPath(target);
        }
        if (this.useOptimizeAliasResolution) {
            String pathPrefix = path + "/";
            for (String contentPath : this.aliasMapsMap.keySet()) {
                if (!path.startsWith(contentPath + "/") && !path.equals(contentPath) && !contentPath.startsWith(pathPrefix)) continue;
                changed |= this.removeAlias(contentPath, path, resolverRefreshed);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAlias(String contentPath, String path, AtomicBoolean resolverRefreshed) {
        String resourcePath;
        boolean handle = true;
        if (path != null && path.length() > contentPath.length()) {
            String subPath = path.substring(contentPath.length() + 1);
            int firstSlash = subPath.indexOf(47);
            if (firstSlash == -1) {
                if (subPath.equals(JCR_CONTENT)) {
                    handle = false;
                }
                resourcePath = path;
            } else if (subPath.lastIndexOf(47) == firstSlash) {
                if (subPath.startsWith(JCR_CONTENT_PREFIX) || !subPath.endsWith(JCR_CONTENT_SUFFIX)) {
                    handle = false;
                }
                resourcePath = ResourceUtil.getParent((String)path);
            } else {
                handle = false;
                resourcePath = null;
            }
        } else {
            resourcePath = contentPath;
        }
        if (!handle) {
            return false;
        }
        this.initializing.lock();
        try {
            Map<String, Collection<String>> aliasMapEntry = this.aliasMapsMap.get(contentPath);
            if (aliasMapEntry != null) {
                Resource containingResource;
                Object prefix;
                this.refreshResolverIfNecessary(resolverRefreshed);
                Object object = prefix = contentPath.endsWith("/") ? contentPath : contentPath + "/";
                if (aliasMapEntry.entrySet().removeIf(arg_0 -> MapEntries.lambda$removeAlias$1((String)prefix, resourcePath, arg_0)) && aliasMapEntry.isEmpty()) {
                    this.aliasMapsMap.remove(contentPath);
                }
                Resource resource = containingResource = this.resolver != null ? this.resolver.getResource(resourcePath) : null;
                if (containingResource != null) {
                    Resource child;
                    if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                        this.doAddAlias(containingResource);
                    }
                    if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                        this.doAddAlias(child);
                    }
                }
            }
            boolean bl = aliasMapEntry != null;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    private boolean removeVanityPath(String path) {
        this.initializing.lock();
        try {
            boolean bl = this.doRemoveVanity(path);
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    private void doUpdateConfiguration() {
        ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
        TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
        this.loadResolverMap(this.resolver, globalResolveMap, newMapMaps);
        this.loadConfiguration(this.factory, globalResolveMap);
        this.loadMapConfiguration(this.factory, newMapMaps);
        Collections.sort(globalResolveMap);
        this.resolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
        this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
    }

    private boolean doAddVanity(Resource resource) {
        this.log.debug("doAddVanity getting {}", (Object)resource.getPath());
        boolean updateTheCache = this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries();
        return null != this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, updateTheCache);
    }

    private boolean doRemoveVanity(String path) {
        String actualContentPath = this.getActualContentPath(path);
        List<String> l = this.vanityTargets.remove(actualContentPath);
        if (l != null) {
            for (String s : l) {
                List<MapEntry> entries = this.resolveMapsMap.get(s);
                if (entries != null) {
                    Iterator<MapEntry> iterator = entries.iterator();
                    while (iterator.hasNext()) {
                        MapEntry entry = iterator.next();
                        String redirect = this.getMapEntryRedirect(entry);
                        if (redirect == null || !redirect.equals(actualContentPath)) continue;
                        iterator.remove();
                    }
                }
                if (entries == null || !entries.isEmpty()) continue;
                this.resolveMapsMap.remove(s);
            }
            if (this.vanityCounter.longValue() > 0L) {
                this.vanityCounter.addAndGet(-2L);
            }
            return true;
        }
        return false;
    }

    private boolean doAddAlias(Resource resource) {
        return this.loadAlias(resource, this.aliasMapsMap);
    }

    private boolean doUpdateAlias(Resource resource) {
        Resource containingResource = JCR_CONTENT.equals(resource.getName()) ? resource.getParent() : resource;
        if (containingResource != null) {
            Resource child;
            boolean changed;
            Map<String, Collection<String>> aliasMapEntry;
            String containingResourceName = containingResource.getName();
            String parentPath = ResourceUtil.getParent((String)containingResource.getPath());
            Map<String, Collection<String>> map = aliasMapEntry = parentPath == null ? null : this.aliasMapsMap.get(parentPath);
            if (aliasMapEntry != null) {
                aliasMapEntry.remove(containingResourceName);
                if (aliasMapEntry.isEmpty()) {
                    this.aliasMapsMap.remove(parentPath);
                }
            }
            boolean bl = changed = aliasMapEntry != null;
            if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(containingResource);
            }
            if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(child);
            }
            return changed;
        }
        return false;
    }

    public void dispose() {
        boolean initLocked;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing intialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdmin = null;
    }

    @Override
    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return Collections.unmodifiableList(entries);
    }

    @Override
    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap, this.factory.hasVanityPathPrecedence());
    }

    @Override
    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    @Override
    public boolean isOptimizeAliasResolutionEnabled() {
        return this.useOptimizeAliasResolution;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getAliasMap(String parentPath) {
        Map<String, Collection<String>> aliasMapForParent = this.aliasMapsMap.get(parentPath);
        return aliasMapForParent != null ? aliasMapForParent : Collections.emptyMap();
    }

    @Override
    public Map<String, List<String>> getVanityPathMappings() {
        return Collections.unmodifiableMap(this.vanityTargets);
    }

    private List<MapEntry> getMapEntryList(String vanityPath) {
        List<MapEntry> mapEntries = null;
        boolean initFinished = this.vanityPathsProcessed.get();
        boolean probablyPresent = false;
        if (initFinished) {
            long current = this.vanityPathLookups.incrementAndGet();
            if (current >= 9223372036854675807L) {
                this.vanityPathLookups.set(1L);
                this.vanityPathBloomNegative.set(0L);
                this.vanityPathBloomFalsePositive.set(0L);
                this.log.info("Vanity Path metrics reset to 0");
            }
            probablyPresent = BloomFilterUtils.probablyContains(this.vanityBloomFilter, vanityPath);
            this.log.trace("bloom filter lookup for {} -> {}", (Object)vanityPath, (Object)probablyPresent);
            if (!probablyPresent) {
                this.vanityPathBloomNegative.incrementAndGet();
            }
        }
        if (!initFinished || probablyPresent) {
            mapEntries = this.resolveMapsMap.get(vanityPath);
            if (mapEntries == null) {
                if (!initFinished && this.temporaryResolveMapsMap != null) {
                    mapEntries = this.temporaryResolveMapsMap.get(vanityPath);
                    if (mapEntries != null) {
                        this.temporaryResolveMapsMapHits.incrementAndGet();
                        this.log.trace("getMapEntryList: using temp map entries for {} -> {}", (Object)vanityPath, mapEntries);
                    } else {
                        this.temporaryResolveMapsMapMisses.incrementAndGet();
                    }
                }
                if (mapEntries == null) {
                    Map<String, List<MapEntry>> mapEntry = this.getVanityPaths(vanityPath);
                    mapEntries = mapEntry.get(vanityPath);
                    if (!initFinished && this.temporaryResolveMapsMap != null) {
                        this.log.trace("getMapEntryList: caching map entries for {} -> {}", (Object)vanityPath, mapEntries);
                        this.temporaryResolveMapsMap.put(vanityPath, mapEntries == null ? NO_MAP_ENTRIES : mapEntries);
                    }
                }
            }
            if (mapEntries == null && probablyPresent) {
                this.vanityPathBloomFalsePositive.incrementAndGet();
            }
        }
        return mapEntries == NO_MAP_ENTRIES ? null : mapEntries;
    }

    private void refreshResolverIfNecessary(AtomicBoolean resolverRefreshed) {
        if (resolverRefreshed.compareAndSet(false, true)) {
            this.resolver.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean handleConfigurationUpdate(String path, AtomicBoolean hasReloadedConfig, AtomicBoolean resolverRefreshed, boolean isDelete) {
        if (this.factory.isMapConfiguration(path) || isDelete && this.factory.getMapRoot().startsWith(path + "/")) {
            if (hasReloadedConfig.compareAndSet(false, true)) {
                this.initializing.lock();
                try {
                    if (this.resolver != null) {
                        this.refreshResolverIfNecessary(resolverRefreshed);
                        this.doUpdateConfiguration();
                    }
                }
                finally {
                    this.initializing.unlock();
                }
                return true;
            }
            return null;
        }
        return false;
    }

    public void onChange(List<ResourceChange> changes) {
        boolean inStartup = !this.vanityPathsProcessed.get();
        AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
        boolean sendEvent = false;
        AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
        for (ResourceChange rc : changes) {
            ResourceChange.ChangeType type = rc.getType();
            String path = rc.getPath();
            this.log.debug("onChange, type={}, path={}", (Object)rc.getType(), (Object)path);
            if (path.startsWith(JCR_SYSTEM_PREFIX)) continue;
            if (inStartup) {
                if (type != ResourceChange.ChangeType.REMOVED && type != ResourceChange.ChangeType.ADDED && type != ResourceChange.ChangeType.CHANGED) continue;
                AbstractMap.SimpleEntry<String, ResourceChange.ChangeType> entry = new AbstractMap.SimpleEntry<String, ResourceChange.ChangeType>(path, type);
                this.log.trace("enqueue: {}", entry);
                this.resourceChangeQueue.add(entry);
                continue;
            }
            boolean changed = this.handleResourceChange(type, path, resolverRefreshed, hasReloadedConfig);
            if (!changed) continue;
            sendEvent = true;
        }
        if (sendEvent) {
            this.sendChangeEvent();
        }
    }

    private boolean handleResourceChange(ResourceChange.ChangeType type, String path, AtomicBoolean resolverRefreshed, AtomicBoolean hasReloadedConfig) {
        Boolean result;
        boolean changed = false;
        if (type == ResourceChange.ChangeType.REMOVED) {
            Boolean result2 = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, true);
            if (result2 != null) {
                changed = result2.booleanValue() ? true : (changed |= this.removeResource(path, resolverRefreshed));
            }
        } else if (type == ResourceChange.ChangeType.ADDED) {
            Boolean result3 = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, false);
            if (result3 != null) {
                changed = result3.booleanValue() ? true : (changed |= this.addResource(path, resolverRefreshed));
            }
        } else if (type == ResourceChange.ChangeType.CHANGED && (result = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, false)) != null) {
            changed = result.booleanValue() ? true : (changed |= this.updateResource(path, resolverRefreshed));
        }
        return changed;
    }

    private byte[] createVanityBloomFilter() throws IOException {
        return BloomFilterUtils.createFilter(10000000, this.factory.getVanityBloomFilterMaxBytes());
    }

    private boolean isAllVanityPathEntriesCached() {
        return this.factory.getMaxCachedVanityPathEntries() == -1L;
    }

    private static String queryLiteral(String input) {
        return input.replace("'", "''");
    }

    private Map<String, List<MapEntry>> getVanityPaths(String vanityPath) {
        Map<String, List<MapEntry>> entryMap = new HashMap<String, List<MapEntry>>();
        String queryString = String.format("SELECT [sling:vanityPath], [sling:redirect], [sling:redirectStatus] FROM [nt:base] WHERE NOT isdescendantnode('%s') AND ([sling:vanityPath]='%s' OR [sling:vanityPath]='%s') ORDER BY [sling:vanityOrder] DESC", JCR_SYSTEM_PATH, MapEntries.queryLiteral(vanityPath), MapEntries.queryLiteral(vanityPath.substring(1)));
        try (ResourceResolver queryResolver = this.factory.getServiceResourceResolver(this.factory.getServiceUserAuthenticationInfo("mapping"));){
            long totalCount = 0L;
            long totalValid = 0L;
            this.log.debug("start vanityPath query: {}", (Object)queryString);
            Iterator i = queryResolver.findResources(queryString, "JCR-SQL2");
            this.log.debug("end vanityPath query");
            while (i.hasNext()) {
                ++totalCount;
                Resource resource = (Resource)i.next();
                boolean isValid = false;
                for (Path sPath : this.factory.getObservationPaths()) {
                    if (!sPath.matches(resource.getPath())) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) continue;
                ++totalValid;
                if (this.vanityPathsProcessed.get() && (this.factory.isMaxCachedVanityPathEntriesStartup() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries())) {
                    this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, true);
                    entryMap = this.resolveMapsMap;
                    continue;
                }
                HashMap<String, List<String>> targetPaths = new HashMap<String, List<String>>();
                this.loadVanityPath(resource, entryMap, targetPaths, true);
            }
            this.log.debug("read {} ({} valid) vanityPaths", (Object)totalCount, (Object)totalValid);
        }
        catch (LoginException e) {
            this.log.error("Exception while obtaining queryResolver", (Throwable)e);
        }
        return entryMap;
    }

    private boolean isValidVanityPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Unexpected null path");
        }
        if (path.startsWith(JCR_SYSTEM_PREFIX)) {
            this.log.debug("isValidVanityPath: not valid {}", (Object)path);
            return false;
        }
        if (this.factory.getVanityPathConfig() != null) {
            boolean allowed = false;
            for (MapConfigurationProvider.VanityPathConfig config : this.factory.getVanityPathConfig()) {
                if (!path.startsWith(config.prefix)) continue;
                allowed = !config.isExclude;
                break;
            }
            if (!allowed) {
                this.log.debug("isValidVanityPath: not valid as not in allow list {}", (Object)path);
                return false;
            }
        }
        return true;
    }

    private String getActualContentPath(String path) {
        String checkPath = path.endsWith(JCR_CONTENT_SUFFIX) ? ResourceUtil.getParent((String)path) : path;
        return checkPath;
    }

    private String getMapEntryRedirect(MapEntry mapEntry) {
        String[] redirect = mapEntry.getRedirect();
        if (redirect.length > 1) {
            this.log.warn("something went wrong, please restart the bundle");
            return null;
        }
        String path = redirect[0];
        if (path.endsWith("$1")) {
            path = path.substring(0, path.length() - "$1".length());
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - ".html".length());
        }
        return path;
    }

    private void sendChangeEvent() {
        EventAdmin local = this.eventAdmin;
        if (local != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            local.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.factory.getMapRoot());
        if (res != null) {
            this.gather(resolver, entries, mapEntries, res, "");
        }
    }

    private void gather(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get(PROP_REG_EXP, String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = child.getName().concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name = this.stringInterpolationProvider.substitute(name))).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, entries, mapEntries, child, childParent);
            }
            MapEntry childResolveEntry = null;
            try {
                childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash);
            }
            catch (IllegalArgumentException iae) {
                this.log.debug("ignored entry due exception ", (Throwable)iae);
            }
            if (childResolveEntry != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private boolean addEntry(Map<String, List<MapEntry>> entryMap, String key, MapEntry entry) {
        if (entry == null) {
            this.log.trace("trying to add null entry for {}", (Object)key);
            return false;
        }
        List<MapEntry> entries = entryMap.get(key);
        if (entries == null) {
            entries = new ArrayList<MapEntry>();
            entries.add(entry);
            entryMap.put(key, entries);
        } else {
            ArrayList<MapEntry> entriesCopy = new ArrayList<MapEntry>(entries);
            entriesCopy.add(entry);
            Collections.sort(entriesCopy);
            entryMap.put(key, entriesCopy);
            int size = entriesCopy.size();
            if (size == 10) {
                this.log.debug(">= 10 MapEntries for {} - check your configuration", (Object)key);
            } else if (size == 100) {
                this.log.info(">= 100 MapEntries for {} - check your configuration", (Object)key);
            }
        }
        return true;
    }

    private Map<String, Map<String, Collection<String>>> loadAliases(ResourceResolver resolver) {
        PagedQueryIterator it;
        ConcurrentHashMap<String, Map<String, Collection<String>>> map = new ConcurrentHashMap<String, Map<String, Collection<String>>>();
        String baseQueryString = this.generateAliasQuery();
        try {
            String queryStringWithSort = baseQueryString + " AND FIRST([sling:alias]) > '%s' ORDER BY FIRST([sling:alias])";
            it = new PagedQueryIterator("alias", "sling:alias", resolver, queryStringWithSort, 2000);
        }
        catch (QuerySyntaxException ex) {
            this.log.debug("sort with first() not supported, falling back to base query", (Throwable)ex);
            it = this.queryUnpaged("alias", baseQueryString);
        }
        catch (UnsupportedOperationException ex) {
            this.log.debug("query failed as unsupported, retrying without paging/sorting", (Throwable)ex);
            it = this.queryUnpaged("alias", baseQueryString);
        }
        this.log.debug("alias initialization - start");
        long count = 0L;
        long processStart = System.nanoTime();
        while (it.hasNext()) {
            ++count;
            this.loadAlias((Resource)it.next(), map);
        }
        long processElapsed = System.nanoTime() - processStart;
        long resourcePerSecond = count * TimeUnit.SECONDS.toNanos(1L) / (processElapsed == 0L ? 1L : processElapsed);
        this.log.info("alias initialization - completed, processed {} resources with sling:alias properties in {}ms (~{} resource/s)", new Object[]{count, TimeUnit.NANOSECONDS.toMillis(processElapsed), resourcePerSecond});
        this.aliasResourcesOnStartup.set(count);
        return map;
    }

    private String generateAliasQuery() {
        Set<String> allowedLocations = this.factory.getAllowedAliasLocations();
        StringBuilder baseQuery = new StringBuilder("SELECT [sling:alias] FROM [nt:base] WHERE");
        if (allowedLocations.isEmpty()) {
            String jcrSystemPath = StringUtils.removeEnd((String)JCR_SYSTEM_PREFIX, (String)"/");
            baseQuery.append(" NOT isdescendantnode('").append(MapEntries.queryLiteral(jcrSystemPath)).append("')");
        } else {
            Iterator<String> pathIterator = allowedLocations.iterator();
            baseQuery.append(" (");
            String sep = "";
            while (pathIterator.hasNext()) {
                String prefix = pathIterator.next();
                baseQuery.append(sep).append("isdescendantnode('").append(MapEntries.queryLiteral(prefix)).append("')");
                sep = " OR ";
            }
            baseQuery.append(")");
        }
        baseQuery.append(" AND [sling:alias] IS NOT NULL");
        return baseQuery.toString();
    }

    private boolean loadAlias(Resource resource, Map<String, Map<String, Collection<String>>> map) {
        Resource containingResource = JCR_CONTENT.equals(resource.getName()) ? resource.getParent() : resource;
        Resource parent = containingResource.getParent();
        if (parent == null) {
            this.log.debug("parent is null for alias on {}.", (Object)resource.getName());
            return false;
        }
        String resourceName = containingResource.getName();
        String parentPath = parent.getPath();
        boolean hasAlias = false;
        ValueMap props = resource.getValueMap();
        String[] aliasArray = (String[])props.get("sling:alias", String[].class);
        if (aliasArray != null) {
            this.log.debug("Found alias, total size {}", (Object)aliasArray.length);
            for (String alias : aliasArray) {
                if (MapEntries.isAliasValid(alias)) {
                    this.log.warn("Encountered invalid alias {} under parent path {}. Refusing to use it.", (Object)alias, (Object)parentPath);
                    continue;
                }
                Map parentMap = map.computeIfAbsent(parentPath, key -> new ConcurrentHashMap());
                Optional<String> siblingResourceNameWithDuplicateAlias = parentMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(resourceName)).filter(entry -> ((Collection)entry.getValue()).contains(alias)).findFirst().map(Map.Entry::getKey);
                if (siblingResourceNameWithDuplicateAlias.isPresent()) {
                    this.log.warn("Encountered duplicate alias {} under parent path {}. Refusing to replace current target {} with {}.", new Object[]{alias, parentPath, siblingResourceNameWithDuplicateAlias.get(), resourceName});
                    continue;
                }
                Collection existingAliases = parentMap.computeIfAbsent(resourceName, name -> new CopyOnWriteArrayList());
                existingAliases.add(alias);
                hasAlias = true;
            }
        }
        return hasAlias;
    }

    private static boolean isAliasValid(String alias) {
        boolean invalid;
        boolean bl = invalid = alias.equals("..") || alias.equals(".");
        if (!invalid) {
            for (char c : alias.toCharArray()) {
                if (c != '/' && c != '#' && c != '?') continue;
                invalid = true;
                break;
            }
        }
        return invalid;
    }

    private Iterator<Resource> queryUnpaged(String subject, String query) {
        this.log.debug("start {} query: {}", (Object)subject, (Object)query);
        long queryStart = System.nanoTime();
        Iterator it = this.resolver.findResources(query, "JCR-SQL2");
        long queryElapsed = System.nanoTime() - queryStart;
        this.log.debug("end {} query; elapsed {}ms", (Object)subject, (Object)TimeUnit.NANOSECONDS.toMillis(queryElapsed));
        return it;
    }

    private Map<String, List<String>> loadVanityPaths(ResourceResolver resolver) {
        Iterator<Resource> it;
        ConcurrentHashMap<String, List<String>> targetPaths = new ConcurrentHashMap<String, List<String>>();
        String baseQueryString = "SELECT [sling:vanityPath], [sling:redirect], [sling:redirectStatus] FROM [nt:base] WHERE NOT isdescendantnode('" + MapEntries.queryLiteral(JCR_SYSTEM_PATH) + "') AND [sling:vanityPath] IS NOT NULL";
        boolean supportsSort = true;
        try {
            String queryStringWithSort = baseQueryString + " AND FIRST([sling:vanityPath]) > '%s' ORDER BY FIRST([sling:vanityPath])";
            it = new PagedQueryIterator("vanity path", PROP_VANITY_PATH, resolver, queryStringWithSort, 2000);
        }
        catch (QuerySyntaxException ex) {
            this.log.debug("sort with first() not supported, falling back to base query", (Throwable)ex);
            supportsSort = false;
            it = this.queryUnpaged("vanity path", baseQueryString);
        }
        catch (UnsupportedOperationException ex) {
            this.log.debug("query failed as unsupported, retrying without paging/sorting", (Throwable)ex);
            supportsSort = false;
            it = this.queryUnpaged("vanity path", baseQueryString);
        }
        long count = 0L;
        long countInScope = 0L;
        long processStart = System.nanoTime();
        String previousVanityPath = null;
        while (it.hasNext()) {
            ++count;
            Resource resource = it.next();
            String resourcePath = resource.getPath();
            if (!Stream.of(this.factory.getObservationPaths()).anyMatch(path -> path.matches(resourcePath))) continue;
            ++countInScope;
            boolean addToCache = this.isAllVanityPathEntriesCached() || this.vanityCounter.longValue() < this.factory.getMaxCachedVanityPathEntries();
            String firstVanityPath = this.loadVanityPath(resource, this.resolveMapsMap, targetPaths, addToCache);
            if (!supportsSort || firstVanityPath == null) continue;
            if (previousVanityPath != null && firstVanityPath.compareTo(previousVanityPath) < 0) {
                this.log.error("Sorting by first(vanityPath) does not appear to work; got " + firstVanityPath + " after " + previousVanityPath);
            }
            previousVanityPath = firstVanityPath;
        }
        long processElapsed = System.nanoTime() - processStart;
        this.log.debug("processed {} resources with sling:vanityPath properties (of which {} in scope) in {}ms", new Object[]{count, countInScope, TimeUnit.NANOSECONDS.toMillis(processElapsed)});
        if (!this.isAllVanityPathEntriesCached()) {
            if (countInScope > this.factory.getMaxCachedVanityPathEntries()) {
                this.log.warn("Number of resources with sling:vanityPath property ({}) exceeds configured cache size ({}); handling of uncached vanity paths will be much slower. Consider increasing the cache size or decreasing the number of vanity paths.", (Object)countInScope, (Object)this.factory.getMaxCachedVanityPathEntries());
            } else if (countInScope > this.factory.getMaxCachedVanityPathEntries() / 10L * 9L) {
                this.log.info("Number of resources with sling:vanityPath property in scope ({}) within 10% of configured cache size ({})", (Object)countInScope, (Object)this.factory.getMaxCachedVanityPathEntries());
            }
        }
        this.vanityResourcesOnStartup.set(count);
        return targetPaths;
    }

    private String loadVanityPath(Resource resource, Map<String, List<MapEntry>> entryMap, Map<String, List<String>> targetPaths, boolean addToCache) {
        if (!this.isValidVanityPath(resource.getPath())) {
            return null;
        }
        ValueMap props = resource.getValueMap();
        long vanityOrder = (Long)props.get(PROP_VANITY_ORDER, (Object)0L);
        boolean hasVanityPath = false;
        String[] pVanityPaths = (String[])props.get(PROP_VANITY_PATH, (Object)new String[0]);
        if (this.log.isTraceEnabled()) {
            this.log.trace("vanity paths on {}: {}", (Object)resource.getPath(), Arrays.asList(pVanityPaths));
        }
        for (String pVanityPath : pVanityPaths) {
            String[] result = this.getVanityPathDefinition(resource.getPath(), pVanityPath);
            if (result == null) continue;
            hasVanityPath = true;
            String url = result[0] + result[1];
            Resource redirectTarget = JCR_CONTENT.equals(resource.getName()) ? resource.getParent() : resource;
            String redirect = redirectTarget.getPath();
            String redirectName = redirectTarget.getName();
            int status = (Boolean)props.get(PROP_REDIRECT_EXTERNAL, (Object)false) != false ? (Integer)props.get(PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, (Object)this.factory.getDefaultVanityPathRedirectStatus()) : -1;
            String checkPath = result[1];
            if (addToCache) {
                boolean addedEntry;
                if (redirectName.indexOf(46) > -1) {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, vanityOrder, redirect));
                    int idx = redirectName.lastIndexOf(46);
                    String extension = redirectName.substring(idx + 1);
                    addedEntry = this.addEntry(entryMap, checkPath, this.getMapEntry(url + "\\." + extension, status, false, vanityOrder, redirect));
                } else {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, vanityOrder, redirect + ".html"));
                    addedEntry = this.addEntry(entryMap, checkPath, this.getMapEntry(url + "(\\..*)", status, false, vanityOrder, redirect + "$1"));
                }
                if (!addedEntry) continue;
                this.updateTargetPaths(targetPaths, redirect, checkPath);
                if (entryMap == this.resolveMapsMap) {
                    this.vanityCounter.addAndGet(2L);
                }
                BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
                continue;
            }
            BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
        }
        return hasVanityPath ? pVanityPaths[0] : null;
    }

    private void updateTargetPaths(Map<String, List<String>> targetPaths, String key, String entry) {
        if (entry == null) {
            return;
        }
        List<String> entries = targetPaths.get(key);
        if (entries == null) {
            entries = new ArrayList<String>();
            targetPaths.put(key, entries);
        }
        entries.add(entry);
    }

    private String[] getVanityPathDefinition(String sourcePath, String vanityPath) {
        if (vanityPath == null) {
            this.log.trace("getVanityPathDefinition: null vanity path on {}", (Object)sourcePath);
            return null;
        }
        String info = vanityPath.trim();
        if (info.isEmpty()) {
            this.log.trace("getVanityPathDefinition: empty vanity path on {}", (Object)sourcePath);
            return null;
        }
        Object prefix = null;
        Object path = null;
        if (info.indexOf(":/") > -1) {
            try {
                URL u = new URL(info);
                prefix = u.getProtocol() + "/" + u.getHost() + "." + u.getPort();
                path = u.getPath();
            }
            catch (MalformedURLException e) {
                this.log.warn("Ignoring malformed vanity path '{}' on {}", (Object)info, (Object)sourcePath);
                return null;
            }
        } else {
            prefix = "^[^/]+/[^/]+";
            path = !info.startsWith("/") ? "/" + info : info;
        }
        int lastSlash = ((String)path).lastIndexOf(47);
        int firstDot = ((String)path).indexOf(46, lastSlash + 1);
        if (firstDot != -1) {
            path = ((String)path).substring(0, firstDot);
            this.log.warn("Removing extension from vanity path '{}' on {}", (Object)info, (Object)sourcePath);
        }
        return new String[]{prefix, path};
    }

    private void loadConfiguration(MapConfigurationProvider factory, List<MapEntry> entries) {
        Mapping[] mappings;
        Map<String, String> virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry<String, String> virtualEntry : virtuals.entrySet()) {
                String string;
                String extPath = virtualEntry.getKey();
                if (extPath.equals(string = virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = string;
                MapEntry mapEntry = this.getMapEntry(url, -1, false, redirect);
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = this.getMapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, false, ((List)entry.getValue()).toArray(new String[0]));
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
    }

    private void loadMapConfiguration(MapConfigurationProvider factory, Map<String, MapEntry> entries) {
        Map<String, String> virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry<String, String> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = virtualEntry.getKey();
                if (extPath.equals(intPath = virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = this.getMapEntry(path, status, false, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = this.getMapEntry(entry.getPattern(), entry.getStatus(), false, newRedir);
        }
        if (entry != null) {
            entries.put(path, entry);
        }
    }

    @Override
    public void logDisableAliasOptimization() {
        this.logDisableAliasOptimization(null);
    }

    private void logDisableAliasOptimization(Exception e) {
        if (e != null) {
            this.log.error("Unexpected problem during initialization of optimize alias resolution. Therefore disabling optimize alias resolution. Please fix the problem.", (Throwable)e);
        } else {
            long now = System.currentTimeMillis();
            if (now - this.lastTimeLogged.getAndSet(now) > 300000L) {
                this.log.error("A problem occured during initialization of optimize alias resolution. Optimize alias resolution is disabled. Check the logs for the reported problem.", (Throwable)e);
            }
        }
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, 0L, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, long order, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, order, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    private static /* synthetic */ boolean lambda$removeAlias$1(String prefix, String resourcePath, Map.Entry e) {
        return (prefix + (String)e.getKey()).startsWith(resourcePath);
    }

    private final class MapEntryIterator
    implements Iterator<MapEntry> {
        private final Map<String, List<MapEntry>> resolveMapsMap;
        private String key;
        private MapEntry next;
        private final Iterator<MapEntry> globalListIterator;
        private MapEntry nextGlobal;
        private Iterator<MapEntry> specialIterator;
        private MapEntry nextSpecial;
        private boolean vanityPathPrecedence;

        public MapEntryIterator(String startKey, Map<String, List<MapEntry>> resolveMapsMap, boolean vanityPathPrecedence) {
            this.key = startKey;
            this.resolveMapsMap = resolveMapsMap;
            this.globalListIterator = this.resolveMapsMap.get(MapEntries.GLOBAL_LIST_KEY).iterator();
            this.vanityPathPrecedence = vanityPathPrecedence;
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MapEntry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MapEntry result = this.next;
            this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            if (this.nextGlobal == null && this.globalListIterator.hasNext()) {
                this.nextGlobal = this.globalListIterator.next();
            }
            if (this.nextSpecial == null) {
                if (this.specialIterator != null && !this.specialIterator.hasNext()) {
                    this.specialIterator = null;
                }
                while (this.specialIterator == null && this.key != null) {
                    List<MapEntry> special;
                    int lastSlashPos = this.key.lastIndexOf(47);
                    int lastDotPos = this.key.indexOf(46, lastSlashPos);
                    if (lastDotPos != -1) {
                        this.key = this.key.substring(0, lastDotPos);
                    }
                    if ((special = MapEntries.this.isAllVanityPathEntriesCached() && MapEntries.this.vanityPathsProcessed.get() ? this.resolveMapsMap.get(this.key) : MapEntries.this.getMapEntryList(this.key)) != null) {
                        this.specialIterator = special.iterator();
                    }
                    if (this.key.length() > 1) {
                        int lastSlash = this.key.lastIndexOf("/");
                        if (lastSlash == 0) {
                            this.key = null;
                            continue;
                        }
                        this.key = this.key.substring(0, lastSlash);
                        continue;
                    }
                    this.key = null;
                }
                if (this.specialIterator != null && this.specialIterator.hasNext()) {
                    this.nextSpecial = this.specialIterator.next();
                }
            }
            if (this.nextSpecial == null) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else if (!this.vanityPathPrecedence) {
                if (this.nextGlobal == null) {
                    this.next = this.nextSpecial;
                    this.nextSpecial = null;
                } else if (this.nextGlobal.getPattern().length() >= this.nextSpecial.getPattern().length()) {
                    this.next = this.nextGlobal;
                    this.nextGlobal = null;
                } else {
                    this.next = this.nextSpecial;
                    this.nextSpecial = null;
                }
            } else {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            }
        }
    }

    private class PagedQueryIterator
    implements Iterator<Resource> {
        private ResourceResolver resolver;
        private String subject;
        private String propertyName;
        private String query;
        private String lastValue = "";
        private Iterator<Resource> it;
        private int count = 0;
        private int page = 0;
        private int pageSize;
        private Resource next = null;
        private String[] defaultValue = new String[0];

        public PagedQueryIterator(String subject, String propertyName, ResourceResolver resolver, String query, int pageSize) {
            this.subject = subject;
            this.propertyName = propertyName;
            this.resolver = resolver;
            this.query = query;
            this.pageSize = pageSize;
            this.nextPage();
        }

        private void nextPage() {
            this.count = 0;
            String tquery = String.format(this.query, MapEntries.queryLiteral(this.lastValue));
            MapEntries.this.log.debug("start {} query (page {}): {}", new Object[]{this.subject, this.page, tquery});
            long queryStart = System.nanoTime();
            this.it = this.resolver.findResources(tquery, "JCR-SQL2");
            long queryElapsed = System.nanoTime() - queryStart;
            MapEntries.this.log.debug("end {} query (page {}); elapsed {}ms", new Object[]{this.subject, this.page, TimeUnit.NANOSECONDS.toMillis(queryElapsed)});
            ++this.page;
        }

        private Resource getNext() throws NoSuchElementException {
            Resource resource = this.it.next();
            ++this.count;
            String[] values = (String[])resource.getValueMap().get(this.propertyName, (Object)this.defaultValue);
            if (values.length > 0) {
                String value = values[0];
                if (value.compareTo(this.lastValue) < 0) {
                    String message = String.format("unexpected query result in page %d, %s of '%s' despite querying for > '%s'", this.page - 1, this.propertyName, value, this.lastValue);
                    MapEntries.this.log.error(message);
                    throw new RuntimeException(message);
                }
                if (this.count > this.pageSize && !value.equals(this.lastValue)) {
                    MapEntries.this.log.debug("read {} query (page {}); {} entries", new Object[]{this.subject, this.page, this.count});
                    this.lastValue = value;
                    this.nextPage();
                }
            }
            return resource;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.getNext();
                }
                catch (NoSuchElementException ex) {
                    this.next = null;
                }
            }
            return this.next != null;
        }

        @Override
        public Resource next() throws NoSuchElementException {
            Resource result = this.next != null ? this.next : this.getNext();
            this.next = null;
            return result;
        }
    }

    private class VanityPathInitializer
    implements Runnable {
        private int SIZELIMIT = 10000;
        private MapConfigurationProvider factory;

        public VanityPathInitializer(MapConfigurationProvider factory) {
            this.factory = factory;
        }

        @Override
        public void run() {
            MapEntries.this.temporaryResolveMapsMap = Collections.synchronizedMap(new LRUMap(this.SIZELIMIT));
            this.execute();
        }

        private void drainQueue(List<Map.Entry<String, ResourceChange.ChangeType>> queue) {
            AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
            boolean sendEvent = false;
            AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
            while (!queue.isEmpty()) {
                Map.Entry<String, ResourceChange.ChangeType> entry = queue.remove(0);
                ResourceChange.ChangeType type = entry.getValue();
                String path = entry.getKey();
                MapEntries.this.log.trace("drain type={}, path={}", (Object)type, (Object)path);
                boolean changed = MapEntries.this.handleResourceChange(type, path, resolverRefreshed, hasReloadedConfig);
                if (!changed) continue;
                sendEvent = true;
            }
            if (sendEvent) {
                MapEntries.this.sendChangeEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.factory.getServiceUserAuthenticationInfo("mapping"));){
                long initStart = System.nanoTime();
                MapEntries.this.log.debug("vanity path initialization - start");
                MapEntries.this.vanityTargets = MapEntries.this.loadVanityPaths(resolver);
                this.drainQueue(MapEntries.this.resourceChangeQueue);
                MapEntries.this.vanityPathsProcessed.set(true);
                this.drainQueue(MapEntries.this.resourceChangeQueue);
                long initElapsed = System.nanoTime() - initStart;
                long resourcesPerSecond = MapEntries.this.vanityResourcesOnStartup.get() * TimeUnit.SECONDS.toNanos(1L) / (initElapsed == 0L ? 1L : initElapsed);
                MapEntries.this.log.info("vanity path initialization - completed, processed {} resources with sling:vanityPath properties in {}ms (~{} resource/s)", new Object[]{MapEntries.this.vanityResourcesOnStartup.get(), TimeUnit.NANOSECONDS.toMillis(initElapsed), resourcesPerSecond});
            }
            catch (LoginException ex) {
                try {
                    MapEntries.this.log.error("Vanity path init failed", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    MapEntries.this.log.debug("dropping temporary resolver map - {}/{} entries, {} hits, {} misses", new Object[]{MapEntries.this.temporaryResolveMapsMap.size(), this.SIZELIMIT, MapEntries.this.temporaryResolveMapsMapHits.get(), MapEntries.this.temporaryResolveMapsMapMisses.get()});
                    MapEntries.this.temporaryResolveMapsMap = null;
                    throw throwable;
                }
                MapEntries.this.log.debug("dropping temporary resolver map - {}/{} entries, {} hits, {} misses", new Object[]{MapEntries.this.temporaryResolveMapsMap.size(), this.SIZELIMIT, MapEntries.this.temporaryResolveMapsMapHits.get(), MapEntries.this.temporaryResolveMapsMapMisses.get()});
                MapEntries.this.temporaryResolveMapsMap = null;
            }
            MapEntries.this.log.debug("dropping temporary resolver map - {}/{} entries, {} hits, {} misses", new Object[]{MapEntries.this.temporaryResolveMapsMap.size(), this.SIZELIMIT, MapEntries.this.temporaryResolveMapsMapHits.get(), MapEntries.this.temporaryResolveMapsMapMisses.get()});
            MapEntries.this.temporaryResolveMapsMap = null;
        }
    }
}

