/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.legacy;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.AttributableResourceProvider;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.RefreshableResourceProvider;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceresolver.impl.legacy.LegacyResourceProviderAdapter;
import org.apache.sling.resourceresolver.impl.legacy.LegacyResourceProviderFactoryAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class LegacyResourceProviderWhiteboard {
    public static final String ORIGINAL_SERVICE_PID = "original.service.pid";
    private Map<Object, List<ServiceRegistration>> registrations = new HashMap<Object, List<ServiceRegistration>>();

    @Reference(service=ResourceProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResourceProvider(ServiceReference<ResourceProvider> ref) {
        BundleContext bundleContext = ref.getBundle().getBundleContext();
        ResourceProvider provider = (ResourceProvider)bundleContext.getService(ref);
        if (provider != null) {
            Object[] propertyNames = ref.getPropertyKeys();
            boolean ownsRoot = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.ownsRoots"), (boolean)false);
            ArrayList<ServiceRegistration> newServices = new ArrayList<ServiceRegistration>();
            for (String path : PropertiesUtil.toStringArray((Object)ref.getProperty("provider.roots"), (String[])new String[0])) {
                if (path == null || path.isEmpty()) continue;
                Hashtable<String, Object> newProps = new Hashtable<String, Object>();
                ((Dictionary)newProps).put("provider.authenticate", AuthType.no.toString());
                ((Dictionary)newProps).put("provider.modifiable", provider instanceof ModifyingResourceProvider);
                ((Dictionary)newProps).put("provider.adaptable", provider instanceof Adaptable);
                ((Dictionary)newProps).put("provider.attributable", provider instanceof AttributableResourceProvider);
                ((Dictionary)newProps).put("provider.refreshable", provider instanceof RefreshableResourceProvider);
                ((Dictionary)newProps).put("provider.name", provider.getClass().getName());
                ((Dictionary)newProps).put("provider.root", LegacyResourceProviderWhiteboard.normalizePath(path));
                if (ArrayUtils.contains((Object[])propertyNames, (Object)"service.pid")) {
                    ((Dictionary)newProps).put(ORIGINAL_SERVICE_PID, ref.getProperty("service.pid"));
                }
                if (ArrayUtils.contains((Object[])propertyNames, (Object)"provider.useResourceAccessSecurity")) {
                    ((Dictionary)newProps).put("provider.useResourceAccessSecurity", ref.getProperty("provider.useResourceAccessSecurity"));
                }
                if (ArrayUtils.contains((Object[])propertyNames, (Object)"service.ranking")) {
                    ((Dictionary)newProps).put("service.ranking", ref.getProperty("service.ranking"));
                }
                String[] languages = PropertiesUtil.toStringArray((Object)ref.getProperty("provider.query.languages"), (String[])new String[0]);
                ServiceRegistration reg = bundleContext.registerService(org.apache.sling.spi.resource.provider.ResourceProvider.class.getName(), (Object)new LegacyResourceProviderAdapter(provider, languages, ownsRoot), newProps);
                newServices.add(reg);
            }
            this.registrations.put(provider, newServices);
        }
    }

    protected void unbindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        for (ServiceRegistration r : this.registrations.remove(provider)) {
            r.unregister();
        }
    }

    @Reference(service=ResourceProviderFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResourceProviderFactory(ServiceReference<ResourceProviderFactory> ref) {
        BundleContext bundleContext = ref.getBundle().getBundleContext();
        ResourceProviderFactory factory = (ResourceProviderFactory)bundleContext.getService(ref);
        if (factory != null) {
            Object[] propertyNames = ref.getPropertyKeys();
            boolean ownsRoot = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.ownsRoots"), (boolean)false);
            ArrayList<ServiceRegistration> newServices = new ArrayList<ServiceRegistration>();
            for (String path : PropertiesUtil.toStringArray((Object)ref.getProperty("provider.roots"), (String[])new String[0])) {
                if (path == null || path.isEmpty()) continue;
                Hashtable<String, Object> newProps = new Hashtable<String, Object>();
                if (PropertiesUtil.toBoolean((Object)ref.getProperty("required"), (boolean)false)) {
                    ((Dictionary)newProps).put("provider.authenticate", AuthType.required.toString());
                } else {
                    ((Dictionary)newProps).put("provider.authenticate", AuthType.lazy.toString());
                }
                ((Dictionary)newProps).put("provider.modifiable", true);
                ((Dictionary)newProps).put("provider.adaptable", true);
                ((Dictionary)newProps).put("provider.attributable", true);
                ((Dictionary)newProps).put("provider.refreshable", true);
                ((Dictionary)newProps).put("provider.name", factory.getClass().getName());
                ((Dictionary)newProps).put("provider.root", LegacyResourceProviderWhiteboard.normalizePath(path));
                if (ArrayUtils.contains((Object[])propertyNames, (Object)"service.pid")) {
                    ((Dictionary)newProps).put(ORIGINAL_SERVICE_PID, ref.getProperty("service.pid"));
                }
                if (ArrayUtils.contains((Object[])propertyNames, (Object)"provider.useResourceAccessSecurity")) {
                    ((Dictionary)newProps).put("provider.useResourceAccessSecurity", ref.getProperty("provider.useResourceAccessSecurity"));
                }
                if (ArrayUtils.contains((Object[])propertyNames, (Object)"service.ranking")) {
                    ((Dictionary)newProps).put("service.ranking", ref.getProperty("service.ranking"));
                }
                String[] languages = PropertiesUtil.toStringArray((Object)ref.getProperty("provider.query.languages"), (String[])new String[0]);
                ServiceRegistration reg = bundleContext.registerService(org.apache.sling.spi.resource.provider.ResourceProvider.class.getName(), (Object)new LegacyResourceProviderFactoryAdapter(factory, languages, ownsRoot), newProps);
                newServices.add(reg);
            }
            this.registrations.put(factory, newServices);
        }
    }

    protected void unbindResourceProviderFactory(ResourceProviderFactory factory, Map<String, Object> props) {
        for (ServiceRegistration r : this.registrations.remove(factory)) {
            r.unregister();
        }
    }

    private static String normalizePath(String path) {
        Object result = path;
        result = StringUtils.removeEnd((String)path, (String)"/");
        if (result != null && !((String)result).startsWith("/")) {
            result = "/" + (String)result;
        }
        return result;
    }
}

