/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.ServiceUtil;

public class ResourceDecoratorTracker {
    private static final ResourceDecorator[] EMPTY_ARRAY = new ResourceDecorator[0];
    protected final List<ResourceDecoratorEntry> resourceDecorators = new ArrayList<ResourceDecoratorEntry>();
    private volatile ResourceDecorator[] resourceDecoratorsArray = EMPTY_ARRAY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<ResourceDecoratorEntry> list = this.resourceDecorators;
        synchronized (list) {
            this.resourceDecorators.clear();
            this.resourceDecoratorsArray = EMPTY_ARRAY;
        }
    }

    public Resource decorate(Resource resource) {
        ResourceDecorator[] decorators;
        Resource result = resource;
        for (ResourceDecorator decorator : decorators = this.resourceDecoratorsArray) {
            Resource original = result;
            if ((result = decorator.decorate(original)) != null) continue;
            result = original;
        }
        result.getResourceMetadata().lock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        List<ResourceDecoratorEntry> list = this.resourceDecorators;
        synchronized (list) {
            this.resourceDecorators.add(new ResourceDecoratorEntry(decorator, ServiceUtil.getComparableForServiceRanking(props, (Order)Order.ASCENDING)));
            Collections.sort(this.resourceDecorators);
            this.updateResourceDecoratorsArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        List<ResourceDecoratorEntry> list = this.resourceDecorators;
        synchronized (list) {
            Iterator<ResourceDecoratorEntry> i = this.resourceDecorators.iterator();
            while (i.hasNext()) {
                ResourceDecoratorEntry current = i.next();
                if (current.decorator != decorator) continue;
                i.remove();
                break;
            }
            this.updateResourceDecoratorsArray();
        }
    }

    private void updateResourceDecoratorsArray() {
        ResourceDecorator[] decorators;
        if (this.resourceDecorators.size() > 0) {
            decorators = new ResourceDecorator[this.resourceDecorators.size()];
            int index = 0;
            Iterator<ResourceDecoratorEntry> i = this.resourceDecorators.iterator();
            while (i.hasNext()) {
                decorators[index] = i.next().decorator;
                ++index;
            }
        } else {
            decorators = EMPTY_ARRAY;
        }
        this.resourceDecoratorsArray = decorators;
    }

    private static final class ResourceDecoratorEntry
    implements Comparable<ResourceDecoratorEntry> {
        final Comparable<Object> comparable;
        final ResourceDecorator decorator;

        public ResourceDecoratorEntry(ResourceDecorator d, Comparable<Object> comparable) {
            this.comparable = comparable;
            this.decorator = d;
        }

        @Override
        public int compareTo(ResourceDecoratorEntry o) {
            return this.comparable.compareTo(o.comparable);
        }
    }
}

