/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Gauge;
import org.apache.sling.commons.metrics.MetricsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceResolverMetrics.class})
public class ResourceResolverMetrics {
    protected static final String METRICS_PREFIX = "org.apache.sling.resourceresolver";
    @Reference
    MetricsService metricsService;
    private static final Supplier<Long> ZERO_SUPPLIER = () -> 0L;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathsGauge;
    private Supplier<Long> numberOfVanityPathsSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathLookupsGauge;
    private Supplier<Long> numberOfVanityPathLookupsSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathBloomNegativeGauge;
    private Supplier<Long> numberOfVanityPathBloomNegativeSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfVanityPathBloomFalsePositiveGauge;
    private Supplier<Long> numberOfVanityPathBloomFalsePositiveSupplier = ZERO_SUPPLIER;
    private ServiceRegistration<Gauge<Long>> numberOfAliasesGauge;
    private Supplier<Long> numberOfAliasesSupplier = ZERO_SUPPLIER;
    private Counter unclosedResourceResolvers;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.numberOfVanityPathsGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPaths", () -> this.numberOfVanityPathsSupplier);
        this.numberOfVanityPathLookupsGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPathLookups", () -> this.numberOfVanityPathLookupsSupplier);
        this.numberOfVanityPathBloomNegativeGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPathBloomNegatives", () -> this.numberOfVanityPathBloomNegativeSupplier);
        this.numberOfVanityPathBloomFalsePositiveGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfVanityPathBloomFalsePositives", () -> this.numberOfVanityPathBloomFalsePositiveSupplier);
        this.numberOfAliasesGauge = this.registerGauge(bundleContext, "org.apache.sling.resourceresolver.numberOfAliases", () -> this.numberOfAliasesSupplier);
        this.unclosedResourceResolvers = this.metricsService.counter("org.apache.sling.resourceresolver.unclosedResourceResolvers");
    }

    @Deactivate
    protected void deactivate() {
        this.numberOfVanityPathsGauge.unregister();
        this.numberOfVanityPathLookupsGauge.unregister();
        this.numberOfVanityPathBloomNegativeGauge.unregister();
        this.numberOfVanityPathBloomFalsePositiveGauge.unregister();
        this.numberOfAliasesGauge.unregister();
    }

    public void setNumberOfVanityPathsSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathsSupplier = supplier;
    }

    public void setNumberOfVanityPathLookupsSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathLookupsSupplier = supplier;
    }

    public void setNumberOfVanityPathBloomNegativeSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathBloomNegativeSupplier = supplier;
    }

    public void setNumberOfVanityPathBloomFalsePositiveSupplier(Supplier<Long> supplier) {
        this.numberOfVanityPathBloomFalsePositiveSupplier = supplier;
    }

    public void setNumberOfAliasesSupplier(Supplier<Long> supplier) {
        this.numberOfAliasesSupplier = supplier;
    }

    public void reportUnclosedResourceResolver() {
        this.unclosedResourceResolvers.increment();
    }

    private ServiceRegistration<Gauge<Long>> registerGauge(BundleContext context, String name, Supplier<Supplier<Long>> supplier) {
        ResourceResolverGauge gauge = new ResourceResolverGauge(supplier);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("name", name);
        return context.registerService(Gauge.class, (Object)gauge, props);
    }

    public class ResourceResolverGauge
    implements Gauge<Long> {
        Supplier<Supplier<Long>> supplier;

        public ResourceResolverGauge(Supplier<Supplier<Long>> supplier) {
            this.supplier = supplier;
        }

        public Long getValue() {
            return this.supplier.get().get();
        }
    }
}

