/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryPreconditions {
    private volatile ResourceProviderTracker tracker;
    private volatile List<RequiredProvider> requiredProviders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(BundleContext bc, Set<String> legycyConfiguration, Set<String> namesConfiguration, ResourceProviderTracker tracker) {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            this.tracker = tracker;
            ArrayList<RequiredProvider> rps = new ArrayList<RequiredProvider>();
            if (legycyConfiguration != null) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                for (String value : legycyConfiguration) {
                    RequiredProvider rp = new RequiredProvider();
                    if (value.startsWith("(")) {
                        try {
                            rp.filter = bc.createFilter(value);
                        }
                        catch (InvalidSyntaxException e) {
                            logger.warn("Ignoring invalid filter syntax for required provider: " + value, (Throwable)e);
                            rp = null;
                        }
                    } else {
                        rp.pid = value;
                    }
                    if (rp == null) continue;
                    rps.add(rp);
                }
            }
            if (namesConfiguration != null) {
                for (String value : namesConfiguration) {
                    RequiredProvider rp = new RequiredProvider();
                    rp.name = value;
                    rps.add(rp);
                }
            }
            this.requiredProviders = rps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            this.requiredProviders = null;
            this.tracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPreconditions(String unavailableName, String unavailableServicePid) {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            boolean canRegister;
            List<RequiredProvider> localRequiredProviders = this.requiredProviders;
            ResourceProviderTracker localTracker = this.tracker;
            boolean bl = canRegister = localTracker != null;
            if (localRequiredProviders != null && localTracker != null) {
                for (RequiredProvider rp : localRequiredProviders) {
                    canRegister = false;
                    for (ResourceProviderHandler h : localTracker.getResourceProviderStorage().getAllHandlers()) {
                        ResourceProviderInfo info = h.getInfo();
                        if (info == null) continue;
                        ServiceReference<ResourceProvider> ref = info.getServiceReference();
                        Object servicePid = ref.getProperty("service.pid");
                        if (unavailableServicePid != null && unavailableServicePid.equals(servicePid) || unavailableName != null && unavailableName.equals(info.getName())) continue;
                        if (rp.name != null && rp.name.equals(info.getName())) {
                            canRegister = true;
                            break;
                        }
                        if (rp.filter != null && rp.filter.match(ref)) {
                            canRegister = true;
                            break;
                        }
                        if (rp.pid != null && rp.pid.equals(servicePid)) {
                            canRegister = true;
                            break;
                        }
                        if (rp.pid == null || !rp.pid.equals(ref.getProperty("original.service.pid"))) continue;
                        canRegister = true;
                        break;
                    }
                    if (canRegister) continue;
                    break;
                }
            }
            return canRegister;
        }
    }

    private static final class RequiredProvider {
        public String name;
        public String pid;
        public Filter filter;

        private RequiredProvider() {
        }
    }
}

