/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceaccesssecurity.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.security.AccessSecurityException;
import org.apache.sling.api.security.ResourceAccessSecurity;
import org.apache.sling.resourceaccesssecurity.ResourceAccessGate;
import org.apache.sling.resourceaccesssecurity.impl.AccessGateResourceWrapper;
import org.apache.sling.resourceaccesssecurity.impl.ResourceAccessGateHandler;
import org.osgi.framework.ServiceReference;

public abstract class ResourceAccessSecurityImpl
implements ResourceAccessSecurity {
    private List<ResourceAccessGateHandler> allHandlers = Collections.emptyList();
    private final boolean defaultAllowIfNoGateMatches;

    public ResourceAccessSecurityImpl(boolean defaultAllowIfNoGateMatches) {
        this.defaultAllowIfNoGateMatches = defaultAllowIfNoGateMatches;
    }

    private Iterator<ResourceAccessGateHandler> getMatchingResourceAccessGateHandlerIterator(final String path, final ResourceAccessGate.Operation operation) {
        List<ResourceAccessGateHandler> handlers = this.allHandlers;
        if (handlers.size() > 0) {
            final Iterator<ResourceAccessGateHandler> iter = handlers.iterator();
            return new Iterator<ResourceAccessGateHandler>(){
                private ResourceAccessGateHandler next;
                {
                    this.peek();
                }

                private void peek() {
                    this.next = null;
                    while (iter.hasNext() && this.next == null) {
                        ResourceAccessGateHandler handler = (ResourceAccessGateHandler)iter.next();
                        if (!handler.matches(path, operation)) continue;
                        this.next = handler;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public ResourceAccessGateHandler next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    ResourceAccessGateHandler handler = this.next;
                    this.peek();
                    return handler;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    public Resource getReadableResource(Resource resource) {
        Object returnValue = null;
        Iterator<ResourceAccessGateHandler> accessGateHandlers = this.getMatchingResourceAccessGateHandlerIterator(resource.getPath(), ResourceAccessGate.Operation.READ);
        ResourceAccessGate.GateResult finalGateResult = null;
        ArrayList<ResourceAccessGate> accessGatesForReadValues = null;
        boolean canReadAllValues = false;
        if (accessGateHandlers != null) {
            boolean noGateMatched = true;
            while (accessGateHandlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = accessGateHandlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !resourceAccessGateHandler.getResourceAccessGate().hasReadRestrictions(resource.getResourceResolver()) ? ResourceAccessGate.GateResult.GRANTED : resourceAccessGateHandler.getResourceAccessGate().canRead(resource);
                if (!canReadAllValues && gateResult == ResourceAccessGate.GateResult.GRANTED) {
                    if (resourceAccessGateHandler.getResourceAccessGate().canReadAllValues(resource)) {
                        canReadAllValues = true;
                        accessGatesForReadValues = null;
                    } else {
                        if (accessGatesForReadValues == null) {
                            accessGatesForReadValues = new ArrayList<ResourceAccessGate>();
                        }
                        accessGatesForReadValues.add(resourceAccessGateHandler.getResourceAccessGate());
                    }
                }
                if (finalGateResult == null) {
                    finalGateResult = gateResult;
                } else if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && gateResult != ResourceAccessGate.GateResult.CANT_DECIDE) {
                    finalGateResult = gateResult;
                }
                if (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(ResourceAccessGate.Operation.READ)) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                returnValue = null;
            } else if (finalGateResult == ResourceAccessGate.GateResult.GRANTED) {
                returnValue = resource;
            } else if (noGateMatched && this.defaultAllowIfNoGateMatches) {
                returnValue = resource;
            }
        }
        boolean canUpdateResource = this.canUpdate(resource);
        if (!(returnValue == null || canReadAllValues && canUpdateResource)) {
            returnValue = new AccessGateResourceWrapper((Resource)returnValue, (List<ResourceAccessGate>)accessGatesForReadValues, canUpdateResource);
        }
        return returnValue;
    }

    public boolean canCreate(String path, ResourceResolver resolver) {
        Iterator<ResourceAccessGateHandler> handlers = this.getMatchingResourceAccessGateHandlerIterator(path, ResourceAccessGate.Operation.CREATE);
        boolean result = false;
        if (handlers != null) {
            ResourceAccessGate.GateResult finalGateResult = null;
            boolean noGateMatched = true;
            while (handlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = handlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !resourceAccessGateHandler.getResourceAccessGate().hasCreateRestrictions(resolver) ? ResourceAccessGate.GateResult.GRANTED : resourceAccessGateHandler.getResourceAccessGate().canCreate(path, resolver);
                if (finalGateResult == null) {
                    finalGateResult = gateResult;
                } else if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && gateResult != ResourceAccessGate.GateResult.CANT_DECIDE) {
                    finalGateResult = gateResult;
                }
                if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(ResourceAccessGate.Operation.CREATE))) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.GRANTED) {
                result = true;
            } else if (finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                result = false;
            } else if (noGateMatched && this.defaultAllowIfNoGateMatches) {
                result = true;
            }
        }
        return result;
    }

    public boolean canUpdate(Resource resource) {
        Iterator<ResourceAccessGateHandler> handlers = this.getMatchingResourceAccessGateHandlerIterator(resource.getPath(), ResourceAccessGate.Operation.UPDATE);
        boolean result = this.defaultAllowIfNoGateMatches;
        if (handlers != null) {
            ResourceAccessGate.GateResult finalGateResult = null;
            boolean noGateMatched = true;
            while (handlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = handlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !resourceAccessGateHandler.getResourceAccessGate().hasUpdateRestrictions(resource.getResourceResolver()) ? ResourceAccessGate.GateResult.GRANTED : resourceAccessGateHandler.getResourceAccessGate().canUpdate(resource);
                if (finalGateResult == null) {
                    finalGateResult = gateResult;
                } else if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && gateResult != ResourceAccessGate.GateResult.CANT_DECIDE) {
                    finalGateResult = gateResult;
                }
                if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(ResourceAccessGate.Operation.UPDATE))) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.GRANTED) {
                result = true;
            } else if (finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                result = false;
            } else if (noGateMatched && this.defaultAllowIfNoGateMatches) {
                result = true;
            }
        }
        return result;
    }

    public boolean canDelete(Resource resource) {
        Iterator<ResourceAccessGateHandler> handlers = this.getMatchingResourceAccessGateHandlerIterator(resource.getPath(), ResourceAccessGate.Operation.DELETE);
        boolean result = this.defaultAllowIfNoGateMatches;
        if (handlers != null) {
            ResourceAccessGate.GateResult finalGateResult = null;
            boolean noGateMatched = true;
            while (handlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = handlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !resourceAccessGateHandler.getResourceAccessGate().hasDeleteRestrictions(resource.getResourceResolver()) ? ResourceAccessGate.GateResult.GRANTED : resourceAccessGateHandler.getResourceAccessGate().canDelete(resource);
                if (finalGateResult == null) {
                    finalGateResult = gateResult;
                } else if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && gateResult != ResourceAccessGate.GateResult.CANT_DECIDE) {
                    finalGateResult = gateResult;
                }
                if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(ResourceAccessGate.Operation.DELETE))) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.GRANTED) {
                result = true;
            } else if (finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                result = false;
            } else if (noGateMatched && this.defaultAllowIfNoGateMatches) {
                result = true;
            }
        }
        return result;
    }

    public boolean canExecute(Resource resource) {
        Iterator<ResourceAccessGateHandler> handlers = this.getMatchingResourceAccessGateHandlerIterator(resource.getPath(), ResourceAccessGate.Operation.EXECUTE);
        boolean result = this.defaultAllowIfNoGateMatches;
        if (handlers != null) {
            ResourceAccessGate.GateResult finalGateResult = null;
            boolean noGateMatched = true;
            while (handlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = handlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !resourceAccessGateHandler.getResourceAccessGate().hasExecuteRestrictions(resource.getResourceResolver()) ? ResourceAccessGate.GateResult.GRANTED : resourceAccessGateHandler.getResourceAccessGate().canExecute(resource);
                if (finalGateResult == null) {
                    finalGateResult = gateResult;
                } else if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && gateResult != ResourceAccessGate.GateResult.CANT_DECIDE) {
                    finalGateResult = gateResult;
                }
                if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(ResourceAccessGate.Operation.EXECUTE))) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.GRANTED) {
                result = true;
            } else if (finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                result = false;
            } else if (noGateMatched && this.defaultAllowIfNoGateMatches) {
                result = true;
            }
        }
        return result;
    }

    public boolean canReadValue(Resource resource, String valueName) {
        return false;
    }

    public boolean canSetValue(Resource resource, String valueName) {
        return false;
    }

    public boolean canDeleteValue(Resource resource, String valueName) {
        return false;
    }

    public String transformQuery(String query, String language, ResourceResolver resourceResolver) throws AccessSecurityException {
        String returnValue = query;
        for (ResourceAccessGateHandler handler : this.allHandlers) {
            returnValue = handler.getResourceAccessGate().transformQuery(returnValue, language, resourceResolver);
            if (returnValue != null) continue;
            throw new AccessSecurityException("Method transformQuery in ResourceAccessGate " + handler.getResourceAccessGate().getClass().getName() + " returned null.");
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindResourceAccessGate(ServiceReference ref) {
        ResourceAccessSecurityImpl resourceAccessSecurityImpl = this;
        synchronized (resourceAccessSecurityImpl) {
            ArrayList<ResourceAccessGateHandler> newList = new ArrayList<ResourceAccessGateHandler>(this.allHandlers);
            ResourceAccessGateHandler h = new ResourceAccessGateHandler(ref);
            newList.add(h);
            Collections.sort(newList);
            this.allHandlers = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindResourceAccessGate(ServiceReference ref) {
        ResourceAccessSecurityImpl resourceAccessSecurityImpl = this;
        synchronized (resourceAccessSecurityImpl) {
            ArrayList<ResourceAccessGateHandler> newList = new ArrayList<ResourceAccessGateHandler>(this.allHandlers);
            ResourceAccessGateHandler h = new ResourceAccessGateHandler(ref);
            newList.remove(h);
            this.allHandlers = newList;
        }
    }
}

