/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceaccesssecurity.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceaccesssecurity.ResourceAccessGate;
import org.osgi.framework.ServiceReference;

public class ResourceAccessGateHandler
implements Comparable<ResourceAccessGateHandler> {
    private final ResourceAccessGate resourceAccessGate;
    private final ServiceReference reference;
    private final Pattern pathPattern;
    private final Set<ResourceAccessGate.Operation> operations = new HashSet<ResourceAccessGate.Operation>();
    private final Set<ResourceAccessGate.Operation> finalOperations = new HashSet<ResourceAccessGate.Operation>();

    public ResourceAccessGateHandler(ServiceReference resourceAccessGateRef) {
        String finalOps;
        this.reference = resourceAccessGateRef;
        this.resourceAccessGate = (ResourceAccessGate)resourceAccessGateRef.getBundle().getBundleContext().getService(resourceAccessGateRef);
        String path = (String)resourceAccessGateRef.getProperty("path");
        this.pathPattern = path != null ? Pattern.compile(path) : Pattern.compile(".*");
        String ops = PropertiesUtil.toString((Object)resourceAccessGateRef.getProperty("operations"), null);
        if (ops != null && ops.length() > 0) {
            String[] opsArray;
            for (String opAsString : opsArray = ops.split(",")) {
                ResourceAccessGate.Operation operation = ResourceAccessGate.Operation.fromString(opAsString);
                if (operation == null) continue;
                this.operations.add(operation);
            }
        } else {
            for (ResourceAccessGate.Operation op : ResourceAccessGate.Operation.values()) {
                this.operations.add(op);
            }
        }
        if ((finalOps = PropertiesUtil.toString((Object)resourceAccessGateRef.getProperty("finaloperations"), null)) != null && finalOps.length() > 0) {
            String[] finOpsArray;
            for (String opAsString : finOpsArray = finalOps.split(",")) {
                ResourceAccessGate.Operation operation = ResourceAccessGate.Operation.fromString(opAsString);
                if (operation == null) continue;
                this.finalOperations.add(operation);
            }
        }
    }

    public boolean matches(String path, ResourceAccessGate.Operation operation) {
        boolean returnValue = false;
        if (this.operations.contains((Object)operation)) {
            if (path != null) {
                Matcher match = this.pathPattern.matcher(path);
                returnValue = match.matches();
            } else {
                return true;
            }
        }
        return returnValue;
    }

    public boolean isFinalOperation(ResourceAccessGate.Operation operation) {
        return this.finalOperations.contains((Object)operation);
    }

    public ResourceAccessGate getResourceAccessGate() {
        return this.resourceAccessGate;
    }

    @Override
    public int compareTo(ResourceAccessGateHandler o) {
        return -this.reference.compareTo((Object)o.reference);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceAccessGateHandler) {
            return ((ResourceAccessGateHandler)obj).reference.equals(this.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.reference.hashCode();
    }
}

