/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
abstract class AclGroupBase
extends Operation {
    public static final String ACL_OPTION_MERGE = "merge";
    public static final String ACL_OPTION_MERGE_PRESERVE = "mergePreserve";
    private final List<AclLine> lines;
    private final List<String> aclOptions;

    protected AclGroupBase(List<AclLine> lines) {
        this(lines, new ArrayList<String>());
    }

    protected AclGroupBase(List<AclLine> lines, List<String> aclOptions) {
        this.lines = Collections.unmodifiableList(lines);
        this.aclOptions = Collections.unmodifiableList(aclOptions);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        for (AclLine line : this.lines) {
            sb.append("\n  ").append(line.toString());
        }
        return sb.toString();
    }

    public Collection<AclLine> getLines() {
        return this.lines;
    }

    public List<String> getOptions() {
        return this.aclOptions;
    }
}

