/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;

public class AclLine {
    private final Action action;
    public static final String PROP_PATHS = "paths";
    public static final String PROP_PRINCIPALS = "principals";
    public static final String PROP_PRIVILEGES = "privileges";
    public static final String PROP_NODETYPES = "nodetypes";
    public static final String PATH_REPOSITORY = ":repository";
    public static final String PATH_HOME = ":home:";
    public static final char ID_DELIMINATOR = ',';
    public static final char SUBTREE_DELIMINATOR = '#';
    private final Map<String, List<String>> properties;
    private List<RestrictionClause> restrictions;

    public AclLine(Action a) {
        this.action = a;
        this.properties = new TreeMap<String, List<String>>();
    }

    public Action getAction() {
        return this.action;
    }

    public List<String> getProperty(String name) {
        List<String> value = this.properties.get(name);
        return value != null ? value : Collections.emptyList();
    }

    public void setProperty(String name, List<String> values) {
        this.properties.put(name, Collections.unmodifiableList(values));
    }

    public void setRestrictions(List<RestrictionClause> restrictions) {
        this.restrictions = restrictions;
    }

    public List<RestrictionClause> getRestrictions() {
        return this.restrictions == null ? Collections.emptyList() : this.restrictions;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + (Object)((Object)this.action) + " " + this.properties + (this.restrictions == null || this.restrictions.isEmpty() ? "" : " restrictions=" + this.restrictions);
    }

    public static enum Action {
        REMOVE,
        REMOVE_ALL,
        DENY,
        ALLOW;

    }
}

