/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.predicate;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public enum SelectorOperator {
    CONTAINS("*="){

        @Override
        public boolean accepts(String property, String value) {
            return StringUtils.contains((String)property, (String)value);
        }
    }
    ,
    CONTAINS_WORD("~="){

        @Override
        public boolean accepts(String property, String value) {
            String quoted = Pattern.quote(value);
            String regex = String.format("(^| )%s( |$)", quoted);
            return property != null && Pattern.compile(regex).matcher(property).find();
        }
    }
    ,
    ENDS_WITH("$="){

        @Override
        public boolean accepts(String property, String value) {
            return StringUtils.endsWith((String)property, (String)value);
        }
    }
    ,
    EQUALS("="){

        @Override
        public boolean accepts(String property, String value) {
            return StringUtils.equals((String)property, (String)value);
        }
    }
    ,
    NOT_EQUAL("!="){

        @Override
        public boolean accepts(String property, String value) {
            return !StringUtils.equals((String)property, (String)value);
        }
    }
    ,
    STARTS_WITH("^="){

        @Override
        public boolean accepts(String property, String value) {
            return StringUtils.startsWith((String)property, (String)value);
        }
    };

    private final String operator;

    private SelectorOperator(String operator) {
        this.operator = operator;
    }

    public abstract boolean accepts(String var1, String var2);

    public static SelectorOperator getSelectorOperator(String operator) {
        for (SelectorOperator o : SelectorOperator.values()) {
            if (!o.operator.equals(operator)) continue;
            return o;
        }
        return EQUALS;
    }
}

