/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import java.util.List;
import org.apache.sling.query.api.internal.IteratorToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.AbstractIterator;
import org.apache.sling.query.iterator.ArgumentResettingIterator;

public class SuppIterator<T>
extends AbstractIterator<Option<T>> {
    private final List<Option<T>> input;
    private final Iterator<Option<T>> output;
    private Option<T> outputElement;
    private int currentIndex = 0;

    public SuppIterator(List<Option<T>> input, IteratorToIteratorFunction<T> function) {
        this.input = input;
        this.output = (Iterator)function.apply(new ArgumentResettingIterator<T>(input.iterator()));
    }

    @Override
    protected Option<T> getElement() {
        if (this.outputElement == null) {
            if (!this.output.hasNext()) {
                return null;
            }
            this.outputElement = this.output.next();
        }
        int outputIndex = this.outputElement.getArgumentId();
        boolean emptyResponse = this.outputElement.isEmpty();
        while (outputIndex <= this.currentIndex && this.output.hasNext()) {
            if (emptyResponse) {
                emptyResponse = this.outputElement.isEmpty();
            }
            this.outputElement = this.output.next();
            outputIndex = this.outputElement.getArgumentId();
        }
        if (emptyResponse) {
            if (outputIndex > this.currentIndex) {
                return Option.empty(this.currentIndex++);
            }
            return null;
        }
        if (outputIndex <= this.currentIndex) {
            this.outputElement = null;
        }
        return this.input.get(this.currentIndex++);
    }
}

