/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import org.apache.sling.query.api.internal.ElementToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.AbstractIterator;

public class ExpandingIterator<T>
extends AbstractIterator<Option<T>> {
    private final ElementToIteratorFunction<T> function;
    private final Iterator<Option<T>> parentIterator;
    private Option<T> parentElement;
    private Iterator<T> currentIterator;

    public ExpandingIterator(ElementToIteratorFunction<T> expandingFunction, Iterator<Option<T>> sourceIterator) {
        this.function = expandingFunction;
        this.parentIterator = sourceIterator;
    }

    @Override
    protected Option<T> getElement() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return Option.of(this.currentIterator.next(), this.parentElement.getArgumentId());
        }
        if (this.parentIterator.hasNext()) {
            this.parentElement = this.parentIterator.next();
            if (this.parentElement.isEmpty()) {
                return this.parentElement;
            }
            this.currentIterator = (Iterator)this.function.apply(this.parentElement.getElement());
            if (this.currentIterator.hasNext()) {
                return this.getElement();
            }
            return Option.empty(this.parentElement.getArgumentId());
        }
        return null;
    }
}

