/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.function;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.sling.query.api.internal.IteratorToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.FilteringIterator;

public class EvenFunction<T>
implements IteratorToIteratorFunction<T> {
    private final boolean even;

    public EvenFunction(boolean even) {
        this.even = even;
    }

    @Override
    public Iterator<Option<T>> apply(Iterator<Option<T>> resources) {
        return new FilteringIterator<T>(resources, new EvenPredicate(this.even));
    }

    private static class EvenPredicate<T>
    implements Predicate<T> {
        private boolean accept;

        public EvenPredicate(boolean firstState) {
            this.accept = firstState;
        }

        @Override
        public boolean test(T element) {
            boolean oldAccept = this.accept;
            this.accept = !this.accept;
            return oldAccept;
        }
    }
}

