/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.function;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.sling.query.api.internal.ElementToIteratorFunction;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.util.IteratorUtils;

public class ClosestFunction<T>
implements ElementToIteratorFunction<T> {
    private final Predicate<T> predicate;
    private final TreeProvider<T> provider;

    public ClosestFunction(Predicate<T> predicate, TreeProvider<T> provider) {
        this.predicate = predicate;
        this.provider = provider;
    }

    @Override
    public Iterator<T> apply(T resource) {
        T current = resource;
        while (current != null) {
            if (this.predicate.test(current)) {
                return IteratorUtils.singleElementIterator(current);
            }
            current = this.provider.getParent(current);
        }
        return IteratorUtils.emptyIterator();
    }
}

