/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query;

import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.query.AbstractQuery;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.iterator.AdaptToIterator;
import org.apache.sling.query.resource.ResourceTreeProvider;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SlingQuery
extends AbstractQuery<Resource, SlingQuery> {
    private SlingQuery(AbstractQuery<Resource, SlingQuery> original, SearchStrategy strategy) {
        super(original, strategy);
    }

    private SlingQuery(Resource[] resources, SearchStrategy strategy) {
        super(new ResourceTreeProvider(resources[0].getResourceResolver()), resources, strategy);
    }

    public static SlingQuery $(Resource ... resources) {
        if (resources.length == 0) {
            throw new IllegalArgumentException("Initial collection can't be empty");
        }
        return new SlingQuery(resources, SearchStrategy.QUERY);
    }

    public static SlingQuery $(ResourceResolver resolver) {
        return SlingQuery.$(resolver.getResource("/"));
    }

    public <E> Iterable<E> map(Class<? extends E> clazz) {
        return () -> new AdaptToIterator(this.iterator(), clazz);
    }

    @Override
    protected SlingQuery clone(AbstractQuery<Resource, SlingQuery> original, SearchStrategy strategy) {
        return new SlingQuery(original, strategy);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("$(");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            builder.append(((Resource)iterator.next()).getPath());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

