/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.OutputWriter;

public class ExecutionResult {
    private static final String[] JMX_NAMES = new String[]{"size", "output"};
    private static final CompositeType COMPOSITE_TYPE = ExecutionResult.getType();
    Set<String> currentPathSet;
    OutputWriter writer;
    CompositeData data;

    static CompositeType getType() {
        try {
            return new CompositeType(ExecutionResult.class.getName(), "Execution of pipe, with size, and output as pipe configuration defined it", JMX_NAMES, new String[]{"total size", "output as string"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public ExecutionResult(OutputWriter writer) {
        this.writer = writer;
        this.currentPathSet = new HashSet<String>();
    }

    public void addResultItem(Resource resource) {
        this.writer.write(resource);
        this.currentPathSet.add(resource.getPath());
    }

    public void emptyCurrentSet() {
        this.currentPathSet.clear();
    }

    public Collection<String> getCurrentPathSet() {
        return this.currentPathSet;
    }

    public long size() {
        return this.writer.size;
    }

    public String toString() {
        return this.writer.toString();
    }

    public CompositeData asCompositeData() throws OpenDataException {
        if (this.data == null) {
            this.data = new CompositeDataSupport(COMPOSITE_TYPE, JMX_NAMES, new Object[]{this.size(), this.toString()});
        }
        return this.data;
    }

    public void addError(String error) {
        this.writer.error(error);
    }
}

