/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.AbstractInputStreamPipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexpPipe
extends AbstractInputStreamPipe {
    private static Logger logger = LoggerFactory.getLogger(RegexpPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/egrep";
    public static final String PN_PATTERN = "pattern";
    private static final Pattern PATTERN_NAME = Pattern.compile("\\?<([\\w]+)>");
    private static final short PATTERN_IDX_NAME = 1;

    public RegexpPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    @Override
    public Iterator<Resource> getOutput(InputStream inputStream) {
        Iterator output = EMPTY_ITERATOR;
        try {
            String patternString = this.bindings.instantiateExpression((String)this.properties.get(PN_PATTERN, String.class));
            if (patternString == null) {
                logger.debug("pattern {} evaluates as empty.", this.properties.get(PN_PATTERN, String.class));
                return output;
            }
            final Collection<String> names = this.getGroupNames(patternString);
            if (names.isEmpty()) {
                logger.debug("no name defined, will take the whole match");
            }
            Pattern pattern = Pattern.compile(patternString);
            String text = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            logger.trace("about to parse {}", (Object)text);
            final Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                final Resource next = this.getInput();
                output = new Iterator<Resource>(){
                    boolean hasNext = true;

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public Resource next() {
                        if (!this.hasNext) {
                            throw new NoSuchElementException();
                        }
                        if (!names.isEmpty()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (String name : names) {
                                map.put(name, matcher.group(name));
                            }
                            RegexpPipe.this.binding = map;
                        } else {
                            RegexpPipe.this.binding = matcher.group(0);
                        }
                        this.hasNext = matcher.find();
                        return next;
                    }
                };
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return output;
    }

    protected Collection<String> getGroupNames(String pattern) {
        ArrayList<String> names = new ArrayList<String>();
        Matcher nameMatcher = PATTERN_NAME.matcher(pattern);
        while (nameMatcher.find()) {
            names.add(nameMatcher.group(1));
        }
        return names;
    }
}

