/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.bindings.JxltEngine;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeBindings {
    private static final Logger log = LoggerFactory.getLogger(PipeBindings.class);
    public static final String NN_ADDITIONALBINDINGS = "additionalBindings";
    public static final String PN_ADDITIONALSCRIPTS = "additionalScripts";
    public static final String NN_PROVIDERS = "providers";
    public static final String PN_ENGINE = "engine";
    public static final String FALSE_BINDING = "${false}";
    public static final String PATH_BINDING = "path";
    public static final String CACONFIG_BINDING = "caconfig";
    public static final String NAME_BINDING = "name";
    public static final String INJECTED_SCRIPT_REGEXP = "\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\}";
    private static final Pattern INJECTED_SCRIPT = Pattern.compile("\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\}");
    protected static final String IF_PREFIX = "$if";
    protected static final Pattern CONDITIONAL_STRING = Pattern.compile("^\\$if\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)+)\\}");
    ScriptEngine engine;
    ScriptContext scriptContext = new SimpleScriptContext();
    Map<String, String> pathBindings = new HashMap<String, String>();
    Map<String, String> nameBindings = new HashMap<String, String>();
    Map<String, Map<String, Object>> caconfigBindings = new HashMap<String, Map<String, Object>>();
    Map<String, Resource> outputResources = new HashMap<String, Resource>();
    boolean allowAdditionalScripts = true;
    String currentError;
    Plumber plumber;

    public PipeBindings(@NotNull Plumber plumber, @NotNull Resource resource) {
        this(resource, plumber.allowAdditionalScripts());
        this.plumber = plumber;
    }

    public PipeBindings(@NotNull Resource resource) {
        this(resource, false);
    }

    public PipeBindings(@NotNull Resource resource, boolean allowAdditionalScripts) {
        this.allowAdditionalScripts = allowAdditionalScripts;
        String engineName = (String)resource.getValueMap().get(PN_ENGINE, String.class);
        if (StringUtils.isNotBlank((CharSequence)engineName)) {
            this.initializeScriptEngine(engineName);
        }
        this.getBindings().put(PATH_BINDING, (Object)this.pathBindings);
        this.getBindings().put(NAME_BINDING, (Object)this.nameBindings);
        this.getBindings().put(CACONFIG_BINDING, (Object)this.caconfigBindings);
    }

    public static String embedAsScript(String value) {
        return "${" + value + "}";
    }

    public void addBinding(String name, Object value) {
        log.debug("Adding binding {}={}", (Object)name, value);
        this.getBindings().put(name, value);
    }

    public void addBindings(Map<String, Object> bindings) {
        log.info("Adding bindings {}", bindings);
        this.getBindings().putAll((Map<? extends String, ? extends Object>)bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScript(ResourceResolver resolver, String path) {
        if (!this.allowAdditionalScripts) {
            throw new SecurityException("additional scripts are not allowed per configuration");
        }
        InputStream is = null;
        try {
            Resource scriptResource;
            if (path.startsWith("http")) {
                try {
                    URL remoteScript = new URL(path);
                    is = remoteScript.openStream();
                }
                catch (Exception e) {
                    log.error("unable to retrieve remote script", (Throwable)e);
                }
            } else if (path.startsWith("/") && (scriptResource = resolver.getResource(path)) != null) {
                is = (InputStream)scriptResource.adaptTo(InputStream.class);
            }
            if (is != null) {
                try {
                    this.getEngine().eval((Reader)new InputStreamReader(is), this.scriptContext);
                }
                catch (Exception e) {
                    log.error("Add script: unable to evaluate script {}", (Object)path, (Object)e);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private int processMatcher(int start, String expr, StringBuilder expression, Matcher matcher) {
        if (matcher.start() > start) {
            if (expression.length() == 0) {
                expression.append("'");
            }
            expression.append(expr, start, matcher.start());
        }
        if (expression.length() > 0) {
            expression.append("' + ");
        }
        expression.append(matcher.group(1));
        start = matcher.end();
        if (start < expr.length()) {
            expression.append(" + '");
        }
        return start;
    }

    String computeTemplateExpression(String expr) {
        Matcher matcher = INJECTED_SCRIPT.matcher(expr);
        if (INJECTED_SCRIPT.matcher(expr).find()) {
            StringBuilder expression = new StringBuilder();
            int start = 0;
            while (matcher.find()) {
                start = this.processMatcher(start, expr, expression, matcher);
            }
            if (start < expr.length()) {
                expression.append(expr.substring(start) + "'");
            }
            return expression.toString();
        }
        return null;
    }

    private ScriptEngine getEngine() {
        if (this.engine == null && this.getBindings().containsKey(PN_ENGINE)) {
            this.initializeScriptEngine((String)this.getBindings().get(PN_ENGINE));
        }
        return this.engine;
    }

    protected Object evaluate(String expr) {
        try {
            String computed = this.computeTemplateExpression(expr);
            if (computed != null) {
                return this.getEngine() != null ? this.engine.eval(computed, this.scriptContext) : this.internalEvaluate(computed);
            }
        }
        catch (ScriptException | JexlException e) {
            throw new IllegalArgumentException(e);
        }
        return expr;
    }

    public Object instantiateObject(String expr) {
        return this.evaluate(expr);
    }

    private Object internalEvaluate(String expr) {
        JxltEngine internalEngine = new JxltEngine(this.getBindings());
        return internalEngine.parse(expr);
    }

    public Bindings getBindings() {
        return this.scriptContext.getBindings(100);
    }

    public Resource getExecutedResource(String name) {
        return this.outputResources.get(name);
    }

    public void initializeScriptEngine(String engineName) {
        this.engine = new ScriptEngineManager().getEngineByName(engineName);
        if (this.engine == null) {
            this.engine = new ScriptEngineManager(null).getEngineByName(engineName);
            if (this.engine == null) {
                throw new IllegalArgumentException("Can not instantiate " + engineName + " scriptengine. Check JVM version & capabilities.");
            }
        }
        this.engine.setContext(this.scriptContext);
    }

    public String conditionalString(String conditionalExpression) {
        Matcher matcher = CONDITIONAL_STRING.matcher(conditionalExpression);
        if (matcher.find()) {
            String s;
            Object output = this.evaluate(StringUtils.substringAfter((String)matcher.group(0), (String)IF_PREFIX));
            if (output != null && StringUtils.isNotEmpty((CharSequence)(s = output.toString().toLowerCase().trim())) && !"false".equals(s) && !"undefined".equals(s)) {
                return this.instantiateExpression(conditionalExpression.substring(matcher.group(0).length()));
            }
        } else {
            return this.instantiateExpression(conditionalExpression);
        }
        return null;
    }

    public String instantiateExpression(String expr) {
        Object obj = this.evaluate(expr);
        return obj != null ? obj.toString() : null;
    }

    public boolean isBindingDefined(String name) {
        return this.getBindings().containsKey(name);
    }

    public void updateBindings(Pipe pipe, Resource resource) {
        this.outputResources.put(pipe.getName(), resource);
        this.updateStaticBindings(pipe.getName(), resource);
        this.addBinding(pipe.getName(), pipe.getOutputBinding());
    }

    public void updateStaticBindings(String name, Resource resource) {
        if (resource != null) {
            this.pathBindings.put(name, resource.getPath());
            this.nameBindings.put(name, resource.getName());
            if (this.plumber != null) {
                this.caconfigBindings.put(name, this.plumber.getContextAwareConfigurationMap(resource));
            }
        }
    }

    public String popCurrentError() {
        String returnValue = this.currentError;
        this.currentError = null;
        return returnValue;
    }

    public void setCurrentError(String currentError) {
        this.currentError = currentError;
    }
}

