/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.pipes.it;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

@RunWith(PaxExam.class)
@ExamReactorStrategy(PerClass.class)
public class PlumberTestIT extends PipesTestSupport {

    public static final String ROOT = "/content/my";
    public static final String TEST_PATH = ROOT + "/" + NN_TEST;
    @Test
    public void simpleTest() throws Exception {
        try (ResourceResolver resolver = resolver()) {
            plumber.newPipe(resolver)
                .mkdir(ROOT)
                .write(NN_TEST, true)
                .run();
            Resource test = resolver.getResource(TEST_PATH);
            assertNotNull("there should be a resource", test);
            assertTrue("should be a boolean equals to true", test.adaptTo(Boolean.class));
        }
    }

}
