/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.AbstractPlumberServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=slingPipes/plumber", "sling.servlet.resourceTypes=slingPipes/container", "sling.servlet.resourceTypes=slingPipes/manifold", "sling.servlet.resourceTypes=slingPipes/authorizable", "sling.servlet.resourceTypes=slingPipes/write", "sling.servlet.resourceTypes=slingPipes/children", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.extensions=json", "sling.servlet.extensions=csv"})
public class PlumberServlet
extends AbstractPlumberServlet {
    public static final String RESOURCE_TYPE = "slingPipes/plumber";
    static final String PARAM_PATH = "path";
    static final String PARAM_BINDINGS = "bindings";
    static final String PARAM_ASYNC = "async";
    @Reference
    Plumber plumber;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (Arrays.asList(request.getRequestPathInfo().getSelectors()).contains("status")) {
            response.getWriter().append(this.plumber.getStatus(request.getResource()));
        } else {
            this.execute(request, response, false);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.execute(request, response, true);
    }

    void execute(SlingHttpServletRequest request, SlingHttpServletResponse response, boolean writeAllowed) throws ServletException {
        String path = request.getResource().getResourceType().equals(RESOURCE_TYPE) ? request.getParameter(PARAM_PATH) : request.getResource().getPath();
        try {
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new IllegalArgumentException("path should be provided");
            }
            Map<String, Object> bindings = this.plumber.getBindingsFromRequest(request, writeAllowed);
            String asyncParam = request.getParameter(PARAM_ASYNC);
            if (StringUtils.isNotBlank((CharSequence)asyncParam) && asyncParam.equals(Boolean.TRUE.toString())) {
                Job job = this.plumber.executeAsync(request.getResourceResolver(), path, bindings);
                if (job != null) {
                    response.getWriter().append("pipe execution registered as " + job.getId());
                    response.setStatus(201);
                } else {
                    response.sendError(500, "Some issue with your request, or server not being ready for async execution");
                }
            } else {
                OutputWriter writer = this.getWriter(request, response);
                this.plumber.execute(request.getResourceResolver(), path, bindings, writer, true);
            }
        }
        catch (AccessControlException e) {
            response.setStatus(403);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

