/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackagingService;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagePipe
extends BasePipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackagePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/package";
    public static final String PN_FILTERCOLLECTIONMODE = "filterCollectionMode";
    public static final String PN_ASSEMBLE = "assemble";
    public static final String PN_CHECKEXISTENCE = "checkExistence";
    DefaultWorkspaceFilter filters;
    JcrPackage jcrPackage;
    boolean assemble;
    boolean checkExistence;
    boolean filterCollectionMode;

    public PackagePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
        this.assemble = (Boolean)this.properties.get(PN_ASSEMBLE, (Object)true);
        this.checkExistence = (Boolean)this.properties.get(PN_CHECKEXISTENCE, (Object)true);
        this.filterCollectionMode = (Boolean)this.properties.get(PN_FILTERCOLLECTIONMODE, (Object)false);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    private Iterator<Resource> collectFilter() throws RepositoryException {
        Resource filterResource = this.getInput();
        if (filterResource != null || !this.checkExistence) {
            if (this.jcrPackage == null) {
                throw new IllegalArgumentException("Something went wrong while initiating the package");
            }
            if (this.filters == null) {
                this.filters = new DefaultWorkspaceFilter();
            }
            String filter = filterResource != null ? filterResource.getPath() : this.getComputedPath();
            this.filters.add(new PathFilterSet(filter));
            JcrPackageDefinition definition = this.jcrPackage.getDefinition();
            if (definition == null) {
                LOGGER.warn("package {} definition is null", (Object)this.jcrPackage);
            } else {
                definition.setFilter((WorkspaceFilter)this.filters, true);
                return IteratorUtils.singletonIterator((Object)this.getInput());
            }
        }
        return EMPTY_ITERATOR;
    }

    @Override
    protected Iterator<Resource> computeOutput() {
        try {
            this.init();
            return this.filterCollectionMode ? this.collectFilter() : EMPTY_ITERATOR;
        }
        catch (IOException | RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void init() throws IOException, RepositoryException {
        if (this.jcrPackage == null) {
            String packagePath = this.getExpr();
            Session session = (Session)this.resolver.adaptTo(Session.class);
            if (StringUtils.isNotBlank((CharSequence)packagePath) && session != null) {
                JcrPackageManager mgr = PackagingService.getPackageManager((Session)session);
                Node pkgNode = session.getNode(packagePath);
                if (pkgNode != null) {
                    this.jcrPackage = mgr.open(pkgNode);
                } else {
                    String parent = Text.getRelativeParent((String)packagePath, (int)1);
                    Resource folderResource = this.resolver.getResource(parent);
                    if (folderResource == null) {
                        LOGGER.error("folder of configured path should exists");
                    } else {
                        String name = Text.getName((String)packagePath);
                        this.jcrPackage = mgr.create((Node)folderResource.adaptTo(Node.class), name);
                    }
                }
            } else {
                LOGGER.error("expression should not be blank as it's supposed to hold package path");
            }
        }
    }

    @Override
    public void after() {
        super.after();
        if (this.assemble) {
            try {
                JcrPackageManager mgr = PackagingService.getPackageManager((Session)((Session)this.resolver.adaptTo(Session.class)));
                mgr.assemble(this.jcrPackage, null);
            }
            catch (IOException | RepositoryException | PackageException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

