/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritePipe
extends BasePipe {
    private static final Logger logger = LoggerFactory.getLogger(WritePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/write";
    protected static final Pattern ADD_PATCH = Pattern.compile("\\+\\[(.*)\\]");
    protected static final Pattern MULTI = Pattern.compile("\\[(.*)\\]");
    Node confTree;
    private List<Resource> propertiesToRemove;

    public WritePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    Node getConfTree() {
        if (this.confTree == null) {
            if (this.getConfiguration() == null) {
                String pathCandidate = this.getExpr();
                if (StringUtils.isBlank((CharSequence)pathCandidate)) {
                    throw new IllegalArgumentException("write pipe is mis-configured: it should have a configuration node, or an expression");
                }
                Resource candidate = this.resolver.getResource(pathCandidate);
                if (candidate != null) {
                    return (Node)candidate.adaptTo(Node.class);
                }
                throw new IllegalArgumentException("write pipe expression" + pathCandidate + " does not refer to any existing resource");
            }
            this.confTree = (Node)this.getConfiguration().adaptTo(Node.class);
        }
        return this.confTree;
    }

    protected Object computeValue(Resource resource, String key, String expression) {
        Object value = this.bindings.instantiateObject(expression);
        if (value instanceof String) {
            String sValue = (String)value;
            Matcher patch = ADD_PATCH.matcher(sValue);
            if (patch.matches()) {
                AbstractList newValues;
                String newValue = patch.group(1);
                String[] actualValues = (String[])resource.getValueMap().get(key, String[].class);
                AbstractList abstractList = newValues = actualValues != null ? new LinkedList<String>(Arrays.asList(actualValues)) : new ArrayList();
                if (!newValues.contains(newValue)) {
                    newValues.add(newValue);
                }
                return newValues.toArray(new String[newValues.size()]);
            }
            Matcher multiMatcher = MULTI.matcher(sValue);
            if (multiMatcher.matches()) {
                return multiMatcher.group(1).split(",");
            }
        }
        return value;
    }

    protected Object computeValue(Resource resource, String key, Object expression) {
        if (expression instanceof String) {
            return this.computeValue(resource, key, (String)expression);
        }
        if (expression instanceof String[]) {
            ArrayList<String> values = new ArrayList<String>();
            for (String expr : (String[])expression) {
                values.add((String)this.computeValue(resource, key, expr));
            }
            return values.toArray(new String[values.size()]);
        }
        return expression;
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    private void copyProperty(ModifiableValueMap targetProperties, Resource target, String key, Object value) {
        if (value == null) {
            this.addPropertyToRemove(target.getChild(key));
        } else {
            logger.info("writing {}@{}={}", new Object[]{target.getPath(), key, value});
            if (!this.isDryRun()) {
                targetProperties.put((Object)key, value);
            }
        }
    }

    private void copyProperties(@Nullable Resource conf, Resource target) {
        ValueMap writeMap = conf != null ? (ValueMap)conf.adaptTo(ValueMap.class) : null;
        ModifiableValueMap targetProperties = (ModifiableValueMap)target.adaptTo(ModifiableValueMap.class);
        if (this.properties != null && writeMap != null) {
            for (Map.Entry entry : writeMap.entrySet()) {
                if (IGNORED_PROPERTIES.contains(entry.getKey())) continue;
                String key = this.parent != null ? this.bindings.instantiateExpression((String)entry.getKey()) : (String)entry.getKey();
                Object value = this.computeValue(target, key, entry.getValue());
                this.copyProperty(targetProperties, target, key, value);
            }
        }
    }

    private void addPropertyToRemove(Resource property) {
        if (property != null) {
            if (this.propertiesToRemove == null) {
                this.propertiesToRemove = new ArrayList<Resource>();
            }
            this.propertiesToRemove.add(property);
        }
    }

    private void copyNode(Node source, Node targetNode) throws RepositoryException {
        String name = source.getName();
        if ((name = this.bindings.conditionalString(name)) == null) {
            logger.debug("name has been instantiated as null, not writing that tree");
        } else if (!this.isDryRun()) {
            Node childTarget = targetNode.hasNode(name) ? targetNode.getNode(name) : targetNode.addNode(name, source.getPrimaryNodeType().getName());
            logger.debug("writing tree {}", (Object)childTarget.getPath());
            this.writeTree(source, this.resolver.getResource(childTarget.getPath()));
        }
    }

    private void writeTree(Node conf, Resource target) throws RepositoryException {
        this.copyProperties(this.resolver.getResource(conf.getPath()), target);
        NodeIterator childrenConf = conf.getNodes();
        Node targetNode = (Node)target.adaptTo(Node.class);
        if (childrenConf.hasNext() && targetNode != null) {
            logger.info("dubbing {} at {}", (Object)conf.getPath(), (Object)target.getPath());
            while (childrenConf.hasNext()) {
                this.copyNode(childrenConf.nextNode(), targetNode);
            }
        }
    }

    void managePropertiesToRemove() throws RepositoryException {
        if (this.propertiesToRemove != null && !this.propertiesToRemove.isEmpty()) {
            for (Resource propertyResource : this.propertiesToRemove) {
                Property property;
                logger.info("removing {}", (Object)propertyResource.getPath());
                if (this.isDryRun() || (property = (Property)propertyResource.adaptTo(Property.class)) == null) continue;
                property.remove();
            }
        }
    }

    @Override
    protected Iterator<Resource> computeOutput() {
        try {
            Resource resource = this.getInput();
            if (resource != null) {
                this.writeTree(this.getConfTree(), resource);
                this.managePropertiesToRemove();
                Iterator<Resource> iterator = super.computeOutput();
                return iterator;
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (this.propertiesToRemove != null) {
                this.propertiesToRemove.clear();
            }
        }
        return EMPTY_ITERATOR;
    }
}

