/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPipe
extends BasePipe {
    public static final String RESOURCE_TYPE = "slingPipes/path";
    public static final String PN_NODETYPE = "nodeType";
    public static final String PN_RESOURCETYPE = "resourceType";
    public static final String PN_INTERMEDIATE = "intermediateType";
    public static final String PN_AUTOSAVE = "autosave";
    String nodeType;
    String resourceType;
    String intermediateType;
    boolean autosave;
    private final Logger logger = LoggerFactory.getLogger(PathPipe.class);

    public PathPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
        this.nodeType = (String)this.properties.get(PN_NODETYPE, String.class);
        this.resourceType = (String)this.properties.get(PN_RESOURCETYPE, (Object)"sling:Folder");
        this.intermediateType = (String)this.properties.get(PN_INTERMEDIATE, (Object)this.resourceType);
        this.autosave = (Boolean)this.properties.get(PN_AUTOSAVE, (Object)false);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    protected Iterator<Resource> computeOutput() {
        Iterator<Resource> output = Collections.emptyIterator();
        String expr = this.getExpr();
        try {
            String path = this.isRootPath(expr) ? expr : this.getInput().getPath() + "/" + expr;
            this.logger.info("creating path {}", (Object)path);
            if (!this.isDryRun()) {
                if (StringUtils.isNotBlank((CharSequence)this.nodeType)) {
                    JcrUtils.getOrCreateByPath((String)path, (String)this.intermediateType, (String)this.nodeType, (Session)((Session)this.resolver.adaptTo(Session.class)), (boolean)this.autosave);
                } else {
                    ResourceUtil.getOrCreateResource((ResourceResolver)this.resolver, (String)path, (String)this.resourceType, (String)this.intermediateType, (boolean)this.autosave);
                }
                Resource resource = this.resolver.getResource(path);
                output = Collections.singleton(resource).iterator();
            }
        }
        catch (RepositoryException | PersistenceException e) {
            this.logger.error("Not able to create path {}", (Object)expr, (Object)e);
        }
        return output;
    }
}

