/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.pipes.CommandExecutor;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.PipeExecutor;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.AbstractPlumberServlet;
import org.apache.sling.pipes.internal.CommandUtil;
import org.apache.sling.pipes.internal.JsonWriter;
import org.apache.sling.pipes.internal.NopWriter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, CommandExecutor.class}, property={"sling.servlet.resourceTypes=slingPipes/exec", "sling.servlet.methods=POST", "sling.servlet.extensions=json", "sling.servlet.extensions=csv"})
public class CommandExecutorImpl
extends AbstractPlumberServlet
implements CommandExecutor {
    final Logger log = LoggerFactory.getLogger(CommandExecutorImpl.class);
    public static final String RESOURCE_TYPE = "slingPipes/exec";
    static final String REQ_PARAM_FILE = "pipe_cmdfile";
    static final String REQ_PARAM_CMD = "pipe_cmd";
    static final String REQ_PARAM_HELP = "pipe_help";
    static final String CMD_LINE_PREFIX = "cmd_line_";
    static final String PN_DESCRIPTION = "commandParsed";
    static final String WHITE_SPACE_SEPARATOR = "[\\s\\h]";
    static final String COMMENT_PREFIX = "#";
    static final String SEPARATOR = "|";
    static final String PIPE_SEPARATOR = "[\\s\\h]*\\|[\\s\\h]*";
    static final String LINE_SEPARATOR = " ";
    static final String PARAMS = "@";
    static final List<String> JSON_EXPR_KEYS = Arrays.asList("json");
    static final String JSON_START = "\"[{";
    static final String PARAMS_SEPARATOR = "[\\s\\h]+@[\\s\\h]*";
    static final Pattern SUB_TOKEN_PATTERN = Pattern.compile("(([^\"]\\S*)|\"([^\"]+)\")\\s*");
    static final String KEY_NAME = "name";
    static final String KEY_PATH = "path";
    static final String KEY_EXPR = "expr";
    private static final String HELP_START = "\n a <pipe token> is <pipe> <expr|conf>? (<options>)?\n <options> are (@ <option>)* form with <option> being either\n\t'name pipeName' (used in bindings), \n\t'expr pipeExpression' (when not directly as <args>)\n\t'path pipePath' (when not directly as <args>)\n\t'bindings key=value ...' (for setting pipe bindings) \n\t'with key=value ...' (for setting pipe specific properties)\n\t'outputs key=value ...' (for setting outputs)\n and <pipe> is one of the following :\n";
    Map<String, Method> methodMap;
    Map<String, PipeExecutor> executorMap;
    String help;
    @Reference
    Plumber plumber;

    @Activate
    @Modified
    public void activate() {
        this.methodMap = null;
        this.executorMap = null;
        this.help = null;
    }

    boolean isCommandCandidate(String line) {
        return StringUtils.isNotBlank((CharSequence)line) && !line.startsWith(COMMENT_PREFIX);
    }

    List<String> getCommandList(SlingHttpServletRequest request) throws IOException {
        ArrayList<String> cmds = new ArrayList<String>();
        if (request.getParameterMap().containsKey(REQ_PARAM_CMD)) {
            cmds.add(request.getParameter(REQ_PARAM_CMD));
        } else {
            RequestParameter paramFile = request.getRequestParameter(REQ_PARAM_FILE);
            if (paramFile != null) {
                String line;
                InputStream is = paramFile.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                StringBuilder cmdBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    if (this.isCommandCandidate(line)) {
                        cmdBuilder.append(LINE_SEPARATOR + line.trim());
                        continue;
                    }
                    if (cmdBuilder.length() <= 0) continue;
                    cmds.add(cmdBuilder.toString().trim());
                    cmdBuilder = new StringBuilder();
                }
                if (cmdBuilder.length() > 0) {
                    cmds.add(cmdBuilder.toString().trim());
                }
            }
        }
        return cmds;
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String currentCommand = null;
        PrintWriter writer = response.getWriter();
        try {
            if (request.getParameter(REQ_PARAM_HELP) != null) {
                writer.println(this.help());
            } else {
                ResourceResolver resolver = request.getResourceResolver();
                Map<String, Object> bindings = this.plumber.getBindingsFromRequest(request, true);
                List<String> cmds = this.getCommandList(request);
                if (cmds.isEmpty()) {
                    writer.println("No command to execute!");
                }
                int idxLine = 0;
                OutputWriter pipeWriter = this.getWriter(request, response);
                if (pipeWriter == null) {
                    pipeWriter = new NopWriter();
                }
                pipeWriter.disableAutoClose();
                pipeWriter.init(request, response);
                for (String command : cmds) {
                    if (!StringUtils.isNotBlank((CharSequence)command)) continue;
                    currentCommand = command;
                    PipeBuilder pipeBuilder = this.parse(resolver, command);
                    Pipe pipe = pipeBuilder.build();
                    int n = idxLine;
                    idxLine = (short)(idxLine + 1);
                    bindings.put(CMD_LINE_PREFIX + n, pipe.getResource().getPath());
                    ModifiableValueMap root = (ModifiableValueMap)pipe.getResource().adaptTo(ModifiableValueMap.class);
                    root.put((Object)PN_DESCRIPTION, (Object)command);
                    this.plumber.execute(resolver, pipe, bindings, pipeWriter, true);
                }
                pipeWriter.ends();
            }
            writer.println("");
            response.setStatus(200);
        }
        catch (AccessControlException e) {
            response.setStatus(403);
            response.sendError(403);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            writer.println("Error executing " + currentCommand);
            e.printStackTrace(writer);
            response.setStatus(500);
            response.sendError(500);
            writer.println(this.help());
        }
        catch (IllegalArgumentException | JsonException e) {
            writer.println("Error executing " + currentCommand);
            e.printStackTrace(writer);
            response.setStatus(406);
            response.sendError(406);
            writer.println(this.help());
        }
    }

    @Override
    public ExecutionResult execute(ResourceResolver resolver, String path, String ... optionTokens) {
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("%s resource does not exist", path));
        }
        Options options = this.getOptions(optionTokens);
        HashMap<String, Object> bMap = null;
        if (options.with != null) {
            bMap = new HashMap<String, Object>();
            CommandUtil.writeToMap(bMap, true, options.with);
        }
        OutputWriter writer = new NopWriter();
        if (options.outputs != null) {
            writer = new JsonWriter();
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            CommandUtil.writeToMap(outputs, true, options.outputs);
            writer.setCustomOutputs(outputs);
        }
        writer.starts();
        return this.plumber.execute(resolver, path, bMap, writer, true);
    }

    @Override
    public PipeBuilder parse(ResourceResolver resolver, String ... cmds) throws InvocationTargetException, IllegalAccessException {
        PipeBuilder builder = this.plumber.newPipe(resolver);
        for (Token token : this.parseTokens(cmds)) {
            Method method = this.getMethodMap().get(token.pipeKey);
            if (method == null) {
                throw new IllegalArgumentException(token.pipeKey + " is not a valid pipe");
            }
            if (this.isExpressionExpected(method)) {
                method.invoke((Object)builder, token.args.get(0));
            } else if (this.isConfExpected(method)) {
                method.invoke((Object)builder, new Object[]{CommandUtil.keyValuesToArray(token.args)});
            } else if (this.isWithoutExpectedParameter(method)) {
                method.invoke((Object)builder, new Object[0]);
            }
            if (token.options == null) continue;
            token.options.writeToBuilder(builder);
        }
        return builder;
    }

    protected Options getOptions(String[] tokens) {
        return this.getOptions(Arrays.asList(tokens));
    }

    protected Options getOptions(List<String> tokens) {
        return new Options(tokens);
    }

    List<String> getSpaceSeparatedTokens(String token) {
        ArrayList<String> subTokens = new ArrayList<String>();
        Matcher matcher = SUB_TOKEN_PATTERN.matcher(token);
        while (matcher.find()) {
            subTokens.add(matcher.group(2) != null ? matcher.group(2) : matcher.group(3));
        }
        return subTokens;
    }

    protected List<Token> parseTokens(String ... commands) {
        ArrayList<Token> returnValue = new ArrayList<Token>();
        String cat = String.join((CharSequence)"", commands);
        for (String token : cat.split(PIPE_SEPARATOR)) {
            List<String> subTokens;
            Token currentToken = new Token();
            String[] options = token.split(PARAMS_SEPARATOR);
            if (options.length > 1) {
                currentToken.options = this.getOptions(Arrays.copyOfRange(options, 1, options.length));
            }
            if (!(subTokens = this.getSpaceSeparatedTokens(options[0])).isEmpty()) {
                currentToken.pipeKey = subTokens.get(0);
                if (subTokens.size() > 1) {
                    currentToken.args = subTokens.subList(1, subTokens.size());
                    if (JSON_EXPR_KEYS.contains(currentToken.pipeKey) && JSON_START.indexOf(currentToken.args.get(0).getBytes(StandardCharsets.UTF_8)[0]) > 0) {
                        currentToken.args = Collections.singletonList(String.join((CharSequence)"", currentToken.args));
                    }
                }
            }
            this.log.trace("generated following token {}", (Object)currentToken);
            returnValue.add(currentToken);
        }
        return returnValue;
    }

    protected void computeMaps() {
        this.executorMap = new HashMap<String, PipeExecutor>();
        this.methodMap = new HashMap<String, Method>();
        for (Method method : PipeBuilder.class.getDeclaredMethods()) {
            PipeExecutor executor = method.getAnnotation(PipeExecutor.class);
            if (executor == null) continue;
            this.methodMap.put(executor.command(), method);
            this.executorMap.put(executor.command(), executor);
        }
    }

    protected Map<String, Method> getMethodMap() {
        if (this.methodMap == null) {
            this.computeMaps();
        }
        return this.methodMap;
    }

    protected Map<String, PipeExecutor> getExecutorMap() {
        if (this.executorMap == null) {
            this.computeMaps();
        }
        return this.executorMap;
    }

    protected boolean isExpressionExpected(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class);
    }

    protected boolean isConfExpected(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object[].class);
    }

    protected boolean isWithoutExpectedParameter(Method method) {
        return method.getParameterCount() == 0;
    }

    @Override
    public String help() {
        if (StringUtils.isBlank((CharSequence)this.help)) {
            StringBuilder builder = new StringBuilder();
            builder.append(HELP_START);
            for (Map.Entry<String, PipeExecutor> entry : this.getExecutorMap().entrySet()) {
                builder.append(String.format("\t%s\t\t:\t%s%n", entry.getKey(), entry.getValue().description()));
            }
            this.help = builder.toString();
        }
        return this.help;
    }

    protected class Token {
        String pipeKey;
        List<String> args;
        Options options;

        protected Token() {
        }

        public String toString() {
            return "Token{pipeKey='" + this.pipeKey + '\'' + ", args=" + this.args + ", options=" + this.options + '}';
        }
    }

    protected class Options {
        String name;
        String path;
        String expr;
        String[] with;
        String[] bindings;
        String[] outputs;

        public String toString() {
            return "Options{name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", expr='" + this.expr + '\'' + ", with=" + Arrays.toString(this.with) + ", bindings=" + Arrays.toString(this.bindings) + ", outputs=" + Arrays.toString(this.outputs) + '}';
        }

        void setOutputs(List<String> values) {
            this.outputs = CommandUtil.keyValuesToArray(values);
        }

        protected Options(List<String> options) {
            HashMap<String, Object> optionMap = new HashMap<String, Object>();
            for (String string : options) {
                String currentKey = null;
                ArrayList<String> currentList = new ArrayList<String>();
                for (String subToken : CommandExecutorImpl.this.getSpaceSeparatedTokens(string)) {
                    if (currentKey == null) {
                        currentKey = subToken;
                        continue;
                    }
                    currentList.add(subToken);
                }
                this.finishOption(currentKey, currentList, optionMap);
            }
            block18: for (Map.Entry entry : optionMap.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "name": {
                        this.name = (String)entry.getValue();
                        continue block18;
                    }
                    case "path": {
                        this.path = (String)entry.getValue();
                        continue block18;
                    }
                    case "expr": {
                        this.expr = (String)entry.getValue();
                        continue block18;
                    }
                    case "with": {
                        this.with = CommandUtil.keyValuesToArray((List)entry.getValue());
                        continue block18;
                    }
                    case "bindings": {
                        this.bindings = CommandUtil.keyValuesToArray((List)entry.getValue());
                        continue block18;
                    }
                    case "outputs": {
                        this.setOutputs((List)entry.getValue());
                        continue block18;
                    }
                }
                throw new IllegalArgumentException(String.format("%s is an unknown option", entry.getKey()));
            }
        }

        protected void finishOption(String currentKey, List<String> currentList, Map<String, Object> optionMap) {
            if (currentList != null) {
                if (currentKey.equals(CommandExecutorImpl.KEY_NAME) || currentKey.equals(CommandExecutorImpl.KEY_EXPR) || currentKey.equals(CommandExecutorImpl.KEY_PATH)) {
                    optionMap.put(currentKey, currentList.get(0));
                } else {
                    optionMap.put(currentKey, currentList);
                }
            }
        }

        void writeToBuilder(PipeBuilder builder) throws IllegalAccessException {
            if (StringUtils.isNotBlank((CharSequence)this.name)) {
                builder.name(this.name);
            }
            if (StringUtils.isNotBlank((CharSequence)this.path)) {
                builder.path(this.path);
            }
            if (StringUtils.isNotBlank((CharSequence)this.expr)) {
                builder.expr(this.expr);
            }
            if (this.with != null) {
                builder.with(this.with);
            }
            if (this.bindings != null) {
                builder.bindings(this.bindings);
            }
            if (this.outputs != null) {
                builder.outputs(this.outputs);
            }
        }
    }
}

