/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriter
extends OutputWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonWriter.class);
    protected JsonGenerator jsonGenerator;
    public static final String JSON_EXTENSION = "json";

    JsonWriter() {
        this.setWriter(new StringWriter());
    }

    @Override
    public boolean handleRequest(SlingHttpServletRequest request) {
        return JSON_EXTENSION.equals(request.getRequestPathInfo().getExtension());
    }

    @Override
    protected void initResponse(SlingHttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
    }

    @Override
    public void starts() {
        this.jsonGenerator = Json.createGenerator((Writer)this.writer);
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeStartArray("items");
    }

    @Override
    public void writeItem(Resource resource) {
        if (this.customOutputs == null) {
            this.jsonGenerator.write(resource.getPath());
        } else {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.write("path", resource.getPath());
            for (Map.Entry entry : this.customOutputs.entrySet()) {
                this.jsonGenerator.write((String)entry.getKey(), this.computeValue((String)entry.getKey()));
            }
            this.jsonGenerator.writeEnd();
        }
    }

    @Override
    public void ends() {
        this.jsonGenerator.writeEnd();
        this.jsonGenerator.write("size", this.size);
        if (this.nbErrors > 0L) {
            this.jsonGenerator.write("nbErrors", this.nbErrors);
            this.jsonGenerator.writeStartArray("errors");
            for (String error : this.errors) {
                this.jsonGenerator.write(error);
            }
            this.jsonGenerator.writeEnd();
        }
        this.jsonGenerator.writeEnd();
        this.jsonGenerator.flush();
    }
}

