/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.pipes.PipeBindings;
import org.jetbrains.annotations.NotNull;

public class CommandUtil {
    static final String PAIR_SEP = ",";
    static final String KEY_VALUE_SEP = "=";
    static final String FIRST_TOKEN = "first";
    static final String SECOND_TOKEN = "second";
    private static final Pattern UNEMBEDDEDSCRIPT_PATTERN = Pattern.compile("^(\\d+(\\.\\d+)?)|(\\[.*]$)|(\\w[\\w_\\-\\d]+\\..+)|(\\w[\\w_\\-\\d]+\\['.+'])|(true$|false$)|(new .*)|(.*'$)");
    static final String CONFIGURATION_TOKEN = "(?<first>[\\w/\\:]+)\\s*=(?<second>[(\\w*)|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)*)\\}]+)";
    public static final Pattern CONFIGURATION_PATTERN = Pattern.compile("(?<first>[\\w/\\:]+)\\s*=(?<second>[(\\w*)|\\$\\{(([^\\{^\\}]+(\\{[0-9,]+\\})?)*)\\}]+)");

    private CommandUtil() {
    }

    public static void checkArguments(Object ... params) {
        if (params.length % 2 > 0) {
            throw new IllegalArgumentException("there should be an even number of arguments");
        }
    }

    static Object embedIfNeeded(Object value) {
        Matcher matcher;
        if (value instanceof String && (matcher = UNEMBEDDEDSCRIPT_PATTERN.matcher(value.toString())).matches()) {
            return PipeBindings.embedAsScript(value.toString());
        }
        return value;
    }

    public static void writeToMap(Map<String, Object> map, boolean embed, Object ... params) {
        for (int i = 0; i < params.length - 1; i += 2) {
            map.put(params[i].toString(), embed ? CommandUtil.embedIfNeeded(params[i + 1]) : params[i + 1]);
        }
    }

    public static Map stringToMap(@NotNull String input, Function<String, String> valueTransformer) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : input.split(PAIR_SEP)) {
            Matcher matcher = CONFIGURATION_PATTERN.matcher(pair);
            if (!matcher.find()) continue;
            map.put(matcher.group(FIRST_TOKEN), valueTransformer.apply(matcher.group(SECOND_TOKEN)));
        }
        return map;
    }

    public static String[] keyValuesToArray(List<String> o) {
        ArrayList<String> args = new ArrayList<String>();
        if (o != null) {
            for (String pair : o) {
                Matcher matcher = CONFIGURATION_PATTERN.matcher(pair.trim());
                if (!matcher.matches()) continue;
                args.add(matcher.group(FIRST_TOKEN));
                args.add(matcher.group(SECOND_TOKEN));
            }
        }
        return args.toArray(new String[args.size()]);
    }
}

