/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.SuperPipe;
import org.apache.sling.pipes.internal.bindings.BindingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePipe
implements Pipe {
    private final Logger logger = LoggerFactory.getLogger(BasePipe.class);
    public static final String SLASH = "/";
    public static final String RT_PREFIX = "slingPipes/";
    public static final String RESOURCE_TYPE = "slingPipes/base";
    public static final String DRYRUN_KEY = "dryRun";
    public static final String DRYRUN_EXPR = "${dryRun}";
    public static final String READ_ONLY = "readOnly";
    public static final String PN_STATUS = "status";
    public static final String PN_STATUS_MODIFIED = "statusModified";
    public static final String PN_BEFOREHOOK = "beforeHook";
    public static final String PN_AFTERHOOK = "afterHook";
    public static final String STATUS_STARTED = "started";
    public static final String STATUS_FINISHED = "finished";
    protected ResourceResolver resolver;
    protected ValueMap properties;
    protected Resource resource;
    protected SuperPipe parent;
    protected String distributionAgent;
    protected PipeBindings bindings;
    protected List<BindingProvider> bindingProviders;
    protected String beforeHook;
    protected String afterHook;
    protected static final List<String> IGNORED_PROPERTIES = Arrays.asList("jcr:lastModified", "jcr:primaryType", "jcr:created", "jcr:createdBy", "jcr:versionHistory", "jcr:predecessors", "jcr:baseVersion", "jcr:uuid", "jcr:isCheckedOut");
    Boolean dryRunObject = null;
    protected Plumber plumber;
    private String name;
    public static final Iterator<Resource> EMPTY_ITERATOR = Collections.emptyIterator();

    @Override
    public SuperPipe getParent() {
        return this.parent;
    }

    @Override
    public void setParent(SuperPipe parent) {
        this.parent = parent;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public BasePipe(@NotNull Plumber plumber, @NotNull Resource resource, @Nullable PipeBindings upperBindings) {
        this.resource = resource;
        this.properties = resource.getValueMap();
        this.resolver = resource.getResourceResolver();
        this.plumber = plumber;
        this.name = (String)this.properties.get("name", (Object)resource.getName());
        this.distributionAgent = (String)this.properties.get("distribution.agent", String.class);
        this.beforeHook = (String)this.properties.get(PN_BEFOREHOOK, String.class);
        this.afterHook = (String)this.properties.get(PN_AFTERHOOK, String.class);
        this.extractAdditionalBindings(resource, upperBindings);
    }

    private void fillInProviders(@NotNull Resource additionalBindings) {
        Resource providers = additionalBindings.getChild("providers");
        if (providers != null) {
            this.logger.debug("bindings provider are detected");
            this.bindingProviders = new ArrayList<BindingProvider>();
            for (Resource provider : providers.getChildren()) {
                Pipe pipe = this.plumber.getPipe(provider, this.bindings);
                if (pipe == null) {
                    this.logger.error("pipe provided in {} is not correct", (Object)provider.getPath());
                    continue;
                }
                if (pipe.modifiesContent()) {
                    this.logger.error("content modifiers like {} are not usable as binding providers", (Object)provider.getPath());
                    continue;
                }
                this.bindingProviders.add(new BindingProvider(pipe));
            }
        }
    }

    private void extractAdditionalBindings(@NotNull Resource resource, @Nullable PipeBindings upperBindings) {
        String[] scripts;
        Resource scriptsResource;
        this.bindings = upperBindings == null ? new PipeBindings(this.plumber, resource) : upperBindings;
        Resource additionalBindings = resource.getChild("additionalBindings");
        if (additionalBindings != null) {
            this.logger.debug("additional bindings are detected");
            ValueMap additionalMap = (ValueMap)additionalBindings.adaptTo(ValueMap.class);
            this.bindings.addBindings((Map<String, Object>)additionalMap);
            for (String ignoredProperty : IGNORED_PROPERTIES) {
                this.bindings.getBindings().remove(ignoredProperty);
            }
            this.fillInProviders(additionalBindings);
        }
        if ((scriptsResource = resource.getChild("additionalScripts")) != null && (scripts = (String[])scriptsResource.adaptTo(String[].class)) != null) {
            for (String script : scripts) {
                this.bindings.addScript(resource.getResourceResolver(), script);
            }
        }
        this.bindings.addBinding(this.getName(), "");
    }

    @Override
    public boolean isDryRun() {
        if (this.dryRunObject == null) {
            this.dryRunObject = false;
            if (this.bindings.isBindingDefined(DRYRUN_KEY)) {
                Object run = this.bindings.instantiateObject(DRYRUN_EXPR);
                this.dryRunObject = true;
                if (run instanceof Boolean) {
                    this.dryRunObject = (Boolean)run;
                } else if (run == null || run instanceof String && Boolean.FALSE.toString().equals(run)) {
                    this.dryRunObject = false;
                }
            }
            this.logger.debug("setting dryrun object to {}", (Object)this.dryRunObject);
        }
        return this.dryRunObject;
    }

    public String toString() {
        return this.name + " (path: " + this.resource.getPath() + ", dryRun: " + this.isDryRun() + ", modifiesContent: " + this.modifiesContent() + ")";
    }

    @Override
    public boolean modifiesContent() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getRawExpression() {
        return (String)this.properties.get("expr", (Object)"");
    }

    public String getExpr() {
        return this.bindings.instantiateExpression(this.getRawExpression());
    }

    protected String getRawPath() {
        return (String)this.properties.get("path", (Object)"");
    }

    public String getPath() {
        String rawPath = this.getRawPath();
        return this.bindings.instantiateExpression(rawPath);
    }

    protected String getComputedPath() {
        String path = this.getPath();
        if (StringUtils.isNotBlank((CharSequence)path) && !this.isRootPath(path) && this.getPreviousResource() != null) {
            path = this.getPreviousResource().getPath() + SLASH + path;
        }
        return path;
    }

    protected boolean isRootPath(String path) {
        return path.startsWith(SLASH);
    }

    protected Pipe getPreviousPipe() {
        return this.parent != null ? this.parent.getPreviousPipe(this) : null;
    }

    protected Resource getPreviousResource() {
        Pipe previousPipe;
        if (this.parent != null && (previousPipe = this.getPreviousPipe()) != null) {
            return this.bindings.getExecutedResource(previousPipe.getName());
        }
        return null;
    }

    @Override
    @Nullable
    public Resource getInput() {
        String path = this.getComputedPath();
        Resource input = null;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            input = this.resolver.getResource(path);
            if (input == null) {
                this.logger.warn("configured path {} for {} is not found, expect some troubles...", (Object)path, (Object)this.getName());
            }
        } else {
            input = this.getPreviousResource();
            if (input == null) {
                this.logger.warn("no valid path has been configured for {}, and no previous resource to bind on, expect some troubles...", (Object)this.getName());
            }
        }
        this.logger.debug("input for this pipe is {}", (Object)(input != null ? input.getPath() : null));
        return input;
    }

    @Override
    public Object getOutputBinding() {
        Resource output;
        if (this.parent != null && (output = this.bindings.getExecutedResource(this.getName())) != null) {
            return output.adaptTo(ValueMap.class);
        }
        return null;
    }

    @Override
    public PipeBindings getBindings() {
        return this.bindings;
    }

    protected void provideAdditionalBindings() throws InterruptedException, ExecutionException {
        if (this.bindingProviders != null && !this.bindingProviders.isEmpty()) {
            ExecutorService executor = Executors.newWorkStealingPool();
            List additionalBindings = executor.invokeAll(this.bindingProviders);
            for (Future additionalBinding : additionalBindings) {
                ValueMap binding = (ValueMap)additionalBinding.get();
                Pipe pipe = this.bindingProviders.get(additionalBindings.indexOf(additionalBinding)).getPipe();
                this.logger.debug("adding binding {}={}", (Object)pipe.getName(), (Object)binding);
                this.bindings.addBinding(pipe.getName(), binding);
            }
        }
    }

    @Override
    public Iterator<Resource> getOutput() {
        try {
            this.provideAdditionalBindings();
            return this.computeOutput();
        }
        catch (Exception e) {
            Resource input;
            String path = this.getRawPath();
            if (StringUtils.isBlank((CharSequence)path) && (input = this.getPreviousResource()) != null) {
                path = this.resource.getPath();
            }
            this.bindings.setCurrentError(path);
            this.logger.error("error with pipe execution from {}", (Object)path, (Object)e);
            return EMPTY_ITERATOR;
        }
    }

    @Override
    public void before() {
        if (StringUtils.isNotBlank((CharSequence)this.beforeHook)) {
            this.plumber.newPipe(this.resolver).ref(this.beforeHook).run();
        }
    }

    @Override
    public void after() {
        if (StringUtils.isNotBlank((CharSequence)this.afterHook)) {
            this.plumber.newPipe(this.resolver).ref(this.afterHook).run();
        }
    }

    protected Iterator<Resource> computeOutput() {
        Resource input = this.getInput();
        if (input != null) {
            return Collections.singleton(input).iterator();
        }
        return EMPTY_ITERATOR;
    }

    public Resource getConfiguration() {
        return this.resource.getChild("conf");
    }

    @Override
    public String getDistributionAgent() {
        return this.distributionAgent;
    }
}

