/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.models;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class PipeModel {
    Logger LOG = LoggerFactory.getLogger(PipeModel.class);
    protected static final String NN_PIPES = "pipes";
    protected static final String BINDING_CURRENTRESOURCE = "currentResource";
    protected Map<String, Iterator<Resource>> outputs;
    @OSGiService
    protected Plumber plumber;
    protected Resource root;
    protected Resource currentResource;

    public Map<String, Iterator<Resource>> getOutputs() {
        return this.outputs;
    }

    public PipeModel(Resource resource) {
        this.currentResource = resource;
        this.LOG.debug("constructing Pipe Model with {}", (Object)this.currentResource.getPath());
        this.root = resource.getChild(NN_PIPES);
    }

    @PostConstruct
    protected void init() {
        this.LOG.debug("initialising Pipe Model");
        if (this.root != null) {
            this.outputs = new HashMap<String, Iterator<Resource>>();
            Iterator pipeCandidates = this.root.listChildren();
            while (pipeCandidates.hasNext()) {
                Resource candidate = (Resource)pipeCandidates.next();
                try {
                    Pipe pipe = this.plumber.getPipe(candidate);
                    pipe.getBindings().addBinding(BINDING_CURRENTRESOURCE, this.currentResource.adaptTo(ValueMap.class));
                    pipe.getBindings().updateStaticBindings(BINDING_CURRENTRESOURCE, this.currentResource);
                    this.outputs.put(pipe.getName(), pipe.getOutput());
                    this.LOG.debug("found and initialized {}", (Object)pipe.getName());
                }
                catch (Exception e) {
                    this.LOG.error("unable to bind {}\u00a0pipe", (Object)candidate.getPath(), (Object)e);
                }
            }
        } else {
            this.LOG.debug("no root node found");
        }
    }
}

