/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPipe
extends BasePipe {
    public static final String RESOURCE_TYPE = "slingPipes/path";
    public static final String PN_RESOURCETYPE = "resourceType";
    public static final String PN_NODETYPE = "nodeType";
    public static final String PN_INTERMEDIATE = "intermediateType";
    public static final String PN_AUTOSAVE = "autosave";
    String resourceType;
    String nodeType;
    String intermediateType;
    boolean autosave;
    boolean jcr;
    private final Logger logger = LoggerFactory.getLogger(PathPipe.class);

    public PathPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
        this.nodeType = (String)this.properties.get(PN_NODETYPE, String.class);
        this.resourceType = (String)this.properties.get(PN_RESOURCETYPE, (Object)"sling:Folder");
        this.jcr = StringUtils.isNotBlank((CharSequence)this.nodeType);
        this.intermediateType = (String)this.properties.get(PN_INTERMEDIATE, (Object)this.resourceType);
        this.autosave = (Boolean)this.properties.get(PN_AUTOSAVE, (Object)false);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    protected Iterator<Resource> computeOutput() throws Exception {
        Iterator<Resource> output = Collections.emptyIterator();
        String expr = this.getExpr();
        try {
            String path = this.isRootPath(expr) ? expr : this.getInput().getPath() + "/" + expr;
            this.logger.info("creating path {}", (Object)path);
            if (!this.isDryRun()) {
                Resource resource = this.jcr ? this.getOrCreateNode(path) : ResourceUtil.getOrCreateResource((ResourceResolver)this.resolver, (String)path, (String)this.resourceType, (String)this.intermediateType, (boolean)this.autosave);
                output = Collections.singleton(resource).iterator();
            }
        }
        catch (PersistenceException e) {
            this.logger.error("Not able to create path {}", (Object)expr, (Object)e);
        }
        return output;
    }

    protected Resource getOrCreateNode(String path) throws RepositoryException {
        Node leaf = null;
        boolean transientChange = false;
        String relativePath = path.substring(1);
        Node parentNode = ((Session)this.resolver.adaptTo(Session.class)).getRootNode();
        if (!parentNode.hasNode(relativePath)) {
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            node.addNode(token, this.intermediateType);
                            transientChange = true;
                        }
                        catch (RepositoryException re) {
                            node.getSession().refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                node.addNode(relativePath, this.nodeType);
                transientChange = true;
            }
            leaf = node.getNode(relativePath);
        }
        if (leaf == null) {
            leaf = parentNode.getNode(relativePath);
        }
        if (transientChange && this.autosave) {
            ((Session)this.resolver.adaptTo(Session.class)).save();
        }
        return this.resolver.getResource(leaf.getPath());
    }
}

