/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.PipeExecutor;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.CommandUtil;
import org.apache.sling.pipes.internal.JsonWriter;
import org.apache.sling.pipes.internal.NopWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={GogoCommands.class}, property={"osgi.command.scope=pipe", "osgi.command.function=build", "osgi.command.function=run", "osgi.command.function=execute", "osgi.command.function=help"})
public class GogoCommands {
    final Logger log = LoggerFactory.getLogger(GogoCommands.class);
    protected static final String SEPARATOR = "/";
    protected static final String PARAMS = "@";
    protected static final String INPUT = "-";
    protected static final String KEY_VALUE_SEP = "=";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_PATH = "path";
    protected static final String KEY_EXPR = "expr";
    @Reference
    ResourceResolverFactory factory;
    @Reference
    Plumber plumber;
    Map<String, Method> methodMap;
    Map<String, PipeExecutor> executorMap;

    public void run(String ... cmds) throws Exception {
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.plumber.getServiceUser());){
            PipeBuilder builder = this.parse(resolver, cmds);
            System.out.println(builder.run());
        }
    }

    public void build(String ... cmds) throws Exception {
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.plumber.getServiceUser());){
            PipeBuilder builder = this.parse(resolver, cmds);
            System.out.println(builder.build().getResource().getPath());
        }
    }

    public void execute(String path, String ... options) throws Exception {
        String computedPath = INPUT.equals(path) ? IOUtils.toString((InputStream)System.in).trim() : path;
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(this.plumber.getServiceUser());){
            System.out.println(this.executeInternal(resolver, computedPath, options));
        }
        catch (Exception e) {
            this.log.error("Unable to execute {}", (Object)path, (Object)e);
            throw e;
        }
    }

    protected ExecutionResult executeInternal(ResourceResolver resolver, String path, String ... optionTokens) throws Exception {
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("%s resource does not exist", path));
        }
        Options options = this.getOptions(optionTokens);
        HashMap bMap = null;
        if (options.with != null) {
            bMap = new HashMap();
            CommandUtil.writeToMap(bMap, options.with);
        }
        OutputWriter writer = new NopWriter();
        if (options.writer != null) {
            writer = options.writer;
        }
        ((OutputWriter)writer).starts();
        return this.plumber.execute(resolver, path, bMap, writer, true);
    }

    public void help() {
        System.out.format("\nSling Pipes Help\nAvailable commands are \n\n- execute <path> <options>(execute a pipe already built at a given path), if path is '-' then previous pipe token is used,\n- build (build pipe as configured in arguments)\n- run (run pipe as configured in arguments)\n- help (print this help)\n\nfor pipe configured in argument, do 'pipe:<run|build|runAsync> <pipe token> (/ <pipe token> )*\n\n a <pipe token> is <pipe> <expr|conf>? (<options>)?\n <options> are (@ <option>)* form with <option> being either\n\t'name pipeName' (used in bindings), \n\t'expr pipeExpression' (when not directly as <args>)\n\t'path pipePath' (when not directly as <args>)\n\t'with key=value ...'\n\t'outputs key=value ...'\n and <pipe> is one of the following :\n", new Object[0]);
        for (Map.Entry<String, PipeExecutor> entry : this.getExecutorMap().entrySet()) {
            System.out.format("\t%s\t\t:\t%s\n", entry.getKey(), entry.getValue().description());
        }
    }

    protected PipeBuilder parse(ResourceResolver resolver, String ... cmds) throws InvocationTargetException, IllegalAccessException {
        PipeBuilder builder = this.plumber.newPipe(resolver);
        for (Token token : this.parseTokens(cmds)) {
            Method method = this.getMethodMap().get(token.pipeKey);
            if (method == null) {
                throw new IllegalArgumentException(token.pipeKey + " is not a valid pipe");
            }
            if (this.isExpressionExpected(method)) {
                method.invoke((Object)builder, token.args.get(0));
            } else if (this.isConfExpected(method)) {
                method.invoke((Object)builder, new Object[]{this.keyValuesToArray(token.args)});
            } else if (this.isWithoutExpectedParameter(method)) {
                method.invoke((Object)builder, new Object[0]);
            }
            if (token.options == null) continue;
            token.options.writeToBuilder(builder);
        }
        return builder;
    }

    protected void computeMaps() {
        this.executorMap = new HashMap<String, PipeExecutor>();
        this.methodMap = new HashMap<String, Method>();
        for (Method method : PipeBuilder.class.getDeclaredMethods()) {
            PipeExecutor executor = method.getAnnotation(PipeExecutor.class);
            if (executor == null) continue;
            this.methodMap.put(executor.command(), method);
            this.executorMap.put(executor.command(), executor);
        }
    }

    protected Map<String, Method> getMethodMap() {
        if (this.methodMap == null) {
            this.computeMaps();
        }
        return this.methodMap;
    }

    protected Map<String, PipeExecutor> getExecutorMap() {
        if (this.executorMap == null) {
            this.computeMaps();
        }
        return this.executorMap;
    }

    protected boolean isExpressionExpected(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class);
    }

    protected boolean isConfExpected(Method method) {
        return method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object[].class);
    }

    protected boolean isWithoutExpectedParameter(Method method) {
        return method.getParameterCount() == 0;
    }

    private String[] keyValuesToArray(List<String> o) {
        ArrayList<String> args = new ArrayList<String>();
        for (String pair : o) {
            args.addAll(Arrays.asList(pair.split(KEY_VALUE_SEP)));
        }
        return args.toArray(new String[args.size()]);
    }

    protected List<Token> parseTokens(String ... commands) {
        ArrayList<Token> returnValue = new ArrayList<Token>();
        Token currentToken = new Token();
        returnValue.add(currentToken);
        ArrayList<String> currentList = new ArrayList<String>();
        block8: for (String token : commands) {
            if (currentToken.pipeKey == null) {
                currentToken.pipeKey = token;
                continue;
            }
            switch (token) {
                case "/": {
                    this.finishToken(currentToken, currentList);
                    currentList = new ArrayList();
                    currentToken = new Token();
                    returnValue.add(currentToken);
                    continue block8;
                }
                case "@": {
                    if (currentToken.args == null) {
                        currentToken.args = currentList;
                        currentList = new ArrayList();
                    }
                    currentList.add(PARAMS);
                    continue block8;
                }
                default: {
                    currentList.add(token);
                }
            }
        }
        this.finishToken(currentToken, currentList);
        return returnValue;
    }

    protected void finishToken(Token currentToken, List<String> currentList) {
        if (currentToken.args != null) {
            currentToken.options = this.getOptions(currentList);
        } else {
            currentToken.args = currentList;
        }
        this.log.debug("current token : {}", (Object)currentToken);
    }

    protected Options getOptions(String[] tokens) {
        return this.getOptions(Arrays.asList(tokens));
    }

    protected Options getOptions(List<String> tokens) {
        return new Options(tokens);
    }

    protected class Options {
        String name;
        String path;
        String expr;
        String[] with;
        OutputWriter writer;

        public String toString() {
            return "Options{name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", expr='" + this.expr + '\'' + ", with=" + Arrays.toString(this.with) + ", writer=" + this.writer + '}';
        }

        protected Options(List<String> options) {
            HashMap<String, Object> optionMap = new HashMap<String, Object>();
            String currentKey = null;
            ArrayList<String> currentList = null;
            for (String string : options) {
                if (GogoCommands.PARAMS.equals(string)) {
                    this.finishOption(currentKey, currentList, optionMap);
                    currentList = new ArrayList<String>();
                    currentKey = null;
                    continue;
                }
                if (currentKey == null) {
                    currentKey = string;
                    continue;
                }
                currentList.add(string);
            }
            this.finishOption(currentKey, currentList, optionMap);
            block15: for (Map.Entry entry : optionMap.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "name": {
                        this.name = (String)entry.getValue();
                        continue block15;
                    }
                    case "path": {
                        this.path = (String)entry.getValue();
                        continue block15;
                    }
                    case "expr": {
                        this.expr = (String)entry.getValue();
                        continue block15;
                    }
                    case "with": {
                        this.with = GogoCommands.this.keyValuesToArray((List)entry.getValue());
                        continue block15;
                    }
                    case "outputs": {
                        this.writer = new JsonWriter();
                        Object[] list = GogoCommands.this.keyValuesToArray((List)entry.getValue());
                        HashMap<String, Object> outputs = new HashMap<String, Object>();
                        CommandUtil.writeToMap(outputs, list);
                        this.writer.setCustomOutputs(outputs);
                        continue block15;
                    }
                }
                throw new IllegalArgumentException(String.format("%s is an unknown option", entry.getKey()));
            }
        }

        protected void finishOption(String currentKey, List<String> currentList, Map<String, Object> optionMap) {
            if (currentList != null) {
                if (currentKey.equals(GogoCommands.KEY_NAME) || currentKey.equals(GogoCommands.KEY_EXPR) || currentKey.equals(GogoCommands.KEY_PATH)) {
                    optionMap.put(currentKey, currentList.get(0));
                } else {
                    optionMap.put(currentKey, currentList);
                }
            }
        }

        void writeToBuilder(PipeBuilder builder) throws IllegalAccessException {
            if (StringUtils.isNotBlank((CharSequence)this.name)) {
                builder.name(this.name);
            }
            if (StringUtils.isNotBlank((CharSequence)this.path)) {
                builder.path(this.path);
            }
            if (StringUtils.isNotBlank((CharSequence)this.expr)) {
                builder.expr(this.expr);
            }
            if (this.with != null) {
                builder.with(this.with);
            }
        }
    }

    protected class Token {
        String pipeKey;
        List args;
        Options options;

        protected Token() {
        }

        public String toString() {
            return "Token{pipeKey='" + this.pipeKey + '\'' + ", args=" + this.args + ", options=" + this.options + '}';
        }
    }
}

