/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.pipes.Pipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeBindings {
    private static final Logger log = LoggerFactory.getLogger(PipeBindings.class);
    public static final String NASHORNSCRIPTENGINE = "nashorn";
    public static final String NN_ADDITIONALBINDINGS = "additionalBindings";
    public static final String PN_ADDITIONALSCRIPTS = "additionalScripts";
    public static final String NN_PROVIDERS = "providers";
    public static final String PATH_BINDING = "path";
    public static final String NAME_BINDING = "name";
    private static final String INJECTED_SCRIPT_REGEXP = "\\$\\{(([^\\{^\\}]*(\\{[0-9,]+\\})?)*)\\}";
    private static final Pattern INJECTED_SCRIPT = Pattern.compile("\\$\\{(([^\\{^\\}]*(\\{[0-9,]+\\})?)*)\\}");
    protected static final String IF_PREFIX = "$if";
    protected static final Pattern CONDITIONAL_STRING = Pattern.compile("^\\$if\\$\\{(([^\\{^\\}]*(\\{[0-9,]+\\})?)*)\\}");
    ScriptEngine engine;
    ScriptContext scriptContext = new SimpleScriptContext();
    Map<String, String> pathBindings = new HashMap<String, String>();
    Map<String, String> nameBindings = new HashMap<String, String>();
    Map<String, Resource> outputResources = new HashMap<String, Resource>();
    String currentError;

    public PipeBindings(Resource resource) throws ScriptException {
        this.initializeScriptEngine();
        this.getBindings().put(PATH_BINDING, (Object)this.pathBindings);
        this.getBindings().put(NAME_BINDING, (Object)this.nameBindings);
    }

    public void addBinding(String name, Object value) {
        log.debug("Adding binding {}={}", (Object)name, value);
        this.getBindings().put(name, value);
    }

    public void addBindings(Map bindings) {
        log.info("Adding bindings {}", (Object)bindings);
        this.getBindings().putAll(bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScript(ResourceResolver resolver, String path) {
        InputStream is = null;
        try {
            Resource scriptResource;
            if (path.startsWith("http")) {
                try {
                    URL remoteScript = new URL(path);
                    is = remoteScript.openStream();
                }
                catch (Exception e) {
                    log.error("unable to retrieve remote script", (Throwable)e);
                }
            } else if (path.startsWith("/") && (scriptResource = resolver.getResource(path)) != null) {
                is = (InputStream)scriptResource.adaptTo(InputStream.class);
            }
            if (is != null) {
                try {
                    this.engine.eval((Reader)new InputStreamReader(is), this.scriptContext);
                }
                catch (Exception e) {
                    log.error("Add script: unable to evaluate script {}", (Object)path, (Object)e);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public boolean isPlainString(String expr) {
        return this.computeECMA5Expression(expr) == null;
    }

    protected String computeECMA5Expression(String expr) {
        Matcher matcher = INJECTED_SCRIPT.matcher(expr);
        if (INJECTED_SCRIPT.matcher(expr).find()) {
            StringBuilder expression = new StringBuilder();
            int start = 0;
            while (matcher.find()) {
                if (matcher.start() > start) {
                    if (expression.length() == 0) {
                        expression.append("'");
                    }
                    expression.append(expr.substring(start, matcher.start()));
                }
                if (expression.length() > 0) {
                    expression.append("' + ");
                }
                expression.append(matcher.group(1));
                start = matcher.end();
                if (start >= expr.length()) continue;
                expression.append(" + '");
            }
            if (start < expr.length()) {
                expression.append(expr.substring(start) + "'");
            }
            return expression.toString();
        }
        return null;
    }

    public void copyBindings(PipeBindings original) {
        this.getBindings().putAll(original.getBindings());
    }

    protected Object evaluate(String expr) throws ScriptException {
        String computed = this.computeECMA5Expression(expr);
        if (computed != null) {
            return this.engine.eval(computed, this.scriptContext);
        }
        return expr;
    }

    public Bindings getBindings() {
        return this.scriptContext.getBindings(100);
    }

    public Resource getExecutedResource(String name) {
        return this.outputResources.get(name);
    }

    private void initializeScriptEngine() throws ScriptException {
        this.engine = new ScriptEngineManager().getEngineByName(NASHORNSCRIPTENGINE);
        if (this.engine == null) {
            this.engine = new ScriptEngineManager(null).getEngineByName(NASHORNSCRIPTENGINE);
            if (this.engine == null) {
                throw new ScriptException("Can not instantiate nashorn scriptengine. Check JVM version & capabilities.");
            }
        }
        this.engine.setContext(this.scriptContext);
    }

    public String conditionalString(String conditionalExpression) throws ScriptException {
        Matcher matcher = CONDITIONAL_STRING.matcher(conditionalExpression);
        if (matcher.find()) {
            String s;
            Object output = this.evaluate(StringUtils.substringAfter((String)matcher.group(0), (String)IF_PREFIX));
            if (output != null && StringUtils.isNotEmpty((CharSequence)(s = output.toString().toLowerCase().trim())) && !"false".equals(s) && !"undefined".equals(s)) {
                return this.instantiateExpression(conditionalExpression.substring(matcher.group(0).length()));
            }
        } else {
            return this.instantiateExpression(conditionalExpression);
        }
        return null;
    }

    public String instantiateExpression(String expr) throws ScriptException {
        return (String)this.evaluate(expr);
    }

    public Object instantiateObject(String expr) throws ScriptException {
        JsDate jsDate;
        Object result = this.evaluate(expr);
        if (result != null && !result.getClass().getName().startsWith("java.lang.") && (jsDate = ((Invocable)((Object)this.engine)).getInterface(result, JsDate.class)) != null) {
            Date date = new Date(jsDate.getTime() + (long)(jsDate.getTimezoneOffset() * 60 * 1000));
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        return result;
    }

    public boolean isBindingDefined(String name) {
        return this.getBindings().containsKey(name);
    }

    public void updateBindings(Pipe pipe, Resource resource) {
        this.outputResources.put(pipe.getName(), resource);
        this.updateStaticBindings(pipe.getName(), resource);
        this.addBinding(pipe.getName(), pipe.getOutputBinding());
    }

    public void updateStaticBindings(String name, Resource resource) {
        if (resource != null) {
            this.pathBindings.put(name, resource.getPath());
            this.nameBindings.put(name, resource.getName());
        }
    }

    public String popCurrentError() {
        String returnValue = this.currentError;
        this.currentError = null;
        return returnValue;
    }

    public void setCurrentError(String currentError) {
        this.currentError = currentError;
    }

    public static interface JsDate {
        public long getTime();

        public int getTimezoneOffset();
    }
}

