/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritePipe
extends BasePipe {
    private static final Logger logger = LoggerFactory.getLogger(WritePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/write";
    Node confTree;
    private List<Resource> propertiesToRemove;
    Pattern addPatch = Pattern.compile("\\+\\[(.*)\\]");
    Pattern multi = Pattern.compile("\\[(.*)\\]");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WritePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
        if (this.getConfiguration() == null) {
            String pathCandidate = this.getExpr();
            if (!StringUtils.isNotBlank((CharSequence)pathCandidate) || this.resolver.getResource(pathCandidate) == null) throw new Exception("write pipe is misconfigured: it should have a configuration node, or an expression");
            this.confTree = (Node)this.resolver.getResource(pathCandidate).adaptTo(Node.class);
            return;
        } else {
            this.confTree = (Node)this.getConfiguration().adaptTo(Node.class);
        }
    }

    protected Object computeValue(Resource resource, String key, String expression) throws ScriptException {
        Object value = this.bindings.instantiateObject(expression);
        if (value != null && value instanceof String) {
            String sValue = (String)value;
            Matcher patch = this.addPatch.matcher(sValue);
            if (patch.matches()) {
                AbstractList newValues;
                String newValue = patch.group(1);
                String[] actualValues = (String[])((ValueMap)resource.adaptTo(ValueMap.class)).get(key, String[].class);
                AbstractList abstractList = newValues = actualValues != null ? new LinkedList<String>(Arrays.asList(actualValues)) : new ArrayList();
                if (!newValues.contains(newValue)) {
                    newValues.add(newValue);
                }
                return newValues.toArray(new String[newValues.size()]);
            }
            Matcher multiMatcher = this.multi.matcher(sValue);
            if (multiMatcher.matches()) {
                return multiMatcher.group(1).split(",");
            }
        }
        return value;
    }

    protected Object computeValue(Resource resource, String key, Object expression) throws ScriptException {
        if (expression instanceof String) {
            return this.computeValue(resource, key, (String)expression);
        }
        if (expression instanceof String[]) {
            ArrayList<String> values = new ArrayList<String>();
            for (String expr : (String[])expression) {
                values.add((String)this.computeValue(resource, key, expr));
            }
            return values.toArray(new String[values.size()]);
        }
        return expression;
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    private void copyProperties(Resource conf, Resource target) throws ScriptException {
        ValueMap writeMap = (ValueMap)conf.adaptTo(ValueMap.class);
        ModifiableValueMap properties = (ModifiableValueMap)target.adaptTo(ModifiableValueMap.class);
        if (properties != null && writeMap != null) {
            for (Map.Entry entry : writeMap.entrySet()) {
                if (IGNORED_PROPERTIES.contains(entry.getKey())) continue;
                String key = this.parent != null ? this.bindings.instantiateExpression((String)entry.getKey()) : (String)entry.getKey();
                Object value = this.computeValue(target, key, entry.getValue());
                if (value == null) {
                    this.addPropertyToRemove(target.getChild(key));
                    continue;
                }
                logger.info("writing {}={}", (Object)(target.getPath() + "@" + key), value);
                if (this.isDryRun()) continue;
                properties.put((Object)key, value);
            }
        }
    }

    private void addPropertyToRemove(Resource property) {
        if (property != null) {
            if (this.propertiesToRemove == null) {
                this.propertiesToRemove = new ArrayList<Resource>();
            }
            this.propertiesToRemove.add(property);
        }
    }

    private void writeTree(Node conf, Resource target) throws RepositoryException, ScriptException {
        this.copyProperties(this.resolver.getResource(conf.getPath()), target);
        NodeIterator childrenConf = conf.getNodes();
        if (childrenConf.hasNext()) {
            Node targetNode = (Node)target.adaptTo(Node.class);
            logger.info("dubbing {} at {}", (Object)conf.getPath(), (Object)target.getPath());
            while (childrenConf.hasNext()) {
                Node childConf = childrenConf.nextNode();
                String name = childConf.getName();
                name = this.bindings.instantiateExpression(name);
                if (this.isDryRun()) continue;
                Node childTarget = targetNode.hasNode(name) ? targetNode.getNode(name) : targetNode.addNode(name, childConf.getPrimaryNodeType().getName());
                logger.debug("writing tree {}", (Object)childTarget.getPath());
                this.writeTree(childConf, this.resolver.getResource(childTarget.getPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterator<Resource> computeOutput() throws Exception {
        try {
            Resource resource = this.getInput();
            if (resource != null) {
                this.writeTree(this.confTree, resource);
                if (this.propertiesToRemove != null && !this.propertiesToRemove.isEmpty()) {
                    for (Resource propertyResource : this.propertiesToRemove) {
                        Property property;
                        logger.info("removing {}", (Object)propertyResource.getPath());
                        if (this.isDryRun() || (property = (Property)propertyResource.adaptTo(Property.class)) == null) continue;
                        property.remove();
                    }
                }
                Iterator<Resource> iterator = super.computeOutput();
                return iterator;
            }
        }
        finally {
            if (this.propertiesToRemove != null) {
                this.propertiesToRemove.clear();
            }
        }
        return EMPTY_ITERATOR;
    }
}

