/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraversePipe
extends BasePipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraversePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/traverse";

    public TraversePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) throws Exception {
        super(plumber, resource, upperBindings);
    }

    @Override
    protected Iterator<Resource> computeOutput() throws Exception {
        return new TraversingIterator(this.getInput(), this.getResource().getValueMap());
    }

    public class TraversingIterator
    implements Iterator<Resource> {
        protected static final String PN_PROPERTIES = "properties";
        protected static final String PN_NAMEGLOBS = "nameGlobs";
        protected static final String PN_BREADTH = "breadthFirst";
        protected static final String PN_DEPTH = "depth";
        boolean properties;
        int initialLevel;
        int maxLevel;
        String[] nameGlobs;
        boolean breadthFirst;
        Iterator<Resource> currentResources;
        List<Node> nodesToVisit = new ArrayList<Node>();

        void refreshResourceIterator(Node node) throws RepositoryException {
            if (this.properties) {
                PropertyIterator it = this.nameGlobs != null ? node.getProperties(this.nameGlobs) : node.getProperties();
                this.currentResources = IteratorUtils.transformedIterator((Iterator)it, o -> {
                    try {
                        return TraversePipe.this.resolver.getResource(((Property)o).getPath());
                    }
                    catch (RepositoryException e) {
                        LOGGER.error("unable to read property", (Throwable)e);
                        return null;
                    }
                });
            } else {
                this.currentResources = IteratorUtils.singletonIterator((Object)TraversePipe.this.resolver.getResource(node.getPath()));
            }
        }

        int getDepth(String path) {
            return path.split("/").length;
        }

        boolean isBeforeLastLevel(Node node) throws RepositoryException {
            return this.maxLevel < 0 || this.getDepth(node.getPath()) < this.maxLevel;
        }

        TraversingIterator(Resource root, ValueMap configuration) {
            this.properties = (Boolean)configuration.get(PN_PROPERTIES, (Object)false);
            if (this.properties) {
                this.nameGlobs = (String[])configuration.get(PN_NAMEGLOBS, String[].class);
            }
            this.breadthFirst = (Boolean)configuration.get(PN_BREADTH, (Object)false);
            this.maxLevel = (Integer)configuration.get(PN_DEPTH, (Object)-1);
            if (this.maxLevel > 0) {
                this.initialLevel = this.getDepth(root.getPath());
                this.maxLevel = this.initialLevel + this.maxLevel;
            }
            this.nodesToVisit.add((Node)root.adaptTo(Node.class));
        }

        boolean goToNextElligibleNode() {
            try {
                while (!(this.currentResources != null && this.currentResources.hasNext() || this.nodesToVisit.size() <= 0)) {
                    int indexAdd;
                    Node node = this.nodesToVisit.remove(0);
                    LOGGER.debug("visiting {}", (Object)node.getPath());
                    this.refreshResourceIterator(node);
                    int n = indexAdd = this.breadthFirst ? this.nodesToVisit.size() : 0;
                    if (!this.isBeforeLastLevel(node)) continue;
                    this.nodesToVisit.addAll(indexAdd, IteratorUtils.toList((Iterator)node.getNodes()));
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("unable to read node subpipes", (Throwable)e);
            }
            return this.currentResources != null && this.currentResources.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.currentResources != null && this.currentResources.hasNext() || this.goToNextElligibleNode();
        }

        @Override
        public Resource next() {
            return this.currentResources.next();
        }
    }
}

