/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.CommandUtil;
import org.apache.sling.pipes.internal.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeBuilderImpl
implements PipeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PipeBuilderImpl.class);
    public static final String PIPES_REPOSITORY_PATH = "/var/pipes";
    public static final String[] DEFAULT_NAMES = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
    List<Step> steps;
    Map outputs;
    Step containerStep;
    Step currentStep;
    Plumber plumber;
    ResourceResolver resolver;

    protected PipeBuilderImpl(ResourceResolver resolver, Plumber plumber) {
        this.currentStep = this.containerStep = new Step("slingPipes/container");
        this.plumber = plumber;
        this.resolver = resolver;
    }

    @Override
    public PipeBuilder pipe(String type) {
        if (!this.plumber.isTypeRegistered(type)) {
            throw new IllegalArgumentException(type + " is not a registered pipe type");
        }
        if (this.steps == null) {
            this.steps = new ArrayList<Step>();
        }
        this.currentStep = new Step(type);
        this.steps.add(this.currentStep);
        return this;
    }

    protected PipeBuilder pipeWithExpr(String type, String expr) {
        try {
            this.pipe(type).expr(expr);
        }
        catch (IllegalAccessException e) {
            logger.error("exception while configuring {}", (Object)type, (Object)e);
        }
        return this;
    }

    @Override
    public PipeBuilder mv(String expr) {
        return this.pipeWithExpr("slingPipes/mv", expr);
    }

    @Override
    public PipeBuilder write(Object ... conf) throws IllegalAccessException {
        return this.pipe("slingPipes/write").conf(conf);
    }

    @Override
    public PipeBuilder grep(Object ... conf) throws IllegalAccessException {
        return this.pipe("slingPipes/filter").conf(conf);
    }

    @Override
    public PipeBuilder auth(Object ... conf) throws IllegalAccessException {
        return this.pipe("slingPipes/authorizable").conf(conf);
    }

    @Override
    public PipeBuilder xpath(String expr) {
        return this.pipeWithExpr("slingPipes/xpath", expr);
    }

    @Override
    public PipeBuilder children(String expr) {
        return this.pipeWithExpr("slingPipes/children", expr);
    }

    @Override
    public PipeBuilder rm() {
        return this.pipe("slingPipes/rm");
    }

    @Override
    public PipeBuilder traverse() {
        return this.pipe("slingPipes/traverse");
    }

    @Override
    public PipeBuilder csv(String expr) {
        return this.pipeWithExpr("slingPipes/csv", expr);
    }

    @Override
    public PipeBuilder json(String expr) {
        return this.pipeWithExpr("slingPipes/json", expr);
    }

    @Override
    public PipeBuilder egrep(String expr) {
        return this.pipeWithExpr("slingPipes/egrep", expr);
    }

    @Override
    public PipeBuilder mkdir(String expr) {
        return this.pipeWithExpr("slingPipes/path", expr);
    }

    @Override
    public PipeBuilder echo(String path) {
        try {
            this.pipe("slingPipes/base").path(path);
        }
        catch (IllegalAccessException e) {
            logger.error("error when calling echo {}", (Object)path, (Object)e);
        }
        return this;
    }

    @Override
    public PipeBuilder parent() {
        return this.pipe("slingPipes/parent");
    }

    @Override
    public PipeBuilder parents(String expr) {
        return this.pipeWithExpr("slingPipes/parents", expr);
    }

    @Override
    public PipeBuilder siblings(String expr) {
        return this.pipeWithExpr("slingPipes/siblings", expr);
    }

    @Override
    public PipeBuilder closest(String expr) {
        return this.pipeWithExpr("slingPipes/closest", expr);
    }

    @Override
    public PipeBuilder $(String expr) {
        return this.pipeWithExpr("slingPipes/find", expr);
    }

    @Override
    public PipeBuilder ref(String expr) {
        return this.pipeWithExpr("slingPipes/reference", expr);
    }

    @Override
    public PipeBuilder mp() {
        return this.pipe("slingPipes/multiProperty");
    }

    @Override
    public PipeBuilder pkg(String expr) {
        try {
            this.pipeWithExpr("slingPipes/package", expr).with("filterCollectionMode", true);
        }
        catch (IllegalAccessException e) {
            logger.error("error when calling pkg", (Throwable)e);
        }
        return this;
    }

    @Override
    public PipeBuilder not(String expr) {
        return this.pipeWithExpr("slingPipes/not", expr);
    }

    @Override
    public PipeBuilder with(Object ... params) throws IllegalAccessException {
        return this.writeToCurrentStep(null, params);
    }

    @Override
    public PipeBuilder conf(Object ... properties) throws IllegalAccessException {
        return this.writeToCurrentStep("conf", properties);
    }

    @Override
    public PipeBuilder acls() throws IllegalAccessException {
        return this.pipe("slingPipes/acl");
    }

    @Override
    public PipeBuilder allow(String expr) throws IllegalAccessException {
        return this.pipeWithExpr("slingPipes/acl", expr).with("allow", "true");
    }

    @Override
    public PipeBuilder deny(String expr) throws IllegalAccessException {
        return this.pipeWithExpr("slingPipes/acl", expr).with("deny", "true");
    }

    protected PipeBuilder writeToCurrentStep(String name, Object ... params) throws IllegalAccessException {
        HashMap props;
        CommandUtil.checkArguments(params);
        Map map = props = name != null ? this.currentStep.confs.get(name) : this.currentStep.properties;
        if (props == null) {
            props = new HashMap();
            if (name != null) {
                this.currentStep.confs.put(name, props);
            }
        }
        CommandUtil.writeToMap(props, params);
        return this;
    }

    @Override
    public PipeBuilder expr(String value) throws IllegalAccessException {
        return this.with("expr", value);
    }

    @Override
    public PipeBuilder path(String value) throws IllegalAccessException {
        return this.with("path", value);
    }

    @Override
    public PipeBuilder name(String name) throws IllegalAccessException {
        this.currentStep.name = name;
        return this;
    }

    protected String buildRandomPipePath() {
        Calendar now = Calendar.getInstance();
        return "/var/pipes/" + now.get(1) + '/' + now.get(2) + '/' + now.get(5) + "/" + UUID.randomUUID().toString();
    }

    protected Resource createResource(ResourceResolver resolver, String path, String type, Map data) throws PersistenceException {
        return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, (Map)data, (String)type, (boolean)false);
    }

    @Override
    public PipeBuilder outputs(String ... keys) {
        this.outputs = new HashMap();
        CommandUtil.writeToMap(this.outputs, keys);
        return this;
    }

    @Override
    public Pipe build() throws PersistenceException {
        return this.build(this.buildRandomPipePath());
    }

    protected Resource persistStep(String path, String parentType, Step step) throws PersistenceException {
        Resource resource = this.createResource(this.resolver, path, parentType, step.properties);
        for (Map.Entry<String, Map> entry : step.confs.entrySet()) {
            this.createResource(this.resolver, path + "/" + entry.getKey(), "sling:Folder", entry.getValue());
            logger.debug("built pipe {}'s {} node", (Object)path, (Object)entry.getKey());
        }
        return resource;
    }

    @Override
    public Pipe build(String path) throws PersistenceException {
        Resource pipeResource = this.persistStep(path, "sling:Folder", this.containerStep);
        if (this.outputs != null) {
            ResourceUtil.getOrCreateResource((ResourceResolver)this.resolver, (String)(path + "/" + "writer"), (Map)this.outputs, (String)"sling:Folder", (boolean)false);
        }
        int index = 0;
        for (Step step : this.steps) {
            String name = StringUtils.isNotBlank((CharSequence)step.name) ? step.name : (DEFAULT_NAMES.length > index ? DEFAULT_NAMES[index] : Integer.toString(index));
            ++index;
            this.persistStep(path + "/" + "conf" + "/" + name, "sling:OrderedFolder", step);
        }
        this.resolver.commit();
        logger.debug("built pipe under {}", (Object)path);
        return this.plumber.getPipe(pipeResource);
    }

    @Override
    public ExecutionResult run() throws Exception {
        return this.run(null);
    }

    @Override
    public ExecutionResult runWith(Object ... bindings) throws Exception {
        CommandUtil.checkArguments(bindings);
        HashMap bindingsMap = new HashMap();
        CommandUtil.writeToMap(bindingsMap, bindings);
        return this.run(bindingsMap);
    }

    @Override
    public ExecutionResult run(Map bindings) throws Exception {
        JsonWriter writer = new JsonWriter();
        writer.starts();
        Pipe pipe = this.build();
        return this.plumber.execute(this.resolver, pipe, bindings, (OutputWriter)writer, true);
    }

    @Override
    public Job runAsync(Map bindings) throws PersistenceException {
        Pipe pipe = this.build();
        return this.plumber.executeAsync(this.resolver, pipe.getResource().getPath(), bindings);
    }

    @Override
    public ExecutionResult runParallel(final int numThreads, Map additionalBindings) throws Exception {
        this.containerStep.setType("slingPipes/manifold");
        HashMap bindings = new HashMap(){
            {
                this.put("numThreads", numThreads);
            }
        };
        if (additionalBindings != null) {
            bindings.putAll(additionalBindings);
        }
        return this.run(bindings);
    }

    public class Step {
        String name;
        Map properties;
        Map<String, Map> confs = new HashMap<String, Map>();

        Step(String type) {
            this.properties = new HashMap();
            this.setType(type);
        }

        void setType(String type) {
            this.properties.put("sling:resourceType", type);
        }
    }
}

