/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeExecutor;
import org.apache.sling.pipes.internal.ACLPipe;
import org.apache.sling.pipes.internal.AuthorizablePipe;
import org.apache.sling.pipes.internal.FilterPipe;
import org.apache.sling.pipes.internal.MovePipe;
import org.apache.sling.pipes.internal.MultiPropertyPipe;
import org.apache.sling.pipes.internal.NotPipe;
import org.apache.sling.pipes.internal.PackagePipe;
import org.apache.sling.pipes.internal.PathPipe;
import org.apache.sling.pipes.internal.ReferencePipe;
import org.apache.sling.pipes.internal.RemovePipe;
import org.apache.sling.pipes.internal.TraversePipe;
import org.apache.sling.pipes.internal.WritePipe;
import org.apache.sling.pipes.internal.XPathPipe;
import org.apache.sling.pipes.internal.inputstream.CsvPipe;
import org.apache.sling.pipes.internal.inputstream.JsonPipe;
import org.apache.sling.pipes.internal.inputstream.RegexpPipe;
import org.apache.sling.pipes.internal.slingquery.ChildrenPipe;
import org.apache.sling.pipes.internal.slingquery.ClosestPipe;
import org.apache.sling.pipes.internal.slingquery.FindPipe;
import org.apache.sling.pipes.internal.slingquery.ParentPipe;
import org.apache.sling.pipes.internal.slingquery.ParentsPipe;
import org.apache.sling.pipes.internal.slingquery.SiblingsPipe;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface PipeBuilder {
    public PipeBuilder pipe(String var1);

    @PipeExecutor(command="mv", resourceType="slingPipes/mv", pipeClass=MovePipe.class, description="move current resource to expr (more on https://sling.apache.org/documentation/bundles/sling-pipes/writers.html)")
    public PipeBuilder mv(String var1);

    @PipeExecutor(command="write", resourceType="slingPipes/write", pipeClass=WritePipe.class, description="write following key=value pairs to the current resource")
    public PipeBuilder write(Object ... var1) throws IllegalAccessException;

    @PipeExecutor(command="grep", resourceType="slingPipes/filter", pipeClass=FilterPipe.class, description="filter current resources with following key=value pairs")
    public PipeBuilder grep(Object ... var1) throws IllegalAccessException;

    @PipeExecutor(command="auth", resourceType="slingPipes/authorizable", pipeClass=AuthorizablePipe.class, description="convert current resource as authorizable")
    public PipeBuilder auth(Object ... var1) throws IllegalAccessException;

    @PipeExecutor(command="xpath", resourceType="slingPipes/xpath", pipeClass=XPathPipe.class, description="create following xpath query's result as output resources")
    public PipeBuilder xpath(String var1);

    @PipeExecutor(command="children", resourceType="slingPipes/children", pipeClass=ChildrenPipe.class, description="list current resource's immediate children")
    public PipeBuilder children(String var1);

    @PipeExecutor(command="siblings", resourceType="slingPipes/siblings", pipeClass=SiblingsPipe.class, description="list current resource's siblings")
    public PipeBuilder siblings(String var1);

    @PipeExecutor(command="rm", resourceType="slingPipes/rm", pipeClass=RemovePipe.class, description="remove current resource")
    public PipeBuilder rm();

    @PipeExecutor(command="csv", resourceType="slingPipes/csv", pipeClass=CsvPipe.class, description="read expr's csv and output each line in the bindings")
    public PipeBuilder csv(String var1);

    @PipeExecutor(command="json", resourceType="slingPipes/json", pipeClass=JsonPipe.class, description="read expr's json array and output each object in the bindings")
    public PipeBuilder json(String var1);

    @PipeExecutor(command="egrep", resourceType="slingPipes/egrep", pipeClass=RegexpPipe.class, description="read expr's txt and output each found pattern in the binding")
    public PipeBuilder egrep(String var1);

    @PipeExecutor(command="mkdir", resourceType="slingPipes/path", pipeClass=PathPipe.class, description="create expr path")
    public PipeBuilder mkdir(String var1);

    @PipeExecutor(command="echo", resourceType="slingPipes/base", pipeClass=BasePipe.class, description="output input's path")
    public PipeBuilder echo(String var1);

    @PipeExecutor(command="traverse", resourceType="slingPipes/traverse", pipeClass=TraversePipe.class, description="traverse current resource")
    public PipeBuilder traverse();

    @PipeExecutor(command="parent", resourceType="slingPipes/parent", pipeClass=ParentPipe.class, description="return current's resource parent")
    public PipeBuilder parent();

    @PipeExecutor(command="parents", resourceType="slingPipes/parents", pipeClass=ParentsPipe.class, description="return current's resource parents")
    public PipeBuilder parents(String var1);

    @PipeExecutor(command="closest", resourceType="slingPipes/closest", pipeClass=ClosestPipe.class, description="return closest resource of the current")
    public PipeBuilder closest(String var1);

    @PipeExecutor(command="$", resourceType="slingPipes/find", pipeClass=FindPipe.class, description="find resource from the current, with the given expression as a parameter")
    public PipeBuilder $(String var1);

    @PipeExecutor(command="ref", resourceType="slingPipes/reference", pipeClass=ReferencePipe.class, description="reference passed pipe")
    public PipeBuilder ref(String var1);

    @PipeExecutor(command="pkg", resourceType="slingPipes/package", pipeClass=PackagePipe.class, description="package up current resource in given package")
    public PipeBuilder pkg(String var1);

    @PipeExecutor(command="not", resourceType="slingPipes/not", pipeClass=NotPipe.class, description="invert output: if input, return nothing, if no input, return single resource")
    public PipeBuilder not(String var1);

    @PipeExecutor(command="mp", resourceType="slingPipes/multiProperty", pipeClass=MultiPropertyPipe.class, description="read multi property, and output each value in the bindings")
    public PipeBuilder mp();

    @PipeExecutor(command="acls", resourceType="slingPipes/acl", pipeClass=ACLPipe.class, description="output each acls on the resource or  acls for authorizable in repository in bindings")
    public PipeBuilder acls() throws IllegalAccessException;

    @PipeExecutor(command="allow", resourceType="slingPipes/acl", pipeClass=ACLPipe.class, description="sets allow acls on the resource")
    public PipeBuilder allow(String var1) throws IllegalAccessException;

    @PipeExecutor(command="deny", resourceType="slingPipes/acl", pipeClass=ACLPipe.class, description="sets deny acls on the resource")
    public PipeBuilder deny(String var1) throws IllegalAccessException;

    public PipeBuilder with(Object ... var1) throws IllegalAccessException;

    public PipeBuilder expr(String var1) throws IllegalAccessException;

    public PipeBuilder name(String var1) throws IllegalAccessException;

    public PipeBuilder path(String var1) throws IllegalAccessException;

    public PipeBuilder conf(Object ... var1) throws IllegalAccessException;

    public PipeBuilder outputs(String ... var1);

    public Pipe build() throws PersistenceException;

    public Pipe build(String var1) throws PersistenceException;

    public ExecutionResult run() throws Exception;

    public ExecutionResult run(Map var1) throws Exception;

    public ExecutionResult runWith(Object ... var1) throws Exception;

    public Job runAsync(Map var1) throws PersistenceException;

    public ExecutionResult runParallel(int var1, Map var2) throws Exception;
}

