/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonValue;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.AbstractInputStreamPipe;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.CsvWriter;
import org.apache.sling.pipes.internal.JsonUtil;
import org.apache.sling.pipes.internal.JsonWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=slingPipes/plumber", "sling.servlet.resourceTypes=slingPipes/container", "sling.servlet.resourceTypes=slingPipes/authorizable", "sling.servlet.resourceTypes=slingPipes/write", "sling.servlet.resourceTypes=slingPipes/children", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.extensions=json", "sling.servlet.extensions=csv"})
public class PlumberServlet
extends SlingAllMethodsServlet {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String PARAM_PATH = "path";
    protected static final String PARAM_BINDINGS = "bindings";
    protected static final String PARAM_ASYNC = "async";
    protected static final String PARAM_FILE = "pipes_inputFile";
    @Reference
    Plumber plumber;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (Arrays.asList(request.getRequestPathInfo().getSelectors()).contains("status")) {
            response.getWriter().append(this.plumber.getStatus(request.getResource()));
        } else {
            this.execute(request, response, false);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.execute(request, response, true);
    }

    protected void execute(SlingHttpServletRequest request, SlingHttpServletResponse response, boolean writeAllowed) throws ServletException {
        String path = request.getResource().getResourceType().equals("slingPipes/plumber") ? request.getParameter(PARAM_PATH) : request.getResource().getPath();
        try {
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new Exception("path should be provided");
            }
            Map bindings = this.getBindingsFromRequest(request, writeAllowed);
            String asyncParam = request.getParameter(PARAM_ASYNC);
            if (StringUtils.isNotBlank((CharSequence)asyncParam) && asyncParam.equals(Boolean.TRUE.toString())) {
                Job job = this.plumber.executeAsync(request.getResourceResolver(), path, bindings);
                if (job != null) {
                    response.getWriter().append("pipe execution registered as " + job.getId());
                    response.setStatus(201);
                } else {
                    response.sendError(500, "Some issue with your request, or server not being ready for async execution");
                }
            } else {
                OutputWriter writer = this.getWriter(request, response);
                this.plumber.execute(request.getResourceResolver(), path, bindings, writer, true);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected Map getBindingsFromRequest(SlingHttpServletRequest request, boolean writeAllowed) throws IOException {
        String paramBindings;
        HashMap<Object, Object> bindings = new HashMap<Object, Object>();
        String dryRun = request.getParameter("dryRun");
        if (StringUtils.isNotBlank((CharSequence)dryRun) && !dryRun.equals(Boolean.FALSE.toString())) {
            bindings.put("dryRun", true);
        }
        if (StringUtils.isNotBlank((CharSequence)(paramBindings = request.getParameter(PARAM_BINDINGS)))) {
            try {
                bindings.putAll((Map)JsonUtil.unbox((JsonValue)JsonUtil.parseObject(paramBindings)));
            }
            catch (Exception e) {
                this.log.error("Unable to retrieve bindings information", (Throwable)e);
            }
        }
        if (request.getRequestParameterMap() != null && request.getRequestParameterMap().containsKey((Object)PARAM_FILE)) {
            bindings.put(AbstractInputStreamPipe.BINDING_IS, request.getRequestParameter(PARAM_FILE).getInputStream());
        }
        bindings.put("readOnly", !writeAllowed);
        return bindings;
    }

    OutputWriter getWriter(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        OutputWriter[] candidates;
        for (OutputWriter candidate : candidates = new OutputWriter[]{new CsvWriter(), new JsonWriter()}) {
            if (!candidate.handleRequest(request)) continue;
            candidate.init(request, response);
            return candidate;
        }
        return null;
    }
}

