/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.PipeMonitorMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeMonitor
implements PipeMonitorMBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PipeMonitor.class);
    String name;
    String path;
    boolean running = false;
    String status;
    long lastStarted;
    long duration;
    int executions = 0;
    int failed = 0;
    long mean;
    Plumber plumber;
    ExecutionResult lastResult;

    public void starts() {
        this.lastStarted = System.currentTimeMillis();
        this.running = true;
        this.status = "started";
    }

    public void ends() {
        this.duration = System.currentTimeMillis() - this.lastStarted;
        this.mean = (this.mean * (long)this.executions + this.duration) / (long)(this.executions + 1);
        ++this.executions;
        this.running = false;
        this.status = "finished";
    }

    @Override
    public long getFailed() {
        return this.failed;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void failed() {
        ++this.failed;
        this.running = false;
        this.status = "finished";
    }

    public PipeMonitor(Plumber currentPlumber, Pipe pipe) {
        this.plumber = currentPlumber;
        this.name = pipe.getName();
        this.path = pipe.getResource().getPath();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getExecutionCount() {
        return this.executions;
    }

    @Override
    public long getMeanDurationMilliseconds() {
        return this.mean;
    }

    public void setLastResult(ExecutionResult result) {
        this.lastResult = result;
    }

    @Override
    public CompositeData getLastResult() {
        try {
            if (this.lastResult != null) {
                return this.lastResult.asCompositeData();
            }
        }
        catch (OpenDataException e) {
            LOGGER.error("unable to dump last result as composite data", (Throwable)e);
        }
        return null;
    }

    @Override
    public String run() {
        HashMap<String, Boolean> bindings = new HashMap<String, Boolean>();
        bindings.put("readOnly", false);
        Job job = this.plumber.executeAsync(this.path, bindings);
        return String.format("Job %s has been created", job.getId());
    }
}

