/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPipe
extends BasePipe {
    public static final String RESOURCE_TYPE = "slingPipes/path";
    public static final String PN_RESOURCETYPE = "nodeType";
    public static final String PN_INTERMEDIATE = "intermediateType";
    public static final String PN_AUTOSAVE = "autosave";
    public static final String SLASH = "/";
    String resourceType;
    String intermediateType;
    boolean autosave;
    private final Logger logger = LoggerFactory.getLogger(PathPipe.class);

    public PathPipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
        this.resourceType = (String)this.properties.get(PN_RESOURCETYPE, (Object)"sling:Folder");
        this.intermediateType = (String)this.properties.get(PN_INTERMEDIATE, (Object)"sling:Folder");
        this.autosave = (Boolean)this.properties.get(PN_AUTOSAVE, (Object)true);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    public Iterator<Resource> getOutput() {
        Iterator<Resource> output = Collections.emptyIterator();
        String expression = this.getExpr();
        try {
            String path = expression.startsWith(SLASH) ? expression : this.getInput().getPath() + SLASH + expression;
            this.logger.info("creating path {}", (Object)path);
            if (!this.isDryRun()) {
                output = Collections.singleton(ResourceUtil.getOrCreateResource((ResourceResolver)this.resolver, (String)path, (String)this.resourceType, (String)this.intermediateType, (boolean)this.autosave)).iterator();
            }
        }
        catch (PersistenceException e) {
            this.logger.error("Not able to create path {}", (Object)expression, (Object)e);
        }
        return output;
    }
}

