/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPropertyPipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(MultiPropertyPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/multiProperty";
    MVResourceIterator iterator;

    public MultiPropertyPipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
    }

    @Override
    public Iterator<Resource> getOutput() {
        this.iterator = new MVResourceIterator(this.getInput());
        return this.iterator;
    }

    @Override
    public Object getOutputBinding() {
        if (this.iterator != null) {
            Value value = this.iterator.getCurrentValue();
            try {
                switch (value.getType()) {
                    case 1: {
                        return value.getString();
                    }
                }
                return value.toString();
            }
            catch (Exception e) {
                logger.error("current value format is not supported", (Throwable)e);
                return value.toString();
            }
        }
        return null;
    }

    static class MVResourceIterator
    implements Iterator<Resource> {
        Resource resource;
        Value currentValue;
        Iterator<Value> itValue = Collections.emptyIterator();

        public MVResourceIterator(Resource resource) {
            this.resource = resource;
            try {
                Property mvProperty = (Property)resource.adaptTo(Property.class);
                if (mvProperty == null) {
                    throw new Exception("input resource " + resource.getPath() + " is supposed to be a property");
                }
                if (!mvProperty.isMultiple()) {
                    throw new Exception("given property " + resource.getPath() + " is supposed to be multiple");
                }
                this.itValue = Arrays.asList(mvProperty.getValues()).iterator();
            }
            catch (Exception e) {
                logger.warn("unable to setup mv iterator for resource, will return nothing", (Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.itValue.hasNext();
        }

        public Value getCurrentValue() {
            return this.currentValue;
        }

        @Override
        public Resource next() {
            if (this.itValue.hasNext()) {
                this.currentValue = this.itValue.next();
            }
            return this.resource;
        }

        @Override
        public void remove() {
        }
    }
}

